/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.appcenter.data.models;

import android.support.annotation.NonNull;
import com.google.gson.annotations.SerializedName;
import com.microsoft.appcenter.data.Utils;
import com.microsoft.appcenter.data.exception.DataException;
import com.microsoft.appcenter.data.models.DocumentMetadata;
import java.util.Date;

public class DocumentWrapper<T>
extends DocumentMetadata {
    @SerializedName(value="_ts")
    private long mLastUpdatedDate;
    @SerializedName(value="document")
    private T mDocument;
    private transient DataException mError;
    private transient boolean mFromDeviceCache;
    private transient String mPendingOperation;

    public DocumentWrapper() {
    }

    public DocumentWrapper(T document, String partition, String id) {
        super(partition, id, null);
        this.mDocument = document;
    }

    public DocumentWrapper(T document, String partition, String id, String eTag, long lastUpdatedDate) {
        this(document, partition, id);
        this.mETag = eTag;
        this.mLastUpdatedDate = lastUpdatedDate;
    }

    public DocumentWrapper(T document, String partition, String id, String eTag, long lastUpdatedDate, DataException exception) {
        this(document, partition, id, eTag, lastUpdatedDate);
        this.mError = exception;
    }

    public DocumentWrapper(Exception exception) {
        this.mError = new DataException(exception);
    }

    public DocumentWrapper(String message, Exception exception) {
        this.mError = new DataException(message, exception);
    }

    public DocumentWrapper(DataException exception) {
        this.mError = exception;
    }

    public T getDeserializedValue() {
        return this.mDocument;
    }

    public DataException getError() {
        return this.mError;
    }

    public Date getLastUpdatedDate() {
        return new Date(this.mLastUpdatedDate * 1000L);
    }

    public String getJsonValue() {
        return this.mDocument == null ? null : Utils.getGson().toJson(this.mDocument);
    }

    @NonNull
    public String toString() {
        return Utils.getGson().toJson((Object)this);
    }

    public boolean isFromDeviceCache() {
        return this.mFromDeviceCache;
    }

    public void setFromCache(boolean fromCache) {
        this.mFromDeviceCache = fromCache;
    }

    public String getPendingOperation() {
        return this.mPendingOperation;
    }

    public void setPendingOperation(String pendingOperation) {
        this.mPendingOperation = pendingOperation;
    }

    public boolean hasFailed() {
        return this.getError() != null;
    }
}

