/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.appcenter.data.client;

import android.support.annotation.VisibleForTesting;
import com.microsoft.appcenter.data.models.TokenResult;
import com.microsoft.appcenter.http.HttpClient;
import com.microsoft.appcenter.http.ServiceCall;
import com.microsoft.appcenter.http.ServiceCallback;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class CosmosDb {
    private static final String DOCUMENT_DB_ENDPOINT = "https://%s.documents.azure.com";
    private static final String DOCUMENT_DB_DATABASE_URL_SUFFIX = "dbs/%s";
    private static final String DOCUMENT_DB_COLLECTION_URL_SUFFIX = "colls/%s";
    private static final String DOCUMENT_DB_DOCUMENT_URL_PREFIX = "docs";
    private static final String X_MS_DOCUMENTDB_IS_UPSERT = "x-ms-documentdb-is-upsert";

    private static String nowAsRFC1123() {
        SimpleDateFormat formatter = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        return formatter.format(new Date()).toLowerCase();
    }

    private static String urlEncode(String url) {
        return CosmosDb.urlEncode(url, "UTF-8");
    }

    @VisibleForTesting
    public static String urlEncode(String url, String enc) {
        try {
            return URLEncoder.encode(url, enc);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Failed to encode url " + url, e);
        }
    }

    public static Map<String, String> addRequiredHeaders(Map<String, String> additionalHeaders, String partition, String dbToken) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("x-ms-documentdb-partitionkey", String.format("[\"%s\"]", partition));
        headers.put("x-ms-version", "2018-06-18");
        headers.put("x-ms-date", CosmosDb.nowAsRFC1123());
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", CosmosDb.urlEncode(dbToken));
        if (additionalHeaders != null) {
            headers.putAll(additionalHeaders);
        }
        return headers;
    }

    private static String getDocumentDbEndpoint(String dbAccount, String documentResourceId) {
        return String.format(DOCUMENT_DB_ENDPOINT, dbAccount) + "/" + documentResourceId;
    }

    public static String getDocumentBaseUrl(String databaseName, String collectionName, String documentId) {
        return String.format(DOCUMENT_DB_DATABASE_URL_SUFFIX, CosmosDb.urlEncode(databaseName)) + "/" + String.format(DOCUMENT_DB_COLLECTION_URL_SUFFIX, CosmosDb.urlEncode(collectionName)) + "/" + DOCUMENT_DB_DOCUMENT_URL_PREFIX + (documentId == null ? "" : '/' + CosmosDb.urlEncode(documentId));
    }

    private static String getDocumentUrl(TokenResult tokenResult, String documentId) {
        String documentResourceIdPrefix = CosmosDb.getDocumentBaseUrl(tokenResult.getDbName(), tokenResult.getDbCollectionName(), documentId);
        return CosmosDb.getDocumentDbEndpoint(tokenResult.getDbAccount(), documentResourceIdPrefix);
    }

    public static synchronized ServiceCall callCosmosDbListApi(TokenResult tokenResult, String continuationToken, HttpClient httpClient, ServiceCallback serviceCallback) {
        Map<String, String> headers = CosmosDb.addRequiredHeaders(null, tokenResult.getPartition(), tokenResult.getToken());
        if (continuationToken != null) {
            headers.put("x-ms-continuation", continuationToken);
        }
        return CosmosDb.callApi("GET", CosmosDb.getDocumentUrl(tokenResult, null), headers, null, httpClient, serviceCallback);
    }

    public static synchronized ServiceCall callCosmosDbApi(TokenResult tokenResult, String documentId, HttpClient httpClient, String httpVerb, String body, ServiceCallback serviceCallback) {
        return CosmosDb.callCosmosDbApi(tokenResult, documentId, httpClient, httpVerb, body, new HashMap<String, String>(), serviceCallback);
    }

    public static ServiceCall callCosmosDbApi(TokenResult tokenResult, String documentId, HttpClient httpClient, String httpVerb, String body, Map<String, String> additionalHeaders, ServiceCallback serviceCallback) {
        Map<String, String> headers = CosmosDb.addRequiredHeaders(additionalHeaders, tokenResult.getPartition(), tokenResult.getToken());
        return CosmosDb.callApi(httpVerb, CosmosDb.getDocumentUrl(tokenResult, documentId), headers, body, httpClient, serviceCallback);
    }

    public static Map<String, String> getUpsertAdditionalHeader() {
        return new HashMap<String, String>(){
            {
                this.put(CosmosDb.X_MS_DOCUMENTDB_IS_UPSERT, "true");
            }
        };
    }

    private static ServiceCall callApi(String httpVerb, String url, Map<String, String> headers, final String body, HttpClient httpClient, ServiceCallback serviceCallback) {
        return httpClient.callAsync(url, httpVerb, headers, new HttpClient.CallTemplate(){

            public String buildRequestBody() {
                return body;
            }

            public void onBeforeCalling(URL url, Map<String, String> headers) {
            }
        }, serviceCallback);
    }
}

