/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.appcenter.data.models;

import android.support.annotation.NonNull;
import com.microsoft.appcenter.data.models.DocumentWrapper;
import com.microsoft.appcenter.data.models.NextPageDelegate;
import com.microsoft.appcenter.data.models.Page;
import com.microsoft.appcenter.data.models.ReadOptions;
import com.microsoft.appcenter.data.models.TokenResult;
import com.microsoft.appcenter.utils.AppCenterLog;
import com.microsoft.appcenter.utils.async.AppCenterConsumer;
import com.microsoft.appcenter.utils.async.AppCenterFuture;
import com.microsoft.appcenter.utils.async.DefaultAppCenterFuture;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class PaginatedDocuments<T>
implements Iterable<DocumentWrapper<T>> {
    private transient Page<T> mCurrentPage;
    private transient TokenResult mTokenResult;
    private transient Class<T> mDocumentType;
    private transient ReadOptions mReadOptions;
    private transient NextPageDelegate mNextPageDelegate;
    private transient String mContinuationToken;

    public PaginatedDocuments<T> setTokenResult(TokenResult tokenResult) {
        this.mTokenResult = tokenResult;
        return this;
    }

    public boolean hasNextPage() {
        return this.mContinuationToken != null;
    }

    public PaginatedDocuments<T> setCurrentPage(Page<T> currentPage) {
        this.mCurrentPage = currentPage;
        return this;
    }

    public Page<T> getCurrentPage() {
        return this.mCurrentPage;
    }

    public PaginatedDocuments<T> setContinuationToken(String continuationToken) {
        this.mContinuationToken = continuationToken;
        return this;
    }

    public PaginatedDocuments<T> setReadOptions(ReadOptions readOptions) {
        this.mReadOptions = readOptions;
        return this;
    }

    public PaginatedDocuments<T> setNextPageDelegate(NextPageDelegate nextPageDelegate) {
        this.mNextPageDelegate = nextPageDelegate;
        return this;
    }

    public PaginatedDocuments<T> setDocumentType(Class<T> documentType) {
        this.mDocumentType = documentType;
        return this;
    }

    public synchronized AppCenterFuture<Page<T>> getNextPage() {
        final DefaultAppCenterFuture result = new DefaultAppCenterFuture();
        if (this.hasNextPage() && this.mNextPageDelegate != null) {
            DefaultAppCenterFuture paginatedResult = new DefaultAppCenterFuture();
            this.mNextPageDelegate.loadNextPage(this.mTokenResult, paginatedResult, this.mReadOptions, this.mDocumentType, this.mContinuationToken);
            paginatedResult.thenAccept(new AppCenterConsumer<PaginatedDocuments<T>>(){

                public void accept(PaginatedDocuments<T> docs) {
                    PaginatedDocuments.this.setCurrentPage(docs.mCurrentPage);
                    PaginatedDocuments.this.setContinuationToken(docs.mContinuationToken);
                    PaginatedDocuments.this.setNextPageDelegate(docs.mNextPageDelegate);
                    result.complete(PaginatedDocuments.this.getCurrentPage());
                }
            });
        } else {
            result.complete(new Page(new NoSuchElementException()));
        }
        return result;
    }

    @Override
    @NonNull
    public Iterator<DocumentWrapper<T>> iterator() {
        return new Iterator<DocumentWrapper<T>>(){
            private int mCurrentIndex = 0;

            @Override
            public boolean hasNext() {
                List items = PaginatedDocuments.this.getCurrentPage().getItems();
                return items != null && this.mCurrentIndex < items.size() || PaginatedDocuments.this.hasNextPage();
            }

            @Override
            public DocumentWrapper<T> next() {
                if (!this.hasNext()) {
                    return new DocumentWrapper(new NoSuchElementException());
                }
                if (this.mCurrentIndex >= PaginatedDocuments.this.getCurrentPage().getItems().size()) {
                    PaginatedDocuments.this.mCurrentPage = (Page)PaginatedDocuments.this.getNextPage().get();
                    this.mCurrentIndex = 0;
                }
                return PaginatedDocuments.this.getCurrentPage().getItems().get(this.mCurrentIndex++);
            }

            @Override
            public void remove() {
                AppCenterLog.error((String)"AppCenterData", (String)"Remove operation is not supported in the iterator.", (Throwable)new UnsupportedOperationException());
            }
        };
    }
}

