/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.appcenter.data.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.microsoft.appcenter.data.TokenManager;
import com.microsoft.appcenter.data.Utils;
import com.microsoft.appcenter.data.exception.DataException;
import com.microsoft.appcenter.data.models.TokenResult;
import com.microsoft.appcenter.data.models.TokensResponse;
import com.microsoft.appcenter.http.AbstractAppCallTemplate;
import com.microsoft.appcenter.http.HttpClient;
import com.microsoft.appcenter.http.ServiceCall;
import com.microsoft.appcenter.http.ServiceCallback;
import com.microsoft.appcenter.utils.AppCenterLog;
import com.microsoft.appcenter.utils.context.AuthTokenContext;
import java.util.HashMap;
import java.util.Map;

public class TokenExchange {
    public static final String GET_TOKEN_PATH_FORMAT = "/data/tokens";

    public static String buildAppCenterGetDbTokenBodyPayload(String partition) {
        JsonArray partitionsArray = new JsonArray();
        partitionsArray.add(partition);
        JsonObject partitionsObject = new JsonObject();
        partitionsObject.add("partitions", (JsonElement)partitionsArray);
        return partitionsObject.toString();
    }

    public static synchronized ServiceCall getDbToken(final String partition, HttpClient httpClient, String tokenExchangeUrl, final String appSecret, TokenExchangeServiceCallback serviceCallback) {
        AppCenterLog.debug((String)"AppCenterData", (String)"Getting a resource token from App Center...");
        String url = tokenExchangeUrl + GET_TOKEN_PATH_FORMAT;
        final String userToken = AuthTokenContext.getInstance().getAuthToken();
        return httpClient.callAsync(url, "POST", (Map)new HashMap<String, String>(){
            {
                this.put("App-Secret", appSecret);
                if (userToken != null) {
                    this.put("Authorization", String.format("Bearer %s", userToken));
                }
            }
        }, (HttpClient.CallTemplate)new AbstractAppCallTemplate(){

            public String buildRequestBody() {
                return TokenExchange.buildAppCenterGetDbTokenBodyPayload(partition);
            }
        }, (ServiceCallback)serviceCallback);
    }

    public static abstract class TokenExchangeServiceCallback
    implements ServiceCallback {
        private final TokenManager mTokenManager;

        protected TokenExchangeServiceCallback(TokenManager tokenManager) {
            this.mTokenManager = tokenManager;
        }

        public void onCallSucceeded(String payload, Map<String, String> headers) {
            try {
                TokenResult tokenResult = this.parseTokenResult(payload);
                if (tokenResult == null) {
                    String message = "Call to App Center Token Exchange Service succeeded but the resulting payload indicates a failed state: " + payload;
                    this.onCallFailed(new DataException(message));
                } else {
                    this.callCosmosDb(tokenResult);
                }
            }
            catch (JsonParseException e) {
                String message = "Token response is not valid JSON";
                this.onCallFailed(new DataException(message, (Exception)((Object)e)));
            }
        }

        public void onCallFailed(Exception e) {
            this.completeFuture(e);
        }

        private TokenResult parseTokenResult(String payload) {
            TokensResponse tokensResponse = (TokensResponse)Utils.getGson().fromJson(payload, TokensResponse.class);
            if (tokensResponse != null && tokensResponse.getTokens() != null && tokensResponse.getTokens().size() == 1 && tokensResponse.getTokens().get(0).getStatus().equalsIgnoreCase("Succeed")) {
                TokenResult tokenResult = tokensResponse.getTokens().get(0);
                if (!Utils.isValidTokenResult(tokenResult)) {
                    AppCenterLog.warn((String)"AppCenterData", (String)"Getting an invalid token from token exchange service.");
                    return null;
                }
                this.mTokenManager.setCachedToken(tokenResult);
                return tokenResult;
            }
            return null;
        }

        public abstract void completeFuture(Exception var1);

        public abstract void callCosmosDb(TokenResult var1);
    }
}

