/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.appcenter.data;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.annotation.WorkerThread;
import com.google.gson.JsonElement;
import com.microsoft.appcenter.AbstractAppCenterService;
import com.microsoft.appcenter.channel.Channel;
import com.microsoft.appcenter.data.LocalDocumentStorage;
import com.microsoft.appcenter.data.TokenManager;
import com.microsoft.appcenter.data.Utils;
import com.microsoft.appcenter.data.client.CosmosDb;
import com.microsoft.appcenter.data.client.TokenExchange;
import com.microsoft.appcenter.data.exception.DataException;
import com.microsoft.appcenter.data.models.DocumentMetadata;
import com.microsoft.appcenter.data.models.DocumentWrapper;
import com.microsoft.appcenter.data.models.LocalDocument;
import com.microsoft.appcenter.data.models.NextPageDelegate;
import com.microsoft.appcenter.data.models.Page;
import com.microsoft.appcenter.data.models.PaginatedDocuments;
import com.microsoft.appcenter.data.models.ReadOptions;
import com.microsoft.appcenter.data.models.RemoteOperationListener;
import com.microsoft.appcenter.data.models.TokenResult;
import com.microsoft.appcenter.data.models.WriteOptions;
import com.microsoft.appcenter.http.HttpClient;
import com.microsoft.appcenter.http.HttpException;
import com.microsoft.appcenter.http.HttpUtils;
import com.microsoft.appcenter.http.ServiceCall;
import com.microsoft.appcenter.http.ServiceCallback;
import com.microsoft.appcenter.utils.AppCenterLog;
import com.microsoft.appcenter.utils.NetworkStateHelper;
import com.microsoft.appcenter.utils.async.AppCenterFuture;
import com.microsoft.appcenter.utils.async.DefaultAppCenterFuture;
import com.microsoft.appcenter.utils.context.AbstractTokenContextListener;
import com.microsoft.appcenter.utils.context.AuthTokenContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Data
extends AbstractAppCenterService
implements NetworkStateHelper.Listener {
    @SuppressLint(value={"StaticFieldLeak"})
    private static Data sInstance;
    private final HashMap<String, ServiceCall> mOutgoingPendingOperationCalls = new HashMap();
    private String mAppSecret;
    private String mTokenExchangeUrl = "https://tokens.appcenter.ms/v0.1";
    private final Map<DefaultAppCenterFuture<?>, ServiceCall> mPendingCalls = new HashMap();
    private HttpClient mHttpClient;
    private TokenManager mTokenManager;
    private LocalDocumentStorage mLocalDocumentStorage;
    private volatile RemoteOperationListener mRemoteOperationListener;
    private AuthTokenContext.Listener mAuthListener;
    private NetworkStateHelper mNetworkStateHelper;
    private final Pattern sDocumentIdPattern = Pattern.compile("^[^/\\\\#\\s?]+$");

    public static synchronized Data getInstance() {
        if (sInstance == null) {
            sInstance = new Data();
        }
        return sInstance;
    }

    @VisibleForTesting
    static synchronized void unsetInstance() {
        sInstance = null;
    }

    public static void setTokenExchangeUrl(String tokenExchangeUrl) {
        Data.getInstance().setInstanceTokenExchangeUrl(tokenExchangeUrl);
    }

    public static AppCenterFuture<Boolean> isEnabled() {
        return Data.getInstance().isInstanceEnabledAsync();
    }

    public static AppCenterFuture<Void> setEnabled(boolean enabled) {
        return Data.getInstance().setInstanceEnabledAsync(enabled);
    }

    public static <T> AppCenterFuture<DocumentWrapper<T>> read(String documentId, Class<T> documentType, String partition) {
        return Data.read(documentId, documentType, partition, new ReadOptions());
    }

    public static <T> AppCenterFuture<DocumentWrapper<T>> read(String documentId, Class<T> documentType, String partition, ReadOptions readOptions) {
        return Data.getInstance().instanceRead(documentId, documentType, partition, ReadOptions.ensureNotNull(readOptions));
    }

    public static <T> AppCenterFuture<PaginatedDocuments<T>> list(Class<T> documentType, String partition) {
        return Data.list(documentType, partition, new ReadOptions());
    }

    public static <T> AppCenterFuture<PaginatedDocuments<T>> list(Class<T> documentType, String partition, ReadOptions readOptions) {
        return Data.getInstance().instanceList(documentType, partition, ReadOptions.ensureNotNull(readOptions));
    }

    public static <T> AppCenterFuture<DocumentWrapper<T>> create(String documentId, T document, Class<T> documentType, String partition) {
        return Data.create(documentId, document, documentType, partition, new WriteOptions());
    }

    public static <T> AppCenterFuture<DocumentWrapper<T>> create(String documentId, T document, Class<T> documentType, String partition, WriteOptions writeOptions) {
        return Data.getInstance().instanceCreateOrUpdate(documentId, document, documentType, partition, WriteOptions.ensureNotNull(writeOptions), null);
    }

    public static AppCenterFuture<DocumentWrapper<Void>> delete(String documentId, String partition) {
        return Data.delete(documentId, partition, new WriteOptions());
    }

    public static AppCenterFuture<DocumentWrapper<Void>> delete(String documentId, String partition, WriteOptions writeOptions) {
        return Data.getInstance().instanceDelete(documentId, partition, WriteOptions.ensureNotNull(writeOptions));
    }

    public static <T> AppCenterFuture<DocumentWrapper<T>> replace(String documentId, T document, Class<T> documentType, String partition) {
        return Data.replace(documentId, document, documentType, partition, new WriteOptions());
    }

    public static <T> AppCenterFuture<DocumentWrapper<T>> replace(String documentId, T document, Class<T> documentType, String partition, WriteOptions writeOptions) {
        return Data.getInstance().instanceCreateOrUpdate(documentId, document, documentType, partition, WriteOptions.ensureNotNull(writeOptions), CosmosDb.getUpsertAdditionalHeader());
    }

    public static void setRemoteOperationListener(RemoteOperationListener listener) {
        Data.getInstance().mRemoteOperationListener = listener;
    }

    private static DataException getInvalidPartitionDataException(String partition) {
        return new DataException(String.format("Partition name can be either '%s' or '%s' but not '%s'.", "readonly", "user", partition));
    }

    private static IllegalStateException getModuleNotStartedException() {
        return new IllegalStateException("Data module is either disabled or has not been started. Add `Data.class` to the `AppCenter.start(...)` call.");
    }

    private synchronized void setInstanceTokenExchangeUrl(String tokenExchangeUrl) {
        this.mTokenExchangeUrl = tokenExchangeUrl;
    }

    public synchronized void onStarted(@NonNull Context context, @NonNull Channel channel, String appSecret, String transmissionTargetToken, boolean startedFromApp) {
        this.mNetworkStateHelper = NetworkStateHelper.getSharedInstance((Context)context);
        this.mHttpClient = HttpUtils.createHttpClient((Context)context, (boolean)false);
        this.mTokenManager = TokenManager.getInstance(context);
        this.mAppSecret = appSecret;
        this.mLocalDocumentStorage = new LocalDocumentStorage(context, Utils.getUserTableName());
        this.mAuthListener = new AbstractTokenContextListener(){

            public void onNewUser(String accountId) {
                if (accountId == null) {
                    Data.this.mTokenManager.removeAllCachedTokens();
                    Data.this.mLocalDocumentStorage.resetDatabase();
                } else {
                    String userTable = Utils.getUserTableName(accountId);
                    Data.this.mLocalDocumentStorage.createTableIfDoesNotExist(userTable);
                }
            }
        };
        super.onStarted(context, channel, appSecret, transmissionTargetToken, startedFromApp);
    }

    public void onNetworkStateUpdated(boolean connected) {
        if (connected) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    Data.this.processPendingOperations();
                }
            });
        }
    }

    private synchronized void processPendingOperations() {
        for (LocalDocument localDocument : this.mLocalDocumentStorage.getPendingOperations(Utils.getUserTableName())) {
            String outgoingId = Utils.getOutgoingId(localDocument.getPartition(), localDocument.getDocumentId());
            if (this.mOutgoingPendingOperationCalls.containsKey(outgoingId)) continue;
            this.mOutgoingPendingOperationCalls.put(outgoingId, null);
            if ("CREATE".equals(localDocument.getOperation()) || "REPLACE".equals(localDocument.getOperation())) {
                this.instanceCreateOrUpdate(localDocument);
                continue;
            }
            if ("DELETE".equals(localDocument.getOperation())) {
                this.instanceDelete(localDocument);
                continue;
            }
            AppCenterLog.debug((String)"AppCenterData", (String)String.format("Pending operation '%s' is not supported.", localDocument.getOperation()));
        }
    }

    protected synchronized void applyEnabledState(boolean enabled) {
        if (enabled) {
            AuthTokenContext.getInstance().addListener(this.mAuthListener);
            this.mNetworkStateHelper.addListener((NetworkStateHelper.Listener)this);
            if (this.mNetworkStateHelper.isNetworkConnected()) {
                this.processPendingOperations();
            }
        } else {
            for (Map.Entry<DefaultAppCenterFuture<?>, ServiceCall> entry : this.mPendingCalls.entrySet()) {
                entry.getKey().complete(null);
                entry.getValue().cancel();
            }
            AuthTokenContext.getInstance().removeListener(this.mAuthListener);
            this.mNetworkStateHelper.removeListener((NetworkStateHelper.Listener)this);
            this.mPendingCalls.clear();
            for (Map.Entry<Object, ServiceCall> entry : this.mOutgoingPendingOperationCalls.entrySet()) {
                if (entry.getValue() == null) continue;
                entry.getValue().cancel();
            }
            this.mOutgoingPendingOperationCalls.clear();
        }
    }

    protected String getGroupName() {
        return "group_data";
    }

    public String getServiceName() {
        return "Data";
    }

    protected String getLoggerTag() {
        return "AppCenterData";
    }

    private <T> DefaultAppCenterFuture<DocumentWrapper<T>> performOperation(final @NonNull String partition, final @NonNull String documentId, final @NonNull Class<T> documentType, final @Nullable ReadOptions cacheReadOptions, final @NonNull CallTemplate<T> callTemplate) {
        final DefaultAppCenterFuture result = new DefaultAppCenterFuture();
        if (this.isInvalidStateOrParameters(partition, documentId, result)) {
            return result;
        }
        this.postAsyncGetter(new Runnable(){

            @Override
            public void run() {
                DocumentWrapper cachedDocument;
                String table = null;
                TokenResult cachedToken = Data.this.getCachedToken(partition);
                if (cachedToken != null) {
                    table = Utils.getTableName(cachedToken);
                    cachedDocument = Data.this.mLocalDocumentStorage.read(table, cachedToken.getPartition(), documentId, documentType, cacheReadOptions);
                    if ("DELETE".equals(cachedDocument.getPendingOperation())) {
                        cachedDocument = new DocumentWrapper(new DataException("The document is found in local storage but marked as state deleted."));
                    }
                } else {
                    cachedDocument = new DocumentWrapper(new DataException("Unable to find partition named " + partition + "."));
                }
                if (callTemplate.needsRemoteOperation(cachedDocument)) {
                    if (Data.this.mNetworkStateHelper.isNetworkConnected()) {
                        Data.this.getTokenAndCallCosmosDbApi(partition, result, new TokenExchange.TokenExchangeServiceCallback(Data.this.mTokenManager){

                            @Override
                            public void callCosmosDb(TokenResult tokenResult) {
                                callTemplate.callCosmosDb(tokenResult, result);
                            }

                            @Override
                            public void completeFuture(Exception e) {
                                Data.this.completeFuture(e, result);
                            }
                        });
                    } else {
                        Data.this.doOfflineOperation(cachedDocument, table, cachedToken, result, callTemplate);
                    }
                } else {
                    Data.this.doOfflineOperation(cachedDocument, table, cachedToken, result, callTemplate);
                }
            }
        }, result, new DocumentWrapper(Data.getModuleNotStartedException()));
        return result;
    }

    private <T> void doOfflineOperation(DocumentWrapper<T> cachedDocument, String table, TokenResult cachedToken, DefaultAppCenterFuture<DocumentWrapper<T>> result, CallTemplate<T> callTemplate) {
        if (cachedToken == null) {
            result.complete(cachedDocument);
        } else {
            DocumentWrapper<T> documentResult = callTemplate.doOfflineOperation(cachedDocument, table, cachedToken);
            this.completeFuture(documentResult, result);
        }
    }

    @WorkerThread
    private synchronized <T> AppCenterFuture<DocumentWrapper<T>> instanceRead(final String documentId, final Class<T> documentType, String partition, ReadOptions readOptions) {
        return this.performOperation(partition, documentId, documentType, readOptions, new CallTemplate<T>(){

            @Override
            public boolean needsRemoteOperation(DocumentWrapper<T> cachedDocument) {
                return cachedDocument.getPendingOperation() == null;
            }

            @Override
            public DocumentWrapper<T> doOfflineOperation(DocumentWrapper<T> cachedDocument, String table, TokenResult cachedToken) {
                return cachedDocument;
            }

            @Override
            public void callCosmosDb(TokenResult tokenResult, DefaultAppCenterFuture<DocumentWrapper<T>> result) {
                Data.this.callCosmosDbReadApi(tokenResult, documentId, documentType, result);
            }
        });
    }

    private synchronized AppCenterFuture<DocumentWrapper<Void>> instanceDelete(final String documentId, final String partition, final WriteOptions writeOptions) {
        return this.performOperation(partition, documentId, Void.class, null, new CallTemplate<Void>(){

            @Override
            public boolean needsRemoteOperation(DocumentWrapper<Void> cachedDocument) {
                return cachedDocument.getETag() != null || cachedDocument.getError() != null;
            }

            @Override
            public DocumentWrapper<Void> doOfflineOperation(DocumentWrapper<Void> cachedDocument, String table, TokenResult cachedToken) {
                boolean success = cachedDocument.getETag() != null ? Data.this.mLocalDocumentStorage.deleteOffline(table, cachedDocument, writeOptions) : Data.this.mLocalDocumentStorage.deleteOnline(table, cachedToken.getPartition(), documentId);
                if (success) {
                    return cachedDocument;
                }
                return new DocumentWrapper<Void>(new DataException("Failed to write to cache."));
            }

            @Override
            public void callCosmosDb(TokenResult tokenResult, DefaultAppCenterFuture<DocumentWrapper<Void>> result) {
                Data.this.callCosmosDbDeleteApi(tokenResult, partition, documentId, (DefaultAppCenterFuture<DocumentWrapper<Void>>)result);
            }
        });
    }

    private synchronized <T> void callCosmosDbReadApi(final TokenResult tokenResult, String documentId, final Class<T> documentType, final DefaultAppCenterFuture<DocumentWrapper<T>> result) {
        ServiceCall cosmosDbCall = CosmosDb.callCosmosDbApi(tokenResult, documentId, this.mHttpClient, "GET", null, new ServiceCallback(){

            @MainThread
            public void onCallSucceeded(final String payload, Map<String, String> headers) {
                Data.this.post(new Runnable(){

                    @Override
                    public void run() {
                        DocumentWrapper document = Utils.parseDocument(payload, documentType);
                        if (document.getError() != null) {
                            Data.this.completeFutureOnDocumentError(document, result);
                        } else {
                            Data.this.completeFutureAndSaveToLocalStorage(Utils.getTableName(tokenResult), document, result);
                        }
                    }
                });
            }

            public void onCallFailed(Exception e) {
                Data.this.completeFuture(e, result);
            }
        });
        this.mPendingCalls.put(result, cosmosDbCall);
    }

    private synchronized <T> void callCosmosDbListApi(final TokenResult tokenResult, final DefaultAppCenterFuture<PaginatedDocuments<T>> result, final ReadOptions readOptions, final Class<T> documentType, String continuationToken) {
        if (continuationToken != null && !this.mNetworkStateHelper.isNetworkConnected()) {
            this.completeFutureAndRemovePendingCallWhenDocuments(new DataException("Listing next page is not supported in off-line mode."), result);
            return;
        }
        ServiceCall cosmosDbCall = CosmosDb.callCosmosDbListApi(tokenResult, continuationToken, this.mHttpClient, new ServiceCallback(){

            public void onCallSucceeded(String payload, Map<String, String> headers) {
                Page page = Utils.parseDocuments(payload, documentType);
                String tableName = Utils.getTableName(tokenResult);
                List items = page.getItems();
                if (items != null) {
                    for (DocumentWrapper document : items) {
                        if (document.getError() != null) continue;
                        Data.this.mLocalDocumentStorage.writeOnline(tableName, document, new WriteOptions(readOptions.getDeviceTimeToLive()));
                    }
                }
                PaginatedDocuments paginatedDocuments = new PaginatedDocuments().setCurrentPage(page).setTokenResult(tokenResult).setContinuationToken(headers.get("x-ms-continuation")).setReadOptions(readOptions).setDocumentType(documentType).setNextPageDelegate(new NextPageDelegate(){

                    public <TDocument> void loadNextPage(TokenResult tokenResult, DefaultAppCenterFuture<PaginatedDocuments<TDocument>> result, ReadOptions readOptions, Class<TDocument> documentType, String continuationToken) {
                        Data.this.callCosmosDbListApi(tokenResult, result, readOptions, documentType, continuationToken);
                    }
                });
                Data.this.completeFuture(paginatedDocuments, result);
            }

            public void onCallFailed(Exception e) {
                Data.this.completeFutureAndRemovePendingCallWhenDocuments(e, result);
            }
        });
        this.mPendingCalls.put(result, cosmosDbCall);
    }

    private synchronized <T> AppCenterFuture<PaginatedDocuments<T>> instanceList(final Class<T> documentType, final String partition, final ReadOptions readOptions) {
        final DefaultAppCenterFuture result = new DefaultAppCenterFuture();
        if (this.isInvalidStateOrParametersWhenDocuments(partition, result)) {
            return result;
        }
        this.postAsyncGetter(new Runnable(){

            @Override
            public void run() {
                List<Object> localDocuments;
                String tableName = Utils.getTableName(partition);
                if (tableName == null) {
                    Data.this.completeFutureAndRemovePendingCallWhenDocuments(new DataException("List operation requested on user partition, but the user is not logged in."), result);
                    return;
                }
                TokenResult cachedTokenResult = Data.this.mTokenManager.getCachedToken(partition, true);
                if (cachedTokenResult == null && !Data.this.mNetworkStateHelper.isNetworkConnected()) {
                    Data.this.completeFutureAndRemovePendingCallWhenDocuments(new DataException("List operation requested on a partition, but no network."), result);
                    return;
                }
                if (cachedTokenResult != null) {
                    localDocuments = Data.this.mLocalDocumentStorage.getDocumentsByPartition(tableName, cachedTokenResult.getPartition(), readOptions);
                    if (LocalDocumentStorage.hasPendingOperation(localDocuments)) {
                        Data.this.completeFuture(Utils.localDocumentsToNonExpiredPaginated(localDocuments, documentType), result);
                        return;
                    }
                } else {
                    localDocuments = new ArrayList();
                }
                if (!Data.this.mNetworkStateHelper.isNetworkConnected()) {
                    Data.this.completeFuture(Utils.localDocumentsToNonExpiredPaginated(localDocuments, documentType), result);
                    return;
                }
                Data.this.getTokenAndCallCosmosDbApi(partition, result, new TokenExchange.TokenExchangeServiceCallback(Data.this.mTokenManager){

                    @Override
                    public void callCosmosDb(TokenResult tokenResult) {
                        Data.this.callCosmosDbListApi(tokenResult, result, readOptions, documentType, null);
                    }

                    @Override
                    public void completeFuture(Exception e) {
                        Data.this.completeFutureAndRemovePendingCallWhenDocuments(e, result);
                    }
                });
            }
        }, result, new PaginatedDocuments().setCurrentPage(new Page(Data.getModuleNotStartedException())));
        return result;
    }

    private synchronized void instanceCreateOrUpdate(final LocalDocument pendingOperation) {
        this.getTokenAndCallCosmosDbApi(Utils.removeAccountIdFromPartitionName(pendingOperation.getPartition()), null, new TokenExchange.TokenExchangeServiceCallback(this.mTokenManager){

            @Override
            public void callCosmosDb(TokenResult tokenResult) {
                Data.this.callCosmosDbCreateOrUpdateApi(tokenResult, pendingOperation);
            }

            @Override
            @MainThread
            public void completeFuture(Exception e) {
                Data.this.notifyListenerAndUpdateOperationOnFailure(new DataException("Failed to get Cosmos DB token for performing a create or update operation.", e), pendingOperation);
            }
        });
    }

    @WorkerThread
    private synchronized <T> void callCosmosDbCreateOrUpdateApi(final TokenResult tokenResult, T document, final Class<T> documentType, String partition, String documentId, final WriteOptions writeOptions, Map<String, String> additionalHeaders, final DefaultAppCenterFuture<DocumentWrapper<T>> result) {
        ServiceCall cosmosDbCall = CosmosDb.callCosmosDbApi(tokenResult, null, this.mHttpClient, "POST", new DocumentWrapper<T>(document, partition, documentId).toString(), additionalHeaders, new ServiceCallback(){

            @MainThread
            public void onCallSucceeded(final String payload, Map<String, String> headers) {
                Data.this.post(new Runnable(){

                    @Override
                    public void run() {
                        DocumentWrapper cosmosDbDocument = Utils.parseDocument(payload, documentType);
                        if (cosmosDbDocument.hasFailed()) {
                            Data.this.completeFutureOnDocumentError(cosmosDbDocument, result);
                        } else {
                            Data.this.completeFuture(cosmosDbDocument, result);
                            Data.this.mLocalDocumentStorage.writeOnline(Utils.getTableName(tokenResult), cosmosDbDocument, writeOptions);
                        }
                    }
                });
            }

            public void onCallFailed(Exception e) {
                Data.this.completeFuture(e, result);
            }
        });
        this.mPendingCalls.put(result, cosmosDbCall);
    }

    private synchronized void callCosmosDbCreateOrUpdateApi(TokenResult tokenResult, final LocalDocument pendingOperation) {
        String outgoingId = Utils.getOutgoingId(pendingOperation.getPartition(), pendingOperation.getDocumentId());
        JsonElement documentPayload = (JsonElement)Utils.getGson().fromJson(pendingOperation.getDocument(), JsonElement.class);
        DocumentWrapper<JsonElement> documentWrapper = new DocumentWrapper<JsonElement>(documentPayload, pendingOperation.getPartition(), pendingOperation.getDocumentId(), pendingOperation.getETag(), 0L);
        this.mOutgoingPendingOperationCalls.put(outgoingId, CosmosDb.callCosmosDbApi(tokenResult, null, this.mHttpClient, "POST", documentWrapper.toString(), pendingOperation.getOperation().equals("CREATE") ? null : CosmosDb.getUpsertAdditionalHeader(), new ServiceCallback(){

            @MainThread
            public void onCallSucceeded(String payload, Map<String, String> headers) {
                Data.this.notifyListenerAndUpdateOperationOnSuccess(payload, pendingOperation);
            }

            @MainThread
            public void onCallFailed(Exception e) {
                Data.this.notifyListenerAndUpdateOperationOnFailure(new DataException("Failed to call Cosmos create or replace API", e), pendingOperation);
            }
        }));
    }

    private synchronized <T> AppCenterFuture<DocumentWrapper<T>> instanceCreateOrUpdate(final String documentId, final T document, final Class<T> documentType, final String partition, final WriteOptions writeOptions, final Map<String, String> additionalHeaders) {
        final DefaultAppCenterFuture result = new DefaultAppCenterFuture();
        if (this.isInvalidStateOrParameters(partition, documentId, result)) {
            return result;
        }
        this.postAsyncGetter(new Runnable(){

            @Override
            public void run() {
                if (Data.this.mNetworkStateHelper.isNetworkConnected()) {
                    Data.this.getTokenAndCallCosmosDbApi(partition, result, new TokenExchange.TokenExchangeServiceCallback(Data.this.mTokenManager){

                        @Override
                        public void callCosmosDb(TokenResult tokenResult) {
                            Data.this.callCosmosDbCreateOrUpdateApi(tokenResult, document, documentType, tokenResult.getPartition(), documentId, writeOptions, additionalHeaders, result);
                        }

                        @Override
                        public void completeFuture(Exception e) {
                            Data.this.completeFuture(e, result);
                        }
                    });
                } else {
                    DocumentWrapper<Object> createdOrUpdatedDocument;
                    TokenResult cachedToken = Data.this.getCachedToken(partition);
                    if (cachedToken != null) {
                        String table = Utils.getTableName(cachedToken);
                        createdOrUpdatedDocument = Data.this.mLocalDocumentStorage.createOrUpdateOffline(table, cachedToken.getPartition(), documentId, document, documentType, writeOptions);
                    } else {
                        createdOrUpdatedDocument = new DocumentWrapper(new DataException("Unable to find partition named " + partition + "."));
                    }
                    result.complete(createdOrUpdatedDocument);
                }
            }
        }, result, new DocumentWrapper(Data.getModuleNotStartedException()));
        return result;
    }

    private synchronized void instanceDelete(final LocalDocument pendingOperation) {
        this.getTokenAndCallCosmosDbApi(Utils.removeAccountIdFromPartitionName(pendingOperation.getPartition()), null, new TokenExchange.TokenExchangeServiceCallback(this.mTokenManager){

            @Override
            public void callCosmosDb(TokenResult tokenResult) {
                Data.this.callCosmosDbDeleteApi(tokenResult, pendingOperation);
            }

            @Override
            @MainThread
            public void completeFuture(Exception e) {
                Data.this.notifyListenerAndUpdateOperationOnFailure(new DataException("Failed to get Cosmos DB token for performing a delete operation.", e), pendingOperation);
            }
        });
    }

    @WorkerThread
    private synchronized void callCosmosDbDeleteApi(final TokenResult tokenResult, final String partition, final String documentId, final DefaultAppCenterFuture<DocumentWrapper<Void>> result) {
        ServiceCall cosmosDbCall = CosmosDb.callCosmosDbApi(tokenResult, documentId, this.mHttpClient, "DELETE", null, new ServiceCallback(){

            @MainThread
            public void onCallSucceeded(String payload, Map<String, String> headers) {
                Data.this.post(new Runnable(){

                    @Override
                    public void run() {
                        DocumentWrapper<Object> wrapper = new DocumentWrapper<Object>(null, partition, documentId);
                        Data.this.completeFuture(wrapper, result);
                        Data.this.mLocalDocumentStorage.deleteOnline(Utils.getTableName(tokenResult), tokenResult.getPartition(), documentId);
                    }
                });
            }

            public void onCallFailed(Exception e) {
                Data.this.completeFuture(e, result);
            }
        });
        this.mPendingCalls.put(result, cosmosDbCall);
    }

    private synchronized void callCosmosDbDeleteApi(TokenResult tokenResult, final LocalDocument operation) {
        String outgoingId = Utils.getOutgoingId(operation.getPartition(), operation.getDocumentId());
        this.mOutgoingPendingOperationCalls.put(outgoingId, CosmosDb.callCosmosDbApi(tokenResult, operation.getDocumentId(), this.mHttpClient, "DELETE", null, new ServiceCallback(){

            @MainThread
            public void onCallSucceeded(String payload, Map<String, String> headers) {
                Data.this.notifyListenerAndUpdateOperationOnSuccess(payload, operation);
            }

            @MainThread
            public void onCallFailed(Exception e) {
                Data.this.notifyListenerAndUpdateOperationOnFailure(new DataException("Failed to call Cosmos delete API", e), operation);
            }
        }));
    }

    synchronized void getTokenAndCallCosmosDbApi(String partition, DefaultAppCenterFuture result, TokenExchange.TokenExchangeServiceCallback callback) {
        TokenResult cachedTokenResult = this.mTokenManager.getCachedToken(partition);
        if (cachedTokenResult != null) {
            callback.callCosmosDb(cachedTokenResult);
        } else {
            ServiceCall tokenExchangeServiceCall = TokenExchange.getDbToken(partition, this.mHttpClient, this.mTokenExchangeUrl, this.mAppSecret, callback);
            if (result != null) {
                this.mPendingCalls.put(result, tokenExchangeServiceCall);
            }
        }
    }

    private synchronized <T> void completeFuture(T value, DefaultAppCenterFuture<T> future) {
        future.complete(value);
        this.mPendingCalls.remove(future);
    }

    @WorkerThread
    private synchronized <T> void completeFutureAndSaveToLocalStorage(String table, DocumentWrapper<T> value, DefaultAppCenterFuture<DocumentWrapper<T>> future) {
        future.complete(value);
        this.mLocalDocumentStorage.writeOnline(table, value, new WriteOptions());
        this.mPendingCalls.remove(future);
    }

    private synchronized <T> void completeFuture(Exception e, DefaultAppCenterFuture<DocumentWrapper<T>> future) {
        Utils.logApiCallFailure(e);
        future.complete(new DocumentWrapper(e));
        this.mPendingCalls.remove(future);
    }

    private synchronized <T> void completeFutureOnDocumentError(DocumentWrapper<T> doc, DefaultAppCenterFuture<DocumentWrapper<T>> future) {
        AppCenterLog.error((String)"AppCenterData", (String)"Failed to deserialize document.", (Throwable)doc.getError());
        future.complete(doc);
        this.mPendingCalls.remove(future);
    }

    private synchronized <T> void completeFutureAndRemovePendingCallWhenDocuments(Exception e, DefaultAppCenterFuture<PaginatedDocuments<T>> future) {
        Utils.logApiCallFailure(e);
        future.complete(new PaginatedDocuments().setCurrentPage(new Page(e)));
        this.mPendingCalls.remove(future);
    }

    private void notifyListenerAndUpdateOperationOnSuccess(final String cosmosDbResponsePayload, final LocalDocument pendingOperation) {
        this.post(new Runnable(){

            @Override
            public void run() {
                String eTag = Utils.getETag(cosmosDbResponsePayload);
                pendingOperation.setETag(eTag);
                RemoteOperationListener eventListener = Data.this.mRemoteOperationListener;
                if (eventListener != null) {
                    eventListener.onRemoteOperationCompleted(pendingOperation.getOperation(), new DocumentMetadata(pendingOperation.getPartition(), pendingOperation.getDocumentId(), eTag), null);
                }
                if (pendingOperation.isExpired() || "DELETE".equals(pendingOperation.getOperation())) {
                    Data.this.mLocalDocumentStorage.deleteOnline(pendingOperation.getTable(), pendingOperation.getPartition(), pendingOperation.getDocumentId());
                } else {
                    pendingOperation.setOperation(null);
                    Data.this.mLocalDocumentStorage.updatePendingOperation(pendingOperation);
                }
                Data.this.mOutgoingPendingOperationCalls.remove(Utils.getOutgoingId(pendingOperation.getPartition(), pendingOperation.getDocumentId()));
            }
        });
    }

    private void notifyListenerAndUpdateOperationOnFailure(final DataException e, final LocalDocument pendingOperation) {
        this.post(new Runnable(){

            @Override
            public void run() {
                RemoteOperationListener eventListener;
                AppCenterLog.error((String)"AppCenterData", (String)"Remote operation failed", (Throwable)e);
                boolean deleteLocalCopy = false;
                if (e.getCause() instanceof HttpException) {
                    switch (((HttpException)e.getCause()).getStatusCode()) {
                        case 404: 
                        case 409: {
                            deleteLocalCopy = true;
                        }
                    }
                }
                if ((eventListener = Data.this.mRemoteOperationListener) != null) {
                    eventListener.onRemoteOperationCompleted(pendingOperation.getOperation(), null, e);
                }
                if (deleteLocalCopy || pendingOperation.isExpired()) {
                    Data.this.mLocalDocumentStorage.deleteOnline(pendingOperation.getTable(), pendingOperation.getPartition(), pendingOperation.getDocumentId());
                }
                Data.this.mOutgoingPendingOperationCalls.remove(Utils.getOutgoingId(pendingOperation.getPartition(), pendingOperation.getDocumentId()));
            }
        });
    }

    private TokenResult getCachedToken(String partitionName) {
        TokenResult result = this.mTokenManager.getCachedToken(partitionName, true);
        if (result == null) {
            AppCenterLog.error((String)"AppCenterData", (String)("Unable to find partition named " + partitionName + "."));
            return null;
        }
        return result;
    }

    private <T> boolean isInvalidStateOrParameters(String partition, String documentId, DefaultAppCenterFuture<DocumentWrapper<T>> result) {
        boolean isNotStarted;
        boolean bl = isNotStarted = this.mAppSecret == null;
        if (isNotStarted) {
            this.completeFuture(Data.getModuleNotStartedException(), result);
            return true;
        }
        boolean isValidPartition = LocalDocumentStorage.isValidPartitionName(partition);
        if (!isValidPartition) {
            this.completeFuture(Data.getInvalidPartitionDataException(partition), result);
            return true;
        }
        boolean isValidDocumentId = this.isValidDocumentId(documentId);
        if (!isValidDocumentId) {
            this.completeFuture(new DataException("Invalid document ID."), result);
            return true;
        }
        return false;
    }

    private <T> boolean isInvalidStateOrParametersWhenDocuments(String partition, DefaultAppCenterFuture<PaginatedDocuments<T>> result) {
        boolean invalidPartitionName;
        boolean isNotStarted;
        boolean bl = isNotStarted = this.mAppSecret == null;
        if (isNotStarted) {
            this.completeFutureAndRemovePendingCallWhenDocuments(Data.getModuleNotStartedException(), result);
            return true;
        }
        boolean bl2 = invalidPartitionName = !LocalDocumentStorage.isValidPartitionName(partition);
        if (invalidPartitionName) {
            this.completeFutureAndRemovePendingCallWhenDocuments(Data.getInvalidPartitionDataException(partition), result);
            return true;
        }
        return false;
    }

    private boolean isValidDocumentId(String documentId) {
        if (documentId == null) {
            return false;
        }
        Matcher matcher = this.sDocumentIdPattern.matcher(documentId);
        return matcher.matches();
    }

    private static interface CallTemplate<T> {
        public boolean needsRemoteOperation(DocumentWrapper<T> var1);

        public DocumentWrapper<T> doOfflineOperation(DocumentWrapper<T> var1, String var2, TokenResult var3);

        public void callCosmosDb(TokenResult var1, DefaultAppCenterFuture<DocumentWrapper<T>> var2);
    }
}

