/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.util;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.notification.MPushMessage;
import com.meizu.cloud.pushsdk.pushtracer.QuickTracker;
import com.meizu.cloud.pushsdk.pushtracer.event.Event;
import com.meizu.cloud.pushsdk.pushtracer.event.PushEvent;
import com.meizu.cloud.pushsdk.util.PushPreferencesUtils;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class UxIPUtils {
    private static final String TAG = "UxIPUtils";

    public static void init(Context context) {
    }

    public static void notificationEvent(Context context, String pushInfo, int pushInfoType, String taskId, String imei) {
        if (!TextUtils.isEmpty((CharSequence)taskId)) {
            UxIPUtils.onRecordMessageFlow(context, context.getPackageName(), imei, taskId, "3.4.2-SNAPSHOT", pushInfo, pushInfoType);
        }
    }

    public static void notificationEvent(Context context, Intent intent, String pushInfo, int pushInfoType) {
        UxIPUtils.notificationEvent(context, intent, "3.4.2-SNAPSHOT", pushInfo, pushInfoType);
    }

    public static void notificationEvent(Context context, Intent intent, String pushsdkVersion, String pushInfo, int pushInfoType) {
        if (!TextUtils.isEmpty((CharSequence)UxIPUtils.getTaskId(intent))) {
            UxIPUtils.onRecordMessageFlow(context, context.getPackageName(), intent.getStringExtra("statistics_imei_key"), UxIPUtils.getTaskId(intent), pushsdkVersion, pushInfo, pushInfoType);
        }
    }

    public static String getTaskId(Intent intent) {
        String taskId = intent.getStringExtra("extra_app_push_task_Id");
        if (TextUtils.isEmpty((CharSequence)taskId)) {
            try {
                MPushMessage mPushMessage = (MPushMessage)intent.getSerializableExtra("pushMessage");
                if (mPushMessage != null) {
                    taskId = mPushMessage.getTaskId();
                }
            }
            catch (Exception e) {
                taskId = "no push platform task";
                DebugLogger.e(TAG, "paese MessageV2 error " + e.getMessage());
            }
        }
        return taskId;
    }

    public static void onRecordMessageFlow(Context context, String packageName, String deviceId, String taskId, String pushsdkVersion, String pushInfo, int pushInfoType) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        propertiesMap.put("taskId", taskId);
        propertiesMap.put("deviceId", deviceId);
        propertiesMap.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        propertiesMap.put("package_name", packageName);
        propertiesMap.put("pushsdk_version", pushsdkVersion);
        propertiesMap.put("push_info", pushInfo);
        propertiesMap.put("push_info_type", String.valueOf(pushInfoType));
        UxIPUtils.onLogEvent(context, false, "notification_service_message", propertiesMap);
    }

    public static void onShowPushMessageEvent(Context context, String packageName, String platformExtra) {
        if (!TextUtils.isEmpty((CharSequence)platformExtra)) {
            try {
                JSONObject platformExtraJsonObj = new JSONObject(platformExtra);
                String taskId = null;
                String seqId = null;
                String pushTimestamp = null;
                String deviceId = null;
                if (platformExtraJsonObj.has("task_id")) {
                    taskId = platformExtraJsonObj.getString("task_id");
                }
                if (platformExtraJsonObj.has("seq_id")) {
                    seqId = platformExtraJsonObj.getString("seq_id");
                }
                if (platformExtraJsonObj.has("push_timestamp")) {
                    pushTimestamp = platformExtraJsonObj.getString("push_timestamp");
                }
                if (platformExtraJsonObj.has("device_id")) {
                    deviceId = platformExtraJsonObj.getString("device_id");
                }
                UxIPUtils.onShowPushMessageEvent(context, packageName, deviceId, taskId, seqId, pushTimestamp);
            }
            catch (Exception e) {
                DebugLogger.e(TAG, "the platformExtra parse error");
            }
        } else {
            DebugLogger.e(TAG, "the platformExtra is empty");
        }
    }

    public static void onShowPushMessageEvent(Context context, String packageName, String deviceId, String taskId, String seqId, String pushTimestamp) {
        UxIPUtils.onLogEvent(context, true, packageName, deviceId, taskId, seqId, "spm", pushTimestamp);
    }

    public static void onDeletePushMessageEvent(Context context, String packageName, String deviceId, String taskId, String seqId, String pushTimestamp) {
        UxIPUtils.onLogEvent(context, true, packageName, deviceId, taskId, seqId, "dpm", pushTimestamp);
    }

    public static void onReceivePushMessageEvent(Context context, String packageName, String deviceId, String taskId, String seqId, String pushTimestamp) {
        UxIPUtils.onLogEvent(context, false, packageName, deviceId, taskId, seqId, "rpe", pushTimestamp);
    }

    public static void onReceiveThroughMessage(Context context, String packageName, String deviceId, String taskId, String seqId, String pushTimestamp) {
        UxIPUtils.onLogEvent(context, true, packageName, deviceId, taskId, seqId, "rpe", pushTimestamp);
    }

    public static void onClickPushMessageEvent(Context context, String packageName, String deviceId, String taskId, String seqId, String pushTimestamp) {
        UxIPUtils.onLogEvent(context, true, packageName, deviceId, taskId, seqId, "cpm", pushTimestamp);
    }

    public static void onInvalidPushMessage(Context context, String packageName, String deviceId, String taskId, String seqId, String pushTimestamp) {
        UxIPUtils.onLogEvent(context, true, packageName, deviceId, taskId, seqId, "ipm", pushTimestamp);
    }

    public static void onShowInBoxPushMessage(Context context, String packageName, String deviceId, String taskId, String seqId, String pushTimestamp) {
        UxIPUtils.onLogEvent(context, false, packageName, deviceId, taskId, seqId, "sipm", pushTimestamp);
    }

    public static void onNoShowPushMessage(Context context, String packageName, String deviceId, String taskId, String seqId, String pushTimestamp) {
        UxIPUtils.onLogEvent(context, false, packageName, deviceId, taskId, seqId, "npm", pushTimestamp);
    }

    public static void onReceiveServerMessage(Context context, String packageName, String deviceId, String taskId, String seqId, String pushTimestamp) {
        UxIPUtils.onLogEvent(context, false, packageName, deviceId, taskId, seqId, "rsm", pushTimestamp);
    }

    public static void onLogEvent(Context context, boolean emitNow, String packageName, String deviceId, String taskId, String seqId, String eventName, String pushTimestamp) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        propertiesMap.put("taskId", taskId);
        propertiesMap.put("deviceId", deviceId);
        propertiesMap.put("timestamp", TextUtils.isEmpty((CharSequence)pushTimestamp) ? String.valueOf(System.currentTimeMillis() / 1000L) : pushTimestamp);
        propertiesMap.put("package_name", packageName);
        propertiesMap.put("pushsdk_version", "3.4.2-SNAPSHOT");
        if (!TextUtils.isEmpty((CharSequence)seqId)) {
            propertiesMap.put("seq_id", seqId);
        }
        UxIPUtils.onLogEvent(context, emitNow, eventName, propertiesMap);
    }

    public static void onLogEvent(Context context, boolean emitNow, String eventName, Map<String, String> propertiesMap) {
        DebugLogger.e(TAG, "onLogEvent eventName [" + eventName + "] properties = " + propertiesMap);
        if (!"notification_service_message".equals(eventName)) {
            QuickTracker.getAndroidTrackerClassic(context, null).track(((PushEvent.Builder)((PushEvent.Builder)((PushEvent.Builder)((PushEvent.Builder)((PushEvent.Builder)((PushEvent.Builder)((PushEvent.Builder)((PushEvent.Builder)((Event.Builder)PushEvent.builder().eventName(eventName)).timestamp(Long.valueOf(propertiesMap.get("timestamp")))).eventCreateTime(String.valueOf(System.currentTimeMillis() / 1000L))).deviceId(propertiesMap.get("deviceId"))).packageName(propertiesMap.get("package_name"))).pushsdkVersion(propertiesMap.get("pushsdk_version"))).taskId(propertiesMap.get("taskId"))).seqId(TextUtils.isEmpty((CharSequence)propertiesMap.get("seq_id")) ? "" : propertiesMap.get("seq_id"))).messageSeq(String.valueOf(PushPreferencesUtils.getMessageSeqInCrease(context, propertiesMap.get("package_name"))))).build(), emitNow);
        }
    }
}

