/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.util;

import android.content.Context;
import android.content.SharedPreferences;
import com.meizu.cloud.pushinternal.DebugLogger;

public class PushPreferencesUtils {
    public static final String MZ_PUSH_PREFERENCE = "mz_push_preference";
    private static final String MZ_PUSH_PREFIX_NOTIFICATION_ID = ".notification_id";
    private static final String MZ_PUSH_PREFIX_PUSH_TASK_ID = ".notification_push_task_id";
    private static final String MZ_PUSH_PREFIX_MESSAGE_SEQ = ".message_seq";

    private static SharedPreferences getSharePerferenceByName(Context context, String name) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(name, 4);
        return sharedPreferences;
    }

    public static void putStringByKey(Context context, String preferenceName, String key, String value) {
        SharedPreferences sharedPreferences = PushPreferencesUtils.getSharePerferenceByName(context, preferenceName);
        sharedPreferences.edit().putString(key, value).commit();
    }

    public static String getStringBykey(Context context, String preferenceName, String key) {
        return PushPreferencesUtils.getSharePerferenceByName(context, preferenceName).getString(key, "");
    }

    public static void putIntBykey(Context context, String preferenceName, String key, int value) {
        SharedPreferences sharedPreferences = PushPreferencesUtils.getSharePerferenceByName(context, preferenceName);
        sharedPreferences.edit().putInt(key, value).commit();
    }

    public static int getIntBykey(Context context, String preferenceName, String key) {
        return PushPreferencesUtils.getSharePerferenceByName(context, preferenceName).getInt(key, 0);
    }

    public static void putBooleanByKey(Context context, String preferenceName, String key, boolean value) {
        SharedPreferences sharedPreferences = PushPreferencesUtils.getSharePerferenceByName(context, preferenceName);
        sharedPreferences.edit().putBoolean(key, value).commit();
    }

    public static boolean getBooleanByKey(Context context, String preferenceName, String key) {
        return PushPreferencesUtils.getSharePerferenceByName(context, preferenceName).getBoolean(key, true);
    }

    public static String getPushId(Context context, String pkg) {
        return PushPreferencesUtils.getStringBykey(context, "com.meizu.flyme.push", pkg + "_" + "pushId");
    }

    public static void putPushId(Context context, String pushId, String pkg) {
        PushPreferencesUtils.putStringByKey(context, "com.meizu.flyme.push", pkg + "_" + "pushId", pushId);
    }

    public static void putPushIdExpireTime(Context context, int expireTime, String pkg) {
        PushPreferencesUtils.putIntBykey(context, "com.meizu.flyme.push", pkg + "_" + "pushId_expire_time", expireTime);
    }

    public static int getPushIdExpireTime(Context context, String pkg) {
        return PushPreferencesUtils.getIntBykey(context, "com.meizu.flyme.push", pkg + "_" + "pushId_expire_time");
    }

    public static String getDeviceId(Context context) {
        return PushPreferencesUtils.getSharePerferenceByName(context, MZ_PUSH_PREFERENCE).getString("statistics_imei_key", null);
    }

    public static void putDeviceId(Context context, String deviceId) {
        PushPreferencesUtils.putStringByKey(context, MZ_PUSH_PREFERENCE, "statistics_imei_key", deviceId);
    }

    public static void putDiscardNotificationIdByPackageName(Context context, String pkg, int notificationId) {
        PushPreferencesUtils.putIntBykey(context, MZ_PUSH_PREFERENCE, pkg + MZ_PUSH_PREFIX_NOTIFICATION_ID, notificationId);
    }

    public static int getDiscardNotificationId(Context context, String pkg) {
        return PushPreferencesUtils.getSharePerferenceByName(context, MZ_PUSH_PREFERENCE).getInt(pkg + MZ_PUSH_PREFIX_NOTIFICATION_ID, 0);
    }

    public static void putDiscardNotificationTaskId(Context context, String pkg, int taskId) {
        PushPreferencesUtils.putIntBykey(context, MZ_PUSH_PREFERENCE, pkg + MZ_PUSH_PREFIX_PUSH_TASK_ID, taskId);
    }

    public static int getDiscardNotificationTaskId(Context context, String pkg) {
        return PushPreferencesUtils.getSharePerferenceByName(context, MZ_PUSH_PREFERENCE).getInt(pkg + MZ_PUSH_PREFIX_PUSH_TASK_ID, 0);
    }

    public static void setNotificationMessageSwitchStatus(Context context, String desPackageName, boolean switcher) {
        PushPreferencesUtils.putBooleanByKey(context, MZ_PUSH_PREFERENCE, "switch_notification_message_" + desPackageName, switcher);
    }

    public static boolean getNotificationMessageSwitchStatus(Context context, String desPackageName) {
        return PushPreferencesUtils.getBooleanByKey(context, MZ_PUSH_PREFERENCE, "switch_notification_message_" + desPackageName);
    }

    public static void setAlias(Context context, String desPackageName, String alias) {
        PushPreferencesUtils.putStringByKey(context, MZ_PUSH_PREFERENCE, "push_alias_" + desPackageName, alias);
    }

    public static String getAlias(Context context, String desPackageName) {
        return PushPreferencesUtils.getStringBykey(context, MZ_PUSH_PREFERENCE, "push_alias_" + desPackageName);
    }

    public static void setThroughMessageSwitchStatus(Context context, String desPackageName, boolean switcher) {
        PushPreferencesUtils.putBooleanByKey(context, MZ_PUSH_PREFERENCE, "switch_through_message_" + desPackageName, switcher);
    }

    public static boolean getThroughMessageSwitchStatus(Context context, String desPackageName) {
        return PushPreferencesUtils.getBooleanByKey(context, MZ_PUSH_PREFERENCE, "switch_through_message_" + desPackageName);
    }

    public static void putMessageSeq(Context context, String packageName, int messageSeq) {
        PushPreferencesUtils.putIntBykey(context, MZ_PUSH_PREFERENCE, packageName + MZ_PUSH_PREFIX_MESSAGE_SEQ, messageSeq);
    }

    public static int getMessageSeqInCrease(Context context, String packageName) {
        int messageSeq = PushPreferencesUtils.getIntBykey(context, MZ_PUSH_PREFERENCE, packageName + MZ_PUSH_PREFIX_MESSAGE_SEQ);
        PushPreferencesUtils.putMessageSeq(context, packageName, ++messageSeq);
        DebugLogger.e(MZ_PUSH_PREFERENCE, "current messageSeq " + messageSeq);
        return messageSeq;
    }
}

