/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.platform.pushstrategy;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.networking.common.ANResponse;
import com.meizu.cloud.pushsdk.networking.error.ANError;
import com.meizu.cloud.pushsdk.platform.PlatformMessageSender;
import com.meizu.cloud.pushsdk.platform.api.PushAPI;
import com.meizu.cloud.pushsdk.platform.message.PushSwitchStatus;
import com.meizu.cloud.pushsdk.platform.pushstrategy.Strategy;
import com.meizu.cloud.pushsdk.util.PushPreferencesUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;

public class SwitchStatusStrategy
extends Strategy<PushSwitchStatus> {
    private String pushId;
    private int switchType = 0;
    boolean switcher;
    public static final int CHECK_PUSH = 2;
    public static final int SWITCH_ALL = 3;
    public static final int SWITCH_NOTIFICATION = 0;
    public static final int SWITCH_THROUGH_MESSAGE = 1;
    private Map<String, Boolean> pushStatusMap = new HashMap<String, Boolean>();

    public SwitchStatusStrategy(Context context, String appId, String appKey, PushAPI pushAPI, ScheduledExecutorService executorService) {
        super(context, appId, appKey, pushAPI, executorService);
    }

    public SwitchStatusStrategy(Context context, String appId, String appKey, String pushId, PushAPI pushAPI, ScheduledExecutorService executorService) {
        this(context, appId, appKey, pushAPI, executorService);
        this.pushId = pushId;
    }

    public SwitchStatusStrategy(Context context, PushAPI pushAPI, ScheduledExecutorService executorService) {
        this(context, null, null, null, pushAPI, executorService);
    }

    public SwitchStatusStrategy(Context context, PushAPI pushAPI, ScheduledExecutorService executorService, boolean enableRPC) {
        this(context, pushAPI, executorService);
        this.enableRPC = enableRPC;
    }

    public void setSwitcher(boolean switcher) {
        this.switcher = switcher;
    }

    public void setSwitchType(int switchType) {
        this.switchType = switchType;
    }

    public void setPushId(String pushId) {
        this.pushId = pushId;
    }

    @Override
    protected boolean matchCondition() {
        return !TextUtils.isEmpty((CharSequence)this.appId) && !TextUtils.isEmpty((CharSequence)this.appKey) && !TextUtils.isEmpty((CharSequence)this.pushId);
    }

    @Override
    protected PushSwitchStatus feedBackErrorResponse() {
        PushSwitchStatus pushSwitchStatus = new PushSwitchStatus();
        pushSwitchStatus.setCode("20001");
        if (TextUtils.isEmpty((CharSequence)this.appId)) {
            pushSwitchStatus.setMessage("appId not empty");
        } else if (TextUtils.isEmpty((CharSequence)this.appKey)) {
            pushSwitchStatus.setMessage("appKey not empty");
        } else if (TextUtils.isEmpty((CharSequence)this.pushId)) {
            pushSwitchStatus.setMessage("pushId not empty");
        }
        return pushSwitchStatus;
    }

    @Override
    protected Intent sendRpcRequest() {
        Intent intent = null;
        if (this.switchType != 2) {
            intent = new Intent();
            intent.putExtra("app_id", this.appId);
            intent.putExtra("app_key", this.appKey);
            intent.putExtra("strategy_package_name", this.context.getPackageName());
            intent.putExtra("push_id", this.pushId);
            intent.putExtra("strategy_type", this.strategyType());
            intent.putExtra("strategy_child_type", this.switchType);
            intent.putExtra("strategy_params", this.switcher ? "1" : "0");
        }
        return intent;
    }

    @Override
    protected PushSwitchStatus netWorkRequest() {
        PushSwitchStatus pushSwitchStatus = new PushSwitchStatus();
        pushSwitchStatus.setPushId(this.pushId);
        pushSwitchStatus.setCode("200");
        pushSwitchStatus.setMessage("");
        ANResponse anResponse = null;
        switch (this.switchType) {
            case 2: {
                pushSwitchStatus.setSwitchNotificationMessage(this.notificationSwitch());
                pushSwitchStatus.setSwitchThroughMessage(this.throughMessageSwitch());
                break;
            }
            case 3: {
                if (this.notificationSwitch() == this.switcher && this.throughMessageSwitch() == this.switcher && !this.isSyncPushStatus()) {
                    pushSwitchStatus.setSwitchNotificationMessage(this.switcher);
                    pushSwitchStatus.setSwitchThroughMessage(this.switcher);
                    break;
                }
                this.changeSyncPushStatus(true);
                this.switchAll(this.switcher);
                anResponse = this.pushAPI.switchPush(this.appId, this.appKey, this.pushId, this.switcher);
                break;
            }
            case 0: {
                if (this.notificationSwitch() == this.switcher && !this.isSyncPushStatus()) {
                    pushSwitchStatus.setSwitchNotificationMessage(this.switcher);
                    pushSwitchStatus.setSwitchThroughMessage(this.throughMessageSwitch());
                    break;
                }
                this.changeSyncPushStatus(true);
                this.switchNotification(this.switcher);
                anResponse = this.pushAPI.switchPush(this.appId, this.appKey, this.pushId, this.switchType, this.switcher);
                break;
            }
            case 1: {
                if (this.throughMessageSwitch() == this.switcher && !this.isSyncPushStatus()) {
                    pushSwitchStatus.setSwitchNotificationMessage(this.notificationSwitch());
                    pushSwitchStatus.setSwitchThroughMessage(this.switcher);
                    break;
                }
                this.changeSyncPushStatus(true);
                this.switchThroughMessage(this.switcher);
                anResponse = this.pushAPI.switchPush(this.appId, this.appKey, this.pushId, this.switchType, this.switcher);
            }
        }
        if (anResponse != null) {
            if (anResponse.isSuccess()) {
                pushSwitchStatus = new PushSwitchStatus((String)anResponse.getResult());
                DebugLogger.e("Strategy", "network pushSwitchStatus " + pushSwitchStatus);
                if ("200".equals(pushSwitchStatus.getCode())) {
                    this.changeSyncPushStatus(false);
                }
            } else {
                ANError error = anResponse.getError();
                if (error.getResponse() != null) {
                    DebugLogger.e("Strategy", "status code=" + error.getErrorCode() + " data=" + error.getResponse());
                }
                pushSwitchStatus.setCode(String.valueOf(error.getErrorCode()));
                pushSwitchStatus.setMessage(error.getErrorBody());
                DebugLogger.e("Strategy", "pushSwitchStatus " + pushSwitchStatus);
            }
        }
        return pushSwitchStatus;
    }

    @Override
    protected PushSwitchStatus localResponse() {
        PushSwitchStatus pushSwitchStatus = null;
        switch (this.switchType) {
            case 2: {
                pushSwitchStatus = new PushSwitchStatus();
                pushSwitchStatus.setPushId(this.pushId);
                pushSwitchStatus.setCode("200");
                pushSwitchStatus.setMessage("");
                pushSwitchStatus.setSwitchNotificationMessage(this.notificationSwitch());
                pushSwitchStatus.setSwitchThroughMessage(this.throughMessageSwitch());
                break;
            }
            case 3: {
                this.switchAll(this.switcher);
                break;
            }
            case 0: {
                this.switchNotification(this.switcher);
                break;
            }
            case 1: {
                this.switchThroughMessage(this.switcher);
            }
        }
        return pushSwitchStatus;
    }

    @Override
    protected void sendReceiverMessage(PushSwitchStatus message) {
        PlatformMessageSender.sendPushStatus(this.context, !TextUtils.isEmpty((CharSequence)this.strategyPackageNanme) ? this.strategyPackageNanme : this.context.getPackageName(), message);
    }

    @Override
    protected int strategyType() {
        return 16;
    }

    private void switchNotification(boolean switcher) {
        PushPreferencesUtils.setNotificationMessageSwitchStatus(this.context, !TextUtils.isEmpty((CharSequence)this.strategyPackageNanme) ? this.strategyPackageNanme : this.context.getPackageName(), switcher);
    }

    private void switchThroughMessage(boolean switcher) {
        PushPreferencesUtils.setThroughMessageSwitchStatus(this.context, !TextUtils.isEmpty((CharSequence)this.strategyPackageNanme) ? this.strategyPackageNanme : this.context.getPackageName(), switcher);
    }

    private void switchAll(boolean switcher) {
        PushPreferencesUtils.setNotificationMessageSwitchStatus(this.context, !TextUtils.isEmpty((CharSequence)this.strategyPackageNanme) ? this.strategyPackageNanme : this.context.getPackageName(), switcher);
        PushPreferencesUtils.setThroughMessageSwitchStatus(this.context, !TextUtils.isEmpty((CharSequence)this.strategyPackageNanme) ? this.strategyPackageNanme : this.context.getPackageName(), switcher);
    }

    private boolean notificationSwitch() {
        return PushPreferencesUtils.getNotificationMessageSwitchStatus(this.context, !TextUtils.isEmpty((CharSequence)this.strategyPackageNanme) ? this.strategyPackageNanme : this.context.getPackageName());
    }

    private boolean throughMessageSwitch() {
        return PushPreferencesUtils.getThroughMessageSwitchStatus(this.context, !TextUtils.isEmpty((CharSequence)this.strategyPackageNanme) ? this.strategyPackageNanme : this.context.getPackageName());
    }

    private void changeSyncPushStatus(boolean flag) {
        this.pushStatusMap.put(this.strategyPackageNanme + "_" + this.switchType, flag);
    }

    private boolean isSyncPushStatus() {
        Boolean pushStatus = this.pushStatusMap.get(this.strategyPackageNanme + "_" + this.switchType);
        return pushStatus != null ? pushStatus : true;
    }
}

