/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.platform.pushstrategy;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.platform.api.PushAPI;
import com.meizu.cloud.pushsdk.platform.message.BasicPushStatus;
import com.meizu.cloud.pushsdk.util.MzSystemUtils;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;

public abstract class Strategy<T extends BasicPushStatus> {
    public static final String TAG = "Strategy";
    protected ScheduledExecutorService executorService;
    protected Context context;
    protected String appId;
    protected String appKey;
    protected String strategyPackageNanme;
    protected volatile String deviceId;
    protected PushAPI pushAPI;
    protected boolean isSupportRemoteInvoke = false;
    protected boolean enableRPC = true;
    public static final int STRATEGY_REGISTER = 2;
    public static final int STRATEGY_SUBTAGS = 4;
    public static final int STRATEGY_SUBALIAS = 8;
    public static final int STRATEGY_SWITCH = 16;
    public static final int STRATEGY_UNREGISTER = 32;
    public static final String APP_ID = "app_id";
    public static final String APP_KEY = "app_key";
    public static final String PUSH_ID = "push_id";
    public static final String STRATEGY_PACKAGE_NANME = "strategy_package_name";
    public static final String STRATEGY_TYPE = "strategy_type";
    public static final String STRATEGY_CHILD_TYPE = "strategy_child_type";
    public static final String STRATEGY_PARAMS = "strategy_params";
    private String managerServicePackageName = null;
    public static final String DEVICE_ERROR_CODE = "20000";
    public static final String SUCCESS_CODE = "200";
    public static final String FEEDBACK_PARAMETER_ERROR_CODE = "20001";

    public Strategy(Context context, String appId, String appKey, PushAPI pushAPI, ScheduledExecutorService executorService) {
        this.executorService = executorService;
        this.context = context;
        this.appId = appId;
        this.appKey = appKey;
        this.pushAPI = pushAPI;
    }

    public void setExecutorService(ScheduledExecutorService executorService) {
        this.executorService = executorService;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public void setStrategyPackageNanme(String strategyPackageNanme) {
        this.strategyPackageNanme = strategyPackageNanme;
    }

    public void setSupportRemoteInvoke(boolean isSupportRemoteInvoke) {
        this.isSupportRemoteInvoke = isSupportRemoteInvoke;
    }

    protected abstract boolean matchCondition();

    protected abstract T feedBackErrorResponse();

    protected boolean supportServiceRpc() {
        return this.enableRPC && this.isSupportRemoteInvoke && !TextUtils.isEmpty((CharSequence)this.findService(this.context, "com.meizu.cloud.pushservice.action.PUSH_MANAGER_SERVICE"));
    }

    protected abstract Intent sendRpcRequest();

    protected abstract T netWorkRequest();

    protected abstract T localResponse();

    protected abstract void sendReceiverMessage(T var1);

    private boolean supportAllResponse() {
        return this.enableRPC && !this.context.getPackageName().equals(this.managerServicePackageName);
    }

    private boolean isServiceCode(int code) {
        return code >= 110000 && code <= 200000;
    }

    protected abstract int strategyType();

    protected boolean isRegisterStatus() {
        return 2 == this.strategyType() || 32 == this.strategyType();
    }

    public boolean process() {
        boolean flag = true;
        if (this.executorService != null) {
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    Strategy.this.processMainThread();
                }
            });
        } else {
            flag = this.processMainThread();
        }
        return flag;
    }

    public boolean processMainThread() {
        boolean flag = true;
        BasicPushStatus basicPushStatus = null;
        if (!this.matchCondition()) {
            DebugLogger.e(TAG, "Missing required parameters");
            basicPushStatus = (BasicPushStatus)this.feedBackErrorResponse();
            this.sendReceiverMessage(basicPushStatus);
        } else if (!this.supportServiceRpc()) {
            basicPushStatus = (BasicPushStatus)this.netWorkRequest();
            DebugLogger.i(TAG, "real response status " + basicPushStatus);
            if (basicPushStatus != null) {
                if (this.isRegisterStatus() && DEVICE_ERROR_CODE.equals(basicPushStatus.getCode())) {
                    return true;
                }
                if (this.supportAllResponse()) {
                    DebugLogger.e(TAG, "response all request in local app");
                    this.sendReceiverMessage(basicPushStatus);
                } else {
                    int serviceCode;
                    String code = basicPushStatus.getCode();
                    if (TextUtils.isEmpty((CharSequence)code)) {
                        code = "0";
                    }
                    if (SUCCESS_CODE.equals(basicPushStatus.getCode())) {
                        this.sendReceiverMessage(basicPushStatus);
                    }
                    if (this.isServiceCode(serviceCode = Integer.valueOf(code).intValue())) {
                        DebugLogger.e(TAG, "service error so notify pushManager invoker code=" + serviceCode + " message " + basicPushStatus.getMessage());
                        this.sendReceiverMessage(basicPushStatus);
                    }
                }
            }
        } else {
            Intent intent;
            DebugLogger.i(TAG, "send message to remote service");
            if (!this.isRegisterStatus() && (basicPushStatus = (BasicPushStatus)this.localResponse()) != null) {
                DebugLogger.e(TAG, "local response " + basicPushStatus);
                this.sendReceiverMessage(basicPushStatus);
            }
            if ((intent = this.sendRpcRequest()) != null) {
                this.sendIntentMessage(intent);
            }
        }
        if (basicPushStatus != null) {
            DebugLogger.e(TAG, "current status code " + basicPushStatus.getCode());
            flag = !this.isServerError(basicPushStatus);
        }
        return flag;
    }

    private boolean isServerError(T basicPushStatus) {
        String code = ((BasicPushStatus)basicPushStatus).getCode();
        int errorCode = Integer.valueOf(code);
        return errorCode > 200 && errorCode < 600 || errorCode > 1000 && errorCode < 2000 || errorCode == 0;
    }

    protected String getDeviceId() {
        if (TextUtils.isEmpty((CharSequence)this.deviceId)) {
            this.deviceId = MzSystemUtils.getDeviceId(this.context);
            DebugLogger.e(TAG, "deviceId " + this.deviceId);
        }
        return this.deviceId;
    }

    protected String findService(Context paramContext, String action) {
        String componentName = null;
        if (!TextUtils.isEmpty((CharSequence)action)) {
            Intent localIntent = new Intent(action);
            List localList = paramContext.getPackageManager().queryIntentServices(localIntent, 0);
            if (localList != null) {
                for (ResolveInfo info : localList) {
                    if (!"com.meizu.cloud".equals(info.serviceInfo.packageName)) continue;
                    this.managerServicePackageName = info.serviceInfo.packageName;
                    componentName = info.serviceInfo.name;
                    break;
                }
                if (TextUtils.isEmpty(componentName) && localList.size() > 0) {
                    this.managerServicePackageName = ((ResolveInfo)localList.get((int)0)).serviceInfo.packageName;
                    componentName = ((ResolveInfo)localList.get((int)0)).serviceInfo.name;
                }
            }
        }
        DebugLogger.i(TAG, "current process packageName " + this.managerServicePackageName);
        return componentName;
    }

    protected void sendIntentMessage(Intent intent) {
        try {
            intent.setPackage(this.managerServicePackageName);
            intent.setAction("com.meizu.cloud.pushservice.action.PUSH_MANAGER_SERVICE");
            this.context.startService(intent);
        }
        catch (Exception e) {
            DebugLogger.e(TAG, "start RemoteService error " + e.getMessage());
        }
    }
}

