/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.platform.pushstrategy;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.networking.common.ANResponse;
import com.meizu.cloud.pushsdk.networking.error.ANError;
import com.meizu.cloud.pushsdk.platform.PlatformMessageSender;
import com.meizu.cloud.pushsdk.platform.PushIdEncryptUtils;
import com.meizu.cloud.pushsdk.platform.api.PushAPI;
import com.meizu.cloud.pushsdk.platform.message.RegisterStatus;
import com.meizu.cloud.pushsdk.platform.pushstrategy.Strategy;
import com.meizu.cloud.pushsdk.pushtracer.emitter.classic.Executor;
import com.meizu.cloud.pushsdk.util.PushPreferencesUtils;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class RegisterStatusStrategy
extends Strategy<RegisterStatus> {
    protected Handler mainHandler;
    protected ScheduledExecutorService scheduledExecutorService;
    protected int deviceIdRetry = 0;

    public RegisterStatusStrategy(Context context, String appId, String appKey, PushAPI pushAPI, ScheduledExecutorService executorService) {
        super(context, appId, appKey, pushAPI, executorService);
    }

    public RegisterStatusStrategy(Context context, PushAPI pushAPI, ScheduledExecutorService executorService) {
        this(context, null, null, pushAPI, executorService);
        this.scheduledExecutorService = (ScheduledExecutorService)Executor.getExecutor();
        this.mainHandler = new Handler(context.getMainLooper()){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 0: {
                        RegisterStatusStrategy.this.process();
                    }
                }
            }
        };
    }

    public RegisterStatusStrategy(Context context, PushAPI pushAPI, ScheduledExecutorService executorService, boolean enableRPC) {
        this(context, pushAPI, executorService);
        this.enableRPC = enableRPC;
    }

    @Override
    public boolean matchCondition() {
        return !TextUtils.isEmpty((CharSequence)this.appId) && !TextUtils.isEmpty((CharSequence)this.appKey);
    }

    @Override
    protected RegisterStatus feedBackErrorResponse() {
        RegisterStatus registerStatus = new RegisterStatus();
        registerStatus.setCode("20001");
        if (TextUtils.isEmpty((CharSequence)this.appId)) {
            registerStatus.setMessage("appId not empty");
        } else if (TextUtils.isEmpty((CharSequence)this.appKey)) {
            registerStatus.setMessage("appKey not empty");
        }
        return registerStatus;
    }

    @Override
    public Intent sendRpcRequest() {
        Intent intent = new Intent();
        intent.putExtra("app_id", this.appId);
        intent.putExtra("app_key", this.appKey);
        intent.putExtra("strategy_package_name", this.context.getPackageName());
        intent.putExtra("strategy_type", this.strategyType());
        return intent;
    }

    @Override
    protected RegisterStatus localResponse() {
        return null;
    }

    @Override
    public RegisterStatus netWorkRequest() {
        int expireTime;
        RegisterStatus registerStatus = new RegisterStatus();
        String pushId = PushPreferencesUtils.getPushId(this.context, this.strategyPackageNanme);
        if (!this.retryRegister(pushId, expireTime = PushPreferencesUtils.getPushIdExpireTime(this.context, this.strategyPackageNanme))) {
            registerStatus.setCode("200");
            registerStatus.setMessage("already register PushId,dont register frequently");
            registerStatus.setPushId(pushId);
            registerStatus.setExpireTime((int)((long)expireTime - System.currentTimeMillis() / 1000L));
        } else {
            PushPreferencesUtils.putPushId(this.context, "", this.strategyPackageNanme);
            this.deviceId = this.getDeviceId();
            if (TextUtils.isEmpty((CharSequence)this.deviceId) && this.deviceIdRetry < 3) {
                DebugLogger.i("Strategy", "after " + this.deviceIdRetry * 10 + " seconds start register");
                this.executeAfterGetDeviceId(this.deviceIdRetry * 10);
                ++this.deviceIdRetry;
                registerStatus.setCode("20000");
                registerStatus.setMessage("deviceId is empty");
            } else {
                this.deviceIdRetry = 0;
                ANResponse registerStatusANResponse = this.pushAPI.register(this.appId, this.appKey, this.deviceId);
                if (registerStatusANResponse.isSuccess()) {
                    registerStatus = new RegisterStatus((String)registerStatusANResponse.getResult());
                    DebugLogger.e("Strategy", "registerStatus " + registerStatus);
                    if (!TextUtils.isEmpty((CharSequence)registerStatus.getPushId())) {
                        PushPreferencesUtils.putPushId(this.context, registerStatus.getPushId(), this.strategyPackageNanme);
                        PushPreferencesUtils.putPushIdExpireTime(this.context, (int)(System.currentTimeMillis() / 1000L + (long)registerStatus.getExpireTime()), this.strategyPackageNanme);
                    }
                } else {
                    ANError error = registerStatusANResponse.getError();
                    if (error.getResponse() != null) {
                        DebugLogger.e("Strategy", "status code=" + error.getErrorCode() + " data=" + error.getResponse());
                    }
                    registerStatus.setCode(String.valueOf(error.getErrorCode()));
                    registerStatus.setMessage(error.getErrorBody());
                    DebugLogger.e("Strategy", "registerStatus " + registerStatus);
                }
            }
        }
        return registerStatus;
    }

    @Override
    public void sendReceiverMessage(RegisterStatus message) {
        PlatformMessageSender.sendRegisterStatus(this.context, !TextUtils.isEmpty((CharSequence)this.strategyPackageNanme) ? this.strategyPackageNanme : this.context.getPackageName(), message);
    }

    @Override
    protected int strategyType() {
        return 2;
    }

    protected void executeAfterGetDeviceId(long delay) {
        this.scheduledExecutorService.schedule(new Runnable(){

            @Override
            public void run() {
                RegisterStatusStrategy.this.getDeviceId();
                RegisterStatusStrategy.this.mainHandler.sendEmptyMessage(0);
            }
        }, delay, TimeUnit.SECONDS);
    }

    protected boolean retryRegister(String pushId, int expireTime) {
        String deviceId;
        boolean flag = true;
        if (!TextUtils.isEmpty((CharSequence)pushId) && (pushId.startsWith(deviceId = this.getDeviceId()) || PushIdEncryptUtils.decryptPushId(pushId).startsWith(deviceId)) && System.currentTimeMillis() / 1000L < (long)expireTime) {
            flag = false;
        }
        return flag;
    }
}

