/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.notification.util;

import android.app.Notification;
import android.app.PendingIntent;
import com.meizu.cloud.pushinternal.DebugLogger;
import java.lang.reflect.Field;

public class NotificationUtils {
    private static final String TAG = "NotificationUtils";
    private static Field mFlymeNotification = null;
    private static Field mInternalApp = null;
    private static Field mReplyIntent;

    public static void setReplyIntent(Notification notification, PendingIntent pendingIntent) {
        if (mReplyIntent != null) {
            try {
                mReplyIntent.set(notification, pendingIntent);
            }
            catch (IllegalAccessException e) {
                DebugLogger.e(TAG, "setReplyIntent error " + e.getMessage());
            }
        }
    }

    public static void setInternalApp(Notification notification, boolean internalApp) {
        if (mFlymeNotification != null && mInternalApp != null) {
            try {
                Object flymeNotification = mFlymeNotification.get(notification);
                mInternalApp.set(flymeNotification, internalApp ? 1 : 0);
            }
            catch (IllegalAccessException e) {
                DebugLogger.e(TAG, "setInternalApp error " + e.getMessage());
            }
        }
    }

    static {
        try {
            mFlymeNotification = Notification.class.getDeclaredField("mFlymeNotification");
            Class<?> NotificationExt = Class.forName("android.app.NotificationExt");
            mInternalApp = NotificationExt.getDeclaredField("internalApp");
            mInternalApp.setAccessible(true);
            mReplyIntent = Notification.class.getDeclaredField("replyIntent");
            mReplyIntent.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            DebugLogger.e(TAG, "init NotificationUtils error " + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

