/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.notification.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import org.json.JSONException;
import org.json.JSONObject;

public class AppIconSetting
implements Parcelable {
    public static final String TAG = "app_icon_setting";
    public static final String APP_ICON_SETTING = "is";
    public static final String DEFAULT_LARGE_ICON = "di";
    public static final String LARGE_ICON_URL = "li";
    private boolean defaultLargeIcon = true;
    private String largeIconUrl;
    public static final Parcelable.Creator<AppIconSetting> CREATOR = new Parcelable.Creator<AppIconSetting>(){

        public AppIconSetting createFromParcel(Parcel in) {
            return new AppIconSetting(in);
        }

        public AppIconSetting[] newArray(int size) {
            return new AppIconSetting[size];
        }
    };

    public AppIconSetting(Parcel in) {
        this.defaultLargeIcon = in.readByte() != 0;
        this.largeIconUrl = in.readString();
    }

    public AppIconSetting() {
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeByte((byte)(this.defaultLargeIcon ? 1 : 0));
        parcel.writeString(this.largeIconUrl);
    }

    public String getLargeIconUrl() {
        return this.largeIconUrl;
    }

    public void setLargeIconUrl(String largeIconUrl) {
        this.largeIconUrl = largeIconUrl;
    }

    public boolean isDefaultLargeIcon() {
        return this.defaultLargeIcon;
    }

    public void setDefaultLargeIcon(boolean defaultLargeIcon) {
        this.defaultLargeIcon = defaultLargeIcon;
    }

    public static AppIconSetting parse(String setting) {
        JSONObject appIconSetingObj = null;
        if (!TextUtils.isEmpty((CharSequence)setting)) {
            try {
                appIconSetingObj = new JSONObject(setting);
            }
            catch (JSONException e) {
                DebugLogger.e(TAG, "parse json string error " + e.getMessage());
            }
        }
        return AppIconSetting.parse(appIconSetingObj);
    }

    public static AppIconSetting parse(JSONObject appIconSetingObj) {
        AppIconSetting appIconSetting = new AppIconSetting();
        if (appIconSetingObj != null) {
            try {
                if (!appIconSetingObj.isNull(DEFAULT_LARGE_ICON)) {
                    appIconSetting.setDefaultLargeIcon(appIconSetingObj.getInt(DEFAULT_LARGE_ICON) != 0);
                }
                if (!appIconSetingObj.isNull(LARGE_ICON_URL)) {
                    appIconSetting.setLargeIconUrl(appIconSetingObj.getString(LARGE_ICON_URL));
                }
            }
            catch (JSONException e) {
                DebugLogger.e(TAG, "parse json obj error " + e.getMessage());
            }
        } else {
            DebugLogger.e(TAG, "no such tag app_icon_setting");
        }
        return appIconSetting;
    }

    public String toString() {
        return "AppIconSetting{defaultLargeIcon=" + this.defaultLargeIcon + ", largeIconUrl='" + this.largeIconUrl + '\'' + '}';
    }
}

