/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.networking.internal;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.meizu.cloud.pushsdk.networking.interfaces.UploadProgressListener;
import com.meizu.cloud.pushsdk.networking.model.Progress;
import java.lang.ref.WeakReference;

public class UploadProgressHandler
extends Handler {
    private final WeakReference<UploadProgressListener> mUploadProgressListenerWeakRef;

    public UploadProgressHandler(UploadProgressListener uploadProgressListener) {
        super(Looper.getMainLooper());
        this.mUploadProgressListenerWeakRef = new WeakReference<UploadProgressListener>(uploadProgressListener);
    }

    public void handleMessage(Message msg) {
        UploadProgressListener uploadProgressListener = (UploadProgressListener)this.mUploadProgressListenerWeakRef.get();
        switch (msg.what) {
            case 1: {
                if (uploadProgressListener == null) break;
                Progress progress = (Progress)msg.obj;
                uploadProgressListener.onProgress(progress.currentBytes, progress.totalBytes);
                break;
            }
            default: {
                super.handleMessage(msg);
            }
        }
    }
}

