/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.networking.internal;

import com.meizu.cloud.pushsdk.networking.common.ANLog;
import com.meizu.cloud.pushsdk.networking.common.ANRequest;
import com.meizu.cloud.pushsdk.networking.common.Priority;
import com.meizu.cloud.pushsdk.networking.core.Core;
import com.meizu.cloud.pushsdk.networking.internal.InternalRunnable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class ANRequestQueue {
    private static final String TAG = ANRequestQueue.class.getSimpleName();
    private final Set<ANRequest> mCurrentRequests = new HashSet<ANRequest>();
    private AtomicInteger mSequenceGenerator = new AtomicInteger();
    private static ANRequestQueue sInstance = null;

    public static void initialize() {
        ANRequestQueue.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ANRequestQueue getInstance() {
        if (sInstance != null) return sInstance;
        Class<ANRequestQueue> clazz = ANRequestQueue.class;
        synchronized (ANRequestQueue.class) {
            if (sInstance != null) return sInstance;
            sInstance = new ANRequestQueue();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancel(RequestFilter filter, boolean forceCancel) {
        Set<ANRequest> set = this.mCurrentRequests;
        synchronized (set) {
            try {
                Iterator<ANRequest> iterator = this.mCurrentRequests.iterator();
                while (iterator.hasNext()) {
                    ANRequest request = iterator.next();
                    if (!filter.apply(request)) continue;
                    request.cancel(forceCancel);
                    if (!request.isCanceled()) continue;
                    request.destroy();
                    iterator.remove();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll(boolean forceCancel) {
        Set<ANRequest> set = this.mCurrentRequests;
        synchronized (set) {
            try {
                Iterator<ANRequest> iterator = this.mCurrentRequests.iterator();
                while (iterator.hasNext()) {
                    ANRequest request = iterator.next();
                    request.cancel(forceCancel);
                    if (!request.isCanceled()) continue;
                    request.destroy();
                    iterator.remove();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void cancelRequestWithGivenTag(final Object tag, boolean forceCancel) {
        try {
            if (tag == null) {
                return;
            }
            this.cancel(new RequestFilter(){

                @Override
                public boolean apply(ANRequest request) {
                    if (request.getTag() instanceof String && tag instanceof String) {
                        String tempRequestTag = (String)request.getTag();
                        String tempTag = (String)tag;
                        return tempRequestTag.equals(tempTag);
                    }
                    return request.getTag().equals(tag);
                }
            }, forceCancel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getSequenceNumber() {
        return this.mSequenceGenerator.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ANRequest addRequest(ANRequest request) {
        Set<ANRequest> set = this.mCurrentRequests;
        synchronized (set) {
            try {
                this.mCurrentRequests.add(request);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            request.setSequenceNumber(this.getSequenceNumber());
            if (request.getPriority() == Priority.IMMEDIATE) {
                request.setFuture(Core.getInstance().getExecutorSupplier().forImmediateNetworkTasks().submit(new InternalRunnable(request)));
            } else {
                request.setFuture(Core.getInstance().getExecutorSupplier().forNetworkTasks().submit(new InternalRunnable(request)));
            }
            ANLog.d("addRequest: after addition - mCurrentRequests size: " + this.mCurrentRequests.size());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish(ANRequest request) {
        Set<ANRequest> set = this.mCurrentRequests;
        synchronized (set) {
            try {
                this.mCurrentRequests.remove(request);
                ANLog.d("finish: after removal - mCurrentRequests size: " + this.mCurrentRequests.size());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static interface RequestFilter {
        public boolean apply(ANRequest var1);
    }
}

