/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.networking.http;

import com.meizu.cloud.pushsdk.networking.common.ANLog;
import com.meizu.cloud.pushsdk.networking.http.Call;
import com.meizu.cloud.pushsdk.networking.http.MediaType;
import com.meizu.cloud.pushsdk.networking.http.Request;
import com.meizu.cloud.pushsdk.networking.http.RequestBody;
import com.meizu.cloud.pushsdk.networking.http.Response;
import com.meizu.cloud.pushsdk.networking.http.ResponseBody;
import com.meizu.cloud.pushsdk.networking.okio.BufferedSink;
import com.meizu.cloud.pushsdk.networking.okio.BufferedSource;
import com.meizu.cloud.pushsdk.networking.okio.Okio;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;

public class HttpURLConnectionCall
implements Call {
    Request originalRequest;

    public HttpURLConnectionCall(Request originalRequest) {
        this.originalRequest = originalRequest;
    }

    @Override
    public Request request() {
        return this.originalRequest;
    }

    @Override
    public Response execute() throws IOException {
        HttpURLConnection connection = this.openConnection(this.originalRequest);
        for (String headerName : this.originalRequest.headers().names()) {
            String value = this.originalRequest.header(headerName);
            ANLog.i("current header name " + headerName + " value " + value);
            connection.addRequestProperty(headerName, value);
        }
        HttpURLConnectionCall.setConnectionParametersForRequest(connection, this.originalRequest);
        int responseCode = connection.getResponseCode();
        String responseMessage = connection.getResponseMessage();
        Response response = new Response.Builder().code(responseCode).headers(this.originalRequest.headers()).message(responseMessage).request(this.originalRequest).body(HttpURLConnectionCall.createOkBody(connection)).build();
        return response;
    }

    private static ResponseBody createOkBody(final HttpURLConnection urlConnection) throws IOException {
        if (!urlConnection.getDoInput()) {
            return null;
        }
        final BufferedSource body = Okio.buffer(Okio.source(HttpURLConnectionCall.isSuccessfulSend(urlConnection.getResponseCode()) ? urlConnection.getInputStream() : urlConnection.getErrorStream()));
        return new ResponseBody(){

            @Override
            public MediaType contentType() {
                String contentTypeHeader = urlConnection.getContentType();
                return contentTypeHeader == null ? null : MediaType.parse(contentTypeHeader);
            }

            @Override
            public long contentLength() {
                String s = urlConnection.getHeaderField("Content-Length");
                return HttpURLConnectionCall.stringToLong(s);
            }

            @Override
            public BufferedSource source() {
                return body;
            }
        };
    }

    protected static boolean isSuccessfulSend(int code) {
        return code >= 200 && code < 300;
    }

    private static long stringToLong(String s) {
        if (s == null) {
            return -1L;
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    @Override
    public void cancel() {
    }

    @Override
    public boolean isExecuted() {
        return false;
    }

    @Override
    public boolean isCanceled() {
        return false;
    }

    private HttpURLConnection openConnection(Request request) throws IOException {
        String url = request.url().toString();
        URL parsedUrl = new URL(url);
        HttpURLConnection connection = this.createConnection(parsedUrl);
        connection.setConnectTimeout(60000);
        connection.setReadTimeout(60000);
        connection.setUseCaches(false);
        connection.setDoInput(true);
        if (!request.isHttps() || url.startsWith("https://push.statics")) {
            // empty if block
        }
        return connection;
    }

    protected HttpURLConnection createConnection(URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setInstanceFollowRedirects(HttpURLConnection.getFollowRedirects());
        return connection;
    }

    static void setConnectionParametersForRequest(HttpURLConnection connection, Request request) throws IOException {
        switch (request.getmethod()) {
            case 0: {
                connection.setRequestMethod("GET");
                break;
            }
            case 3: {
                connection.setRequestMethod("DELETE");
                break;
            }
            case 1: {
                connection.setRequestMethod("POST");
                HttpURLConnectionCall.addBodyIfExists(connection, request);
                break;
            }
            case 2: {
                connection.setRequestMethod("PUT");
                HttpURLConnectionCall.addBodyIfExists(connection, request);
                break;
            }
            case 4: {
                connection.setRequestMethod("HEAD");
                break;
            }
            case 5: {
                connection.setRequestMethod("PATCH");
                HttpURLConnectionCall.addBodyIfExists(connection, request);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown method type.");
            }
        }
    }

    private static void addBodyIfExists(HttpURLConnection connection, Request request) throws IOException {
        RequestBody body = request.body();
        if (body != null) {
            connection.setDoOutput(true);
            connection.addRequestProperty("Content-Type", body.contentType().toString());
            BufferedSink fromSink = Okio.buffer(Okio.sink(connection.getOutputStream()));
            body.writeTo(fromSink);
            fromSink.close();
        }
    }
}

