/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.handler.impl.platform;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.handler.AbstractAppLogicListener;
import com.meizu.cloud.pushsdk.handler.impl.AbstractMessageHandler;
import com.meizu.cloud.pushsdk.notification.PushNotification;
import com.meizu.cloud.pushsdk.platform.message.RegisterStatus;
import com.meizu.cloud.pushsdk.util.PushPreferencesUtils;

public class RegisterStatusHandler
extends AbstractMessageHandler<RegisterStatus> {
    public RegisterStatusHandler(Context context, AbstractAppLogicListener abstractAppLogicListener) {
        super(context, abstractAppLogicListener);
    }

    @Override
    protected RegisterStatus getMessage(Intent intent) {
        RegisterStatus registerStatus = (RegisterStatus)intent.getSerializableExtra("extra_app_push_register_status");
        if (!TextUtils.isEmpty((CharSequence)registerStatus.getPushId())) {
            PushPreferencesUtils.putPushId(this.context(), registerStatus.getPushId(), this.context().getPackageName());
            PushPreferencesUtils.putPushIdExpireTime(this.context(), (int)(System.currentTimeMillis() / 1000L + (long)registerStatus.getExpireTime()), this.context().getPackageName());
        }
        return registerStatus;
    }

    @Override
    protected void unsafeSend(RegisterStatus message, PushNotification pushNotification) {
        if (this.appLogicListener() != null && message != null) {
            this.appLogicListener().onRegisterStatus(this.context(), message);
        }
    }

    @Override
    public boolean messageMatch(Intent intent) {
        DebugLogger.i("AbstractMessageHandler", "start RegisterStatusHandler match");
        return "com.meizu.flyme.push.intent.MESSAGE".equals(intent.getAction()) && "register_status".equals(this.getIntentMethod(intent));
    }

    @Override
    public int getProcessorType() {
        return 512;
    }
}

