/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.handler.impl.fileupload;

import android.os.Environment;
import com.meizu.cloud.pushinternal.DebugLogger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipTask {
    private static final String TAG = "ZipTask";
    private static final int BUFF_SIZE = 0x100000;
    private static final int M_SIZE = 1024;
    private File zipFile;

    public ZipTask(String zipFilepath) {
        this.zipFile = new File(zipFilepath);
    }

    public boolean zip(String ... resFile) {
        boolean isZipSuccess = true;
        try {
            if (!this.zipFile.exists()) {
                this.zipFile.getParentFile().mkdirs();
            }
            ArrayList<File> resFileList = new ArrayList<File>();
            String root = Environment.getExternalStorageDirectory().getAbsolutePath();
            for (String filePath : resFile) {
                File file = new File(root + filePath);
                if (!file.exists()) continue;
                resFileList.add(file);
            }
            this.zipFiles(resFileList, this.zipFile);
        }
        catch (Exception e) {
            isZipSuccess = false;
            e.printStackTrace();
            DebugLogger.e(TAG, "zip file error " + e.getMessage());
        }
        return isZipSuccess;
    }

    public boolean zip(List<String> listfile) throws Exception {
        if (!this.zipFile.exists()) {
            this.zipFile.getParentFile().mkdirs();
        }
        ArrayList<File> resFileList = new ArrayList<File>();
        String root = Environment.getExternalStorageDirectory().getAbsolutePath();
        for (String filePath : listfile) {
            File file = new File(root + filePath);
            if (!file.exists()) continue;
            resFileList.add(file);
        }
        this.zipFiles(resFileList, this.zipFile);
        return true;
    }

    private void zipFiles(Collection<File> resFileList, File zipFile) throws Exception {
        ZipOutputStream zipout = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile), 0x100000));
        for (File resFile : resFileList) {
            this.zipFile(resFile, zipout, "");
        }
        zipout.close();
    }

    private void zipFiles(Collection<File> resFileList, File zipFile, String comment) throws Exception {
        ZipOutputStream zipout = null;
        zipout = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile), 0x100000));
        for (File resFile : resFileList) {
            this.zipFile(resFile, zipout, "");
        }
        zipout.setComment(comment);
        zipout.close();
    }

    private void zipFile(File resFile, ZipOutputStream zipout, String rootpath) throws Exception {
        rootpath = rootpath + (rootpath.trim().length() == 0 ? "" : File.separator) + resFile.getName();
        if (resFile.isDirectory()) {
            for (File file : resFile.listFiles()) {
                this.zipFile(file, zipout, rootpath);
            }
        } else {
            DebugLogger.i(TAG, "current file " + rootpath + "/" + resFile.getName() + " size is " + resFile.length() / 1024L + "KB");
            if (resFile.length() < 0xA00000L) {
                int realLength;
                byte[] buffer = new byte[0x100000];
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(resFile), 0x100000);
                zipout.putNextEntry(new ZipEntry(rootpath));
                while ((realLength = in.read(buffer)) != -1) {
                    zipout.write(buffer, 0, realLength);
                }
                in.close();
                zipout.flush();
                zipout.closeEntry();
            }
        }
    }
}

