/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.handler.impl.fileupload;

import android.content.Context;
import android.content.Intent;
import android.os.Environment;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.handler.AbstractAppLogicListener;
import com.meizu.cloud.pushsdk.handler.impl.AbstractMessageHandler;
import com.meizu.cloud.pushsdk.handler.impl.fileupload.ZipTask;
import com.meizu.cloud.pushsdk.handler.impl.model.ControlMessage;
import com.meizu.cloud.pushsdk.handler.impl.model.UploadLogMessage;
import com.meizu.cloud.pushsdk.networking.common.ANResponse;
import com.meizu.cloud.pushsdk.notification.PushNotification;
import com.meizu.cloud.pushsdk.platform.api.PushPlatformManager;
import com.meizu.cloud.pushsdk.util.Connectivity;
import com.meizu.cloud.pushsdk.util.UxIPUtils;
import java.io.File;

public class LogUploadMessageHandler
extends AbstractMessageHandler<UploadLogMessage> {
    public LogUploadMessageHandler(Context context, AbstractAppLogicListener abstractAppLogicListener) {
        super(context, abstractAppLogicListener);
    }

    @Override
    protected UploadLogMessage getMessage(Intent intent) {
        String control = intent.getStringExtra("mz_push_control_message");
        String seqId = intent.getStringExtra("extra_app_push_seq_Id");
        String deviceId = intent.getStringExtra("statistics_imei_key");
        String pushMessage = intent.getStringExtra("pushMessage");
        UploadLogMessage uploadLogMessage = new UploadLogMessage(pushMessage, control, deviceId, seqId);
        return uploadLogMessage;
    }

    @Override
    protected void unsafeSend(UploadLogMessage message, PushNotification pushNotification) {
        DebugLogger.flush();
        String root = Environment.getExternalStorageDirectory().getAbsolutePath();
        String messageId = message.getControlMessage().getStatics().getTaskId();
        String deviceId = message.getControlMessage().getStatics().getDeviceId();
        String uploadFile = root + "/Android/data/pushSdktmp/" + messageId + "_" + deviceId + ".zip";
        ZipTask zipTask = new ZipTask(uploadFile);
        String errorMessage = null;
        File zipFile = null;
        try {
            zipTask.zip(message.getFileList());
            zipFile = new File(uploadFile);
        }
        catch (Exception e) {
            errorMessage = e.getMessage();
            zipFile = null;
            DebugLogger.e("AbstractMessageHandler", "zip error message " + errorMessage);
        }
        if (zipFile != null && zipFile.length() / 1024L > (long)message.getMaxSize()) {
            errorMessage = "the upload file exceeds the max size";
        } else if (message.isWifiUpload() && !Connectivity.isConnectedWifi(this.context())) {
            errorMessage = "current network not allowed upload log file";
        }
        ANResponse<String> response = PushPlatformManager.getInstance(this.context()).uploadLogFile(message.getControlMessage().getStatics().getTaskId(), message.getControlMessage().getStatics().getDeviceId(), errorMessage, zipFile);
        if (response != null && response.isSuccess()) {
            if (zipFile != null) {
                zipFile.delete();
            }
            DebugLogger.e("AbstractMessageHandler", "upload success " + response.getResult());
        } else {
            DebugLogger.i("AbstractMessageHandler", "upload error code " + response.getError() + response.getResult());
        }
    }

    @Override
    public boolean messageMatch(Intent intent) {
        ControlMessage controlMessage;
        DebugLogger.i("AbstractMessageHandler", "start LogUploadMessageHandler match");
        String control = intent.getStringExtra("mz_push_control_message");
        int pushType = 0;
        if (!TextUtils.isEmpty((CharSequence)control) && (controlMessage = ControlMessage.parse(control)).getControl() != null) {
            pushType = controlMessage.getControl().getPushType();
        }
        return "com.meizu.flyme.push.intent.MESSAGE".equals(intent.getAction()) && "2".equals(String.valueOf(pushType));
    }

    @Override
    public int getProcessorType() {
        return 65536;
    }

    @Override
    protected void onBeforeEvent(UploadLogMessage message) {
        UxIPUtils.onReceivePushMessageEvent(this.context(), this.context().getPackageName(), message.getControlMessage().getStatics().getDeviceId(), message.getControlMessage().getStatics().getTaskId(), message.getControlMessage().getStatics().getSeqId(), message.getControlMessage().getStatics().getTime());
    }
}

