/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.handler.impl;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.meizu.cloud.pushinternal.DebugLogger;
import com.meizu.cloud.pushsdk.handler.AbstractAppLogicListener;
import com.meizu.cloud.pushsdk.handler.MessageHandler;
import com.meizu.cloud.pushsdk.notification.PushNotification;
import com.meizu.cloud.pushsdk.pushtracer.utils.Util;
import com.meizu.cloud.pushsdk.util.MzSystemUtils;
import com.meizu.cloud.pushsdk.util.PushPreferencesUtils;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public abstract class AbstractMessageHandler<T>
implements MessageHandler {
    protected static final String TAG = "AbstractMessageHandler";
    public static final int MESSAGE_TYPE_PUSH_SERVICE_V2 = 2;
    public static final int MESSAGE_TYPE_PUSH_SERVICE_V3 = 4;
    public static final int MESSAGE_TYPE_THROUGH = 8;
    public static final int MESSAGE_TYPE_REGISTER = 16;
    public static final int MESSAGE_TYPE_UNREGISTER = 32;
    public static final int MESSAGE_TYPE_NOTIFICATION_CLICK = 64;
    public static final int MESSAGE_TYPE_NOTIFICATION_DELETE = 128;
    public static final int MESSAGE_TYPE_PUSH_SWITCH_STATUS = 256;
    public static final int MESSAGE_TYPE_PUSH_REGISTER_STATUS = 512;
    public static final int MESSAGE_TYPE_PUSH_UNREGISTER_STATUS = 1024;
    public static final int MESSAGE_TYPE_PUSH_SUBTAGS_STATUS = 2048;
    public static final int MESSAGE_TYPE_PUSH_SUBALIAS_STATUS = 4096;
    public static final int MESSAGE_TYPE_SCHEDULE_NOTIFICATION = 8192;
    public static final int MESSAGE_TYPE_RECEIVE_NOTIFY_MESSAGE = 16384;
    public static final int MESSAGE_TYPE_NOTIFICATION_STATE = 32768;
    public static final int MESSAGE_TYPE_UPLOAD_FILE_LOG = 65536;
    private AbstractAppLogicListener abstractAppLogicListener;
    private Context context;
    private Map<Integer, String> messageHandlerMap;
    public static final int SCHEDULE_OFF = 0;
    public static final int SCHEDULE_ON_EXPIRE = 1;
    public static final int SCHEDULE_ON_TIME = 2;
    public static final int SCHEDULE_ON_DELAY = 3;

    protected AbstractMessageHandler(Context context) {
        this(context, null);
    }

    protected AbstractMessageHandler(Context context, AbstractAppLogicListener abstractAppLogicListener) {
        if (context == null) {
            throw new IllegalArgumentException("Context must not be null.");
        }
        this.context = context.getApplicationContext();
        this.abstractAppLogicListener = abstractAppLogicListener;
        this.messageHandlerMap = new HashMap<Integer, String>();
        this.messageHandlerMap.put(2, "MESSAGE_TYPE_PUSH_SERVICE_V2");
        this.messageHandlerMap.put(4, "MESSAGE_TYPE_PUSH_SERVICE_V3");
        this.messageHandlerMap.put(16, "MESSAGE_TYPE_REGISTER");
        this.messageHandlerMap.put(32, "MESSAGE_TYPE_UNREGISTER");
        this.messageHandlerMap.put(8, "MESSAGE_TYPE_THROUGH");
        this.messageHandlerMap.put(64, "MESSAGE_TYPE_NOTIFICATION_CLICK");
        this.messageHandlerMap.put(128, "MESSAGE_TYPE_NOTIFICATION_DELETE");
        this.messageHandlerMap.put(256, "MESSAGE_TYPE_PUSH_SWITCH_STATUS");
        this.messageHandlerMap.put(512, "MESSAGE_TYPE_PUSH_REGISTER_STATUS");
        this.messageHandlerMap.put(2048, "MESSAGE_TYPE_PUSH_SUBTAGS_STATUS");
        this.messageHandlerMap.put(1024, "MESSAGE_TYPE_PUSH_UNREGISTER_STATUS");
        this.messageHandlerMap.put(4096, "MESSAGE_TYPE_PUSH_SUBALIAS_STATUS");
        this.messageHandlerMap.put(8192, "MESSAGE_TYPE_SCHEDULE_NOTIFICATION");
        this.messageHandlerMap.put(16384, "MESSAGE_TYPE_RECEIVE_NOTIFY_MESSAGE");
        this.messageHandlerMap.put(32768, "MESSAGE_TYPE_NOTIFICATION_STATE");
        this.messageHandlerMap.put(65536, "MESSAGE_TYPE_UPLOAD_FILE_LOG");
    }

    protected abstract T getMessage(Intent var1);

    protected abstract void unsafeSend(T var1, PushNotification var2);

    protected PushNotification onCreateNotification(T message) {
        return null;
    }

    protected void onBeforeEvent(T message) {
    }

    protected void onAfterEvent(T Message2) {
    }

    protected int scheduleNotificationStatus(T message) {
        return 0;
    }

    protected void scheduleShowNotification(T message) {
    }

    protected boolean canSendMessage(T message) {
        return true;
    }

    protected String getDeviceId(Intent intent) {
        String deviceId = intent.getStringExtra("statistics_imei_key");
        if (TextUtils.isEmpty((CharSequence)deviceId)) {
            deviceId = MzSystemUtils.getDeviceId(this.context());
            DebugLogger.e(TAG, "force get deviceId " + deviceId);
        }
        return deviceId;
    }

    protected String getTaskId(Intent intent) {
        return intent.getStringExtra("extra_app_push_task_Id");
    }

    protected String getSeqId(Intent intent) {
        return intent.getStringExtra("extra_app_push_seq_Id");
    }

    protected String getPushServiceDefaultPackageName(Intent intent) {
        String defaultPackageName = intent.getStringExtra("extra_app_push_service_default_package_name");
        if (TextUtils.isEmpty((CharSequence)defaultPackageName)) {
            defaultPackageName = this.context().getPackageName();
        }
        return defaultPackageName;
    }

    protected String getPushTimestamp(Intent intent) {
        String pushTimestamp = intent.getStringExtra("extra_app_push_task_timestamp");
        DebugLogger.e(TAG, "receive push timestamp from pushservice " + pushTimestamp);
        if (TextUtils.isEmpty((CharSequence)pushTimestamp)) {
            pushTimestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        }
        return pushTimestamp;
    }

    @Override
    public boolean sendMessage(Intent intent) {
        boolean flag = false;
        if (this.messageMatch(intent)) {
            DebugLogger.e(TAG, "current message Type " + this.getMessageHandlerType(this.getProcessorType()));
            T message = this.getMessage(intent);
            DebugLogger.e(TAG, "current Handler message " + message);
            this.onBeforeEvent(message);
            boolean isCustomSend = false;
            switch (this.scheduleNotificationStatus(message)) {
                case 0: {
                    DebugLogger.e(TAG, "schedule send message off, send message directly");
                    isCustomSend = true;
                    flag = true;
                    break;
                }
                case 1: {
                    DebugLogger.e(TAG, "expire notification, dont show message");
                    flag = false;
                    break;
                }
                case 2: {
                    DebugLogger.e(TAG, "notification on time ,show message");
                    isCustomSend = true;
                    flag = true;
                    break;
                }
                case 3: {
                    DebugLogger.e(TAG, "schedule notification");
                    this.scheduleShowNotification(message);
                    flag = true;
                }
            }
            boolean canSend = this.canSendMessage(message);
            DebugLogger.e(TAG, "can send message " + canSend);
            if (flag && isCustomSend && canSend) {
                this.unsafeSend(message, this.onCreateNotification(message));
                this.onAfterEvent(message);
                DebugLogger.e(TAG, "send message end ");
            }
        }
        return flag;
    }

    public AbstractAppLogicListener appLogicListener() {
        return this.abstractAppLogicListener;
    }

    public Context context() {
        return this.context;
    }

    public String getIntentMethod(Intent intent) {
        return intent.getStringExtra("method");
    }

    public boolean isNotificationJson(String notificationJson) {
        try {
            JSONObject pushMessageObj = new JSONObject(notificationJson);
            return this.context().getPackageName().equals(pushMessageObj.getString("appId"));
        }
        catch (Exception e) {
            DebugLogger.e(TAG, "parse notification error");
            return false;
        }
    }

    public String getDeskTopNotificationPkg(String deskTopNotificationJson) {
        String pkg = "";
        try {
            JSONObject deskTopNotificationJsonObj = new JSONObject(deskTopNotificationJson);
            JSONObject launcherObj = deskTopNotificationJsonObj.getJSONObject("launcher");
            if (launcherObj.has("pkg") && !TextUtils.isEmpty((CharSequence)launcherObj.getString("pkg"))) {
                pkg = launcherObj.getString("pkg");
            }
        }
        catch (Exception e) {
            DebugLogger.e(TAG, "parse desk top json error");
        }
        return pkg;
    }

    public String selfDefineContentString(String uri, Map<String, String> map) {
        String selfJson = null;
        if (!TextUtils.isEmpty((CharSequence)uri)) {
            selfJson = uri;
        } else if (map != null && TextUtils.isEmpty((CharSequence)(selfJson = map.get("sk")))) {
            selfJson = Util.mapToJSONObject(map).toString();
        }
        DebugLogger.e(TAG, "self json " + selfJson);
        return selfJson;
    }

    private String getMessageHandlerType(int type) {
        return this.messageHandlerMap.get(type);
    }

    protected boolean canReceiveMessage(int pushType, String destPackageName) {
        boolean flag = true;
        if (pushType == 0) {
            flag = PushPreferencesUtils.getNotificationMessageSwitchStatus(this.context(), destPackageName);
        } else if (pushType == 1) {
            flag = PushPreferencesUtils.getThroughMessageSwitchStatus(this.context(), destPackageName);
        }
        DebugLogger.e(TAG, destPackageName + (pushType == 0 ? " canNotificationMessage " : " canThroughMessage ") + flag);
        return flag;
    }
}

