/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.base;

import android.util.Log;
import com.meizu.cloud.pushsdk.base.EncryptBase64;
import com.meizu.cloud.pushsdk.base.ILogWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;

class EncryptionWriter
implements ILogWriter {
    private String TAG = "EncryptionWriter";
    private SimpleDateFormat mDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private EncryptBase64 mEncryptBase64 = new EncryptBase64("lo");
    private BufferedWriter mWriter;
    private int mFileCount = 7;
    private String mFileSuffixName = ".log.txt";

    void checkFileCount(File dir) {
        File[] files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(EncryptionWriter.this.mFileSuffixName);
            }
        });
        if (files != null || files.length > this.mFileCount) {
            Arrays.sort(files, new ComparatorByLastModified());
            for (int i = this.mFileCount; i < files.length; ++i) {
                files[i].delete();
            }
        }
    }

    @Override
    public void open(String path) throws IOException {
        File dir = new File(path);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("create " + path + " dir failed!!!");
        }
        String name = this.mDateFormat.format(new Date());
        File file = new File(path, name + this.mFileSuffixName);
        if (!file.exists()) {
            if (!file.createNewFile()) {
                Log.e((String)this.TAG, (String)("create new file " + name + " failed !!!"));
            } else {
                this.checkFileCount(dir);
            }
        }
        this.mWriter = new BufferedWriter(new FileWriter(file, true));
    }

    @Override
    public void write(String header, String tag, String msg) throws IOException {
        if (this.mWriter != null) {
            StringBuffer buffer = new StringBuffer(header);
            buffer.append(tag);
            buffer.append(" ");
            buffer.append(msg);
            this.mWriter.write(this.mEncryptBase64.encode(buffer.toString().getBytes()));
            this.mWriter.write("\r\n");
        }
    }

    @Override
    public void close() throws IOException {
        if (this.mWriter != null) {
            this.mWriter.flush();
            this.mWriter.close();
            this.mWriter = null;
        }
    }

    class ComparatorByLastModified
    implements Comparator<File> {
        ComparatorByLastModified() {
        }

        @Override
        public int compare(File f1, File f2) {
            long diff = f1.lastModified() - f2.lastModified();
            if (diff > 0L) {
                return -1;
            }
            if (diff == 0L) {
                return 0;
            }
            return 1;
        }
    }
}

