/*
 * Decompiled with CFR 0.152.
 */
package com.meizu.cloud.pushsdk.base;

import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.util.Log;
import com.meizu.cloud.pushsdk.base.EncryptionWriter;
import com.meizu.cloud.pushsdk.base.ExecutorProxy;
import com.meizu.cloud.pushsdk.base.ICacheLog;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

class DefaultLog
implements ICacheLog {
    private SimpleDateFormat mDateFormat = new SimpleDateFormat("MM-dd HH:mm:ss");
    private List<LogInfo> mCachedList = Collections.synchronizedList(new ArrayList());
    private Handler mDelayHandler = new Handler(Looper.getMainLooper());
    private long mCacheDuration = 60L;
    private int mCacheCounter = 10;
    private EncryptionWriter mWriter;
    private String mPath = Environment.getExternalStorageDirectory().getAbsolutePath() + "/Android/data/pushSdk/defaultLog";
    private String mPid;
    private boolean mDebugMode = false;

    public DefaultLog() {
        this.mWriter = new EncryptionWriter();
        this.mPid = String.valueOf(Process.myPid());
    }

    private void startDelayTimer() {
        if (this.mCachedList.size() == 0) {
            this.mDelayHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    DefaultLog.this.flush(true);
                }
            }, this.mCacheDuration * 1000L);
        }
    }

    private void checkLogCount() {
        if (this.mCachedList.size() == this.mCacheCounter) {
            this.flush(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void d(String tag, String msg) {
        if (this.mDebugMode) {
            Log.d((String)tag, (String)msg);
        }
        List<LogInfo> list = this.mCachedList;
        synchronized (list) {
            this.startDelayTimer();
            this.addLogInfo(new LogInfo("D", tag, msg));
            this.checkLogCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void i(String tag, String msg) {
        if (this.mDebugMode) {
            Log.i((String)tag, (String)msg);
        }
        List<LogInfo> list = this.mCachedList;
        synchronized (list) {
            this.startDelayTimer();
            this.addLogInfo(new LogInfo("I", tag, msg));
            this.checkLogCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void w(String tag, String msg) {
        if (this.mDebugMode) {
            Log.w((String)tag, (String)msg);
        }
        List<LogInfo> list = this.mCachedList;
        synchronized (list) {
            this.startDelayTimer();
            this.addLogInfo(new LogInfo("W", tag, msg));
            this.checkLogCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void e(String tag, String msg) {
        if (this.mDebugMode) {
            Log.e((String)tag, (String)msg);
        }
        List<LogInfo> list = this.mCachedList;
        synchronized (list) {
            this.startDelayTimer();
            this.addLogInfo(new LogInfo("E", tag, msg));
            this.checkLogCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void e(String tag, String msg, Throwable tr) {
        if (this.mDebugMode) {
            Log.e((String)tag, (String)msg, (Throwable)tr);
        }
        List<LogInfo> list = this.mCachedList;
        synchronized (list) {
            this.startDelayTimer();
            this.addLogInfo(new LogInfo("E", tag, msg + "\n" + Log.getStackTraceString((Throwable)tr)));
            this.checkLogCount();
        }
    }

    @Override
    public void setCacheDuration(long seconds) {
        this.mCacheDuration = seconds;
    }

    @Override
    public void setCacheCount(int counter) {
        this.mCacheCounter = counter;
    }

    @Override
    public void setFilePath(String path) {
        this.mPath = path;
    }

    @Override
    public void flush(boolean async) {
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList tmp = new ArrayList();
                List list = DefaultLog.this.mCachedList;
                synchronized (list) {
                    DefaultLog.this.mDelayHandler.removeCallbacksAndMessages(null);
                    tmp.addAll(DefaultLog.this.mCachedList);
                    DefaultLog.this.mCachedList.clear();
                }
                try {
                    DefaultLog.this.mWriter.open(DefaultLog.this.mPath);
                    for (LogInfo logInfo : tmp) {
                        DefaultLog.this.mWriter.write(logInfo.header, logInfo.tag, logInfo.msg);
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    try {
                        DefaultLog.this.mWriter.close();
                    }
                    catch (Exception exception) {}
                }
            }
        };
        if (async) {
            ExecutorProxy.get().execute(task);
        } else {
            task.run();
        }
    }

    @Override
    public void setDebugMode(boolean debug) {
        this.mDebugMode = debug;
    }

    @Override
    public boolean isDebugMode() {
        return this.mDebugMode;
    }

    private void addLogInfo(LogInfo logInfo) {
        try {
            this.mCachedList.add(logInfo);
        }
        catch (Exception e) {
            Log.e((String)"Logger", (String)("add logInfo error " + e.getMessage()));
        }
    }

    class LogInfo {
        String header;
        String tag;
        String msg;

        public LogInfo(String level, String tag, String msg) {
            StringBuffer buffer = new StringBuffer(DefaultLog.this.mDateFormat.format(new Date()));
            buffer.append(" ");
            buffer.append(DefaultLog.this.mPid);
            buffer.append("-");
            buffer.append(String.valueOf(Thread.currentThread().getId()));
            buffer.append(" ");
            buffer.append(level);
            buffer.append("/");
            this.header = buffer.toString();
            this.tag = tag;
            this.msg = msg;
        }
    }
}

