/*
 * Decompiled with CFR 0.152.
 */
package com.mdsol.mauth;

import com.mdsol.mauth.MAuthVersion;
import com.mdsol.mauth.Signer;
import com.mdsol.mauth.SignerConfiguration;
import com.mdsol.mauth.exceptions.MAuthSigningException;
import com.mdsol.mauth.util.CurrentEpochTimeProvider;
import com.mdsol.mauth.util.EpochTimeProvider;
import com.mdsol.mauth.util.MAuthHeadersHelper;
import com.mdsol.mauth.util.MAuthKeysHelper;
import com.mdsol.mauth.util.MAuthSignatureHelper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSigner
implements Signer {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSigner.class);
    private final UUID appUUID;
    private final PrivateKey privateKey;
    private final EpochTimeProvider epochTimeProvider;
    private boolean v2OnlySignRequests = false;

    public DefaultSigner(SignerConfiguration signerConfiguration) {
        this(signerConfiguration.getAppUUID(), MAuthKeysHelper.getPrivateKeyFromString((String)signerConfiguration.getPrivateKey()), (EpochTimeProvider)new CurrentEpochTimeProvider(), signerConfiguration.isV2OnlySignRequests());
    }

    public DefaultSigner(UUID uUID, String string) {
        this(uUID, MAuthKeysHelper.getPrivateKeyFromString((String)string));
    }

    public DefaultSigner(UUID uUID, String string, EpochTimeProvider epochTimeProvider) {
        this(uUID, MAuthKeysHelper.getPrivateKeyFromString((String)string), epochTimeProvider);
    }

    public DefaultSigner(UUID uUID, PrivateKey privateKey) {
        this(uUID, privateKey, (EpochTimeProvider)new CurrentEpochTimeProvider());
    }

    public DefaultSigner(UUID uUID, PrivateKey privateKey, EpochTimeProvider epochTimeProvider) {
        this(uUID, privateKey, epochTimeProvider, false);
    }

    public DefaultSigner(UUID uUID, String string, EpochTimeProvider epochTimeProvider, boolean bl) {
        this(uUID, MAuthKeysHelper.getPrivateKeyFromString((String)string), epochTimeProvider, bl);
    }

    public DefaultSigner(UUID uUID, PrivateKey privateKey, EpochTimeProvider epochTimeProvider, boolean bl) {
        this.appUUID = uUID;
        this.privateKey = privateKey;
        this.epochTimeProvider = epochTimeProvider;
        this.v2OnlySignRequests = bl;
    }

    @Override
    @Deprecated
    public Map<String, String> generateRequestHeaders(String string, String string2, String string3) throws MAuthSigningException {
        if (null == string3) {
            string3 = "";
        }
        long l = this.epochTimeProvider.inSeconds();
        return this.generateRequestHeadersV1(string, string2, string3.getBytes(StandardCharsets.UTF_8), l);
    }

    @Override
    public Map<String, String> generateRequestHeaders(String string, String string2, byte[] byArray, String string3) throws MAuthSigningException {
        Map<String, String> map;
        if (null == byArray) {
            byArray = "".getBytes(StandardCharsets.UTF_8);
        }
        if (null == string3) {
            string3 = "";
        }
        long l = this.epochTimeProvider.inSeconds();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (!this.v2OnlySignRequests && !(map = this.generateRequestHeadersV1(string, string2, byArray, l)).isEmpty()) {
            hashMap.putAll(map);
        }
        if (!(map = this.generateRequestHeadersV2(string, string2, string3, byArray, l)).isEmpty()) {
            hashMap.putAll(map);
        }
        return hashMap;
    }

    private Map<String, String> generateRequestHeadersV1(String string, String string2, byte[] byArray, long l) throws MAuthSigningException {
        String string3;
        Object object;
        try {
            object = MAuthSignatureHelper.generateUnencryptedSignature((UUID)this.appUUID, (String)string, (String)string2, (byte[])byArray, (String)String.valueOf(l));
            string3 = MAuthSignatureHelper.encryptSignature((PrivateKey)this.privateKey, (byte[])object);
        }
        catch (IOException | CryptoException throwable) {
            logger.error("Error generating request headers", throwable);
            throw new MAuthSigningException(throwable);
        }
        object = new HashMap();
        ((HashMap)object).put("x-mws-authentication", MAuthHeadersHelper.createAuthenticationHeaderValue((UUID)this.appUUID, (String)string3));
        ((HashMap)object).put("x-mws-time", MAuthHeadersHelper.createTimeHeaderValue((long)l));
        return object;
    }

    private Map<String, String> generateRequestHeadersV2(String string, String string2, String string3, byte[] byArray, long l) throws MAuthSigningException {
        String string4;
        String string5 = MAuthSignatureHelper.generateStringToSignV2((UUID)this.appUUID, (String)string, (String)string2, (String)string3, (byte[])byArray, (String)String.valueOf(l));
        try {
            string4 = MAuthSignatureHelper.encryptSignatureRSA((PrivateKey)this.privateKey, (String)string5);
        }
        catch (Exception exception) {
            logger.error("Error generating request headers for V2", (Throwable)exception);
            throw new MAuthSigningException((Throwable)exception);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("mcc-authentication", MAuthHeadersHelper.createAuthenticationHeaderValue((UUID)this.appUUID, (String)string4, (String)MAuthVersion.MWSV2.getValue()));
        hashMap.put("mcc-time", MAuthHeadersHelper.createTimeHeaderValue((long)l));
        return hashMap;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

