/*
 * Decompiled with CFR 0.152.
 */
package com.mdsol.mauth;

import com.mdsol.mauth.MAuthConfiguration;
import com.mdsol.mauth.MAuthVersion;
import com.typesafe.config.Config;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignerConfiguration
implements MAuthConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(SignerConfiguration.class);
    public static final String APP_SECTION_HEADER = "app";
    public static final String MAUTH_SECTION_HEADER = "mauth";
    public static final String APP_UUID_PATH = "app.uuid";
    public static final String APP_PRIVATE_KEY_PATH = "app.private_key";
    public static final String MAUTH_SIGN_VERSIONS = "mauth.sign_versions";
    public static final List<MAuthVersion> ALL_SIGN_VERSIONS = Arrays.asList(MAuthVersion.values());
    public static final List<MAuthVersion> DEFAULT_SIGN_VERSION = Arrays.asList(MAuthVersion.MWS);
    private final UUID appUUID;
    private final transient String privateKey;
    private List<MAuthVersion> signVersions;

    public SignerConfiguration(Config config) {
        this(UUID.fromString(config.getString(APP_UUID_PATH)), config.getString(APP_PRIVATE_KEY_PATH), config.hasPath(MAUTH_SIGN_VERSIONS) ? config.getString(MAUTH_SIGN_VERSIONS) : "");
    }

    public SignerConfiguration(UUID uUID, String string) {
        this(uUID, string, DEFAULT_SIGN_VERSION);
    }

    public SignerConfiguration(UUID uUID, String string, String string2) {
        this.validateNotNull(uUID, "Application UUID");
        this.validateNotBlank(string, "Application Private key");
        this.appUUID = uUID;
        this.privateKey = string;
        this.signVersions = SignerConfiguration.getSignVersions(string2);
    }

    public SignerConfiguration(UUID uUID, String string, List<MAuthVersion> list) {
        this.validateNotNull(uUID, "Application UUID");
        this.validateNotBlank(string, "Application Private key");
        this.appUUID = uUID;
        this.privateKey = string;
        this.signVersions = list;
    }

    public UUID getAppUUID() {
        return this.appUUID;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public List<MAuthVersion> getSignVersions() {
        return this.signVersions;
    }

    public static List<MAuthVersion> getSignVersions(String string2) {
        ArrayList<MAuthVersion> arrayList = new ArrayList<MAuthVersion>();
        ArrayList arrayList2 = new ArrayList();
        if (string2 != null) {
            List<String> list = Arrays.asList(string2.toLowerCase().split(","));
            list.forEach(string -> {
                switch (string.trim()) {
                    case "v1": {
                        arrayList.add(MAuthVersion.MWS);
                        break;
                    }
                    case "v2": {
                        arrayList.add(MAuthVersion.MWSV2);
                        break;
                    }
                    default: {
                        arrayList2.add(string.trim());
                    }
                }
            });
        }
        if (arrayList.isEmpty()) {
            arrayList.addAll(DEFAULT_SIGN_VERSION);
        }
        if (arrayList2.size() > 0) {
            logger.warn("unrecognized versions to sign requests: " + ((Object)arrayList2).toString());
        }
        logger.info("Protocol versions to sign requests: " + ((Object)arrayList).toString());
        return arrayList;
    }
}

