/*
 * Decompiled with CFR 0.152.
 */
package com.mdsol.mauth;

import com.mdsol.mauth.MAuthVersion;
import com.mdsol.mauth.Signer;
import com.mdsol.mauth.SignerConfiguration;
import com.mdsol.mauth.exceptions.MAuthSigningException;
import com.mdsol.mauth.util.CurrentEpochTimeProvider;
import com.mdsol.mauth.util.EpochTimeProvider;
import com.mdsol.mauth.util.MAuthHeadersHelper;
import com.mdsol.mauth.util.MAuthKeysHelper;
import com.mdsol.mauth.util.MAuthSignatureHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSigner
implements Signer {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSigner.class);
    private final UUID appUUID;
    private final PrivateKey privateKey;
    private final EpochTimeProvider epochTimeProvider;
    private List<MAuthVersion> signVersions;

    public DefaultSigner(SignerConfiguration signerConfiguration) {
        this(signerConfiguration.getAppUUID(), MAuthKeysHelper.getPrivateKeyFromString((String)signerConfiguration.getPrivateKey()), (EpochTimeProvider)new CurrentEpochTimeProvider(), signerConfiguration.getSignVersions());
    }

    public DefaultSigner(UUID uUID, String string) {
        this(uUID, MAuthKeysHelper.getPrivateKeyFromString((String)string));
    }

    public DefaultSigner(UUID uUID, String string, EpochTimeProvider epochTimeProvider) {
        this(uUID, MAuthKeysHelper.getPrivateKeyFromString((String)string), epochTimeProvider);
    }

    public DefaultSigner(UUID uUID, PrivateKey privateKey) {
        this(uUID, privateKey, (EpochTimeProvider)new CurrentEpochTimeProvider());
    }

    public DefaultSigner(UUID uUID, PrivateKey privateKey, EpochTimeProvider epochTimeProvider) {
        this(uUID, privateKey, epochTimeProvider, SignerConfiguration.DEFAULT_SIGN_VERSION);
    }

    public DefaultSigner(UUID uUID, String string, EpochTimeProvider epochTimeProvider, List<MAuthVersion> list) {
        this(uUID, MAuthKeysHelper.getPrivateKeyFromString((String)string), epochTimeProvider, list);
    }

    public DefaultSigner(UUID uUID, PrivateKey privateKey, EpochTimeProvider epochTimeProvider, List<MAuthVersion> list) {
        this.appUUID = uUID;
        this.privateKey = privateKey;
        this.epochTimeProvider = epochTimeProvider;
        this.signVersions = list == null || list.isEmpty() ? SignerConfiguration.DEFAULT_SIGN_VERSION : list;
    }

    @Override
    @Deprecated
    public Map<String, String> generateRequestHeaders(String string, String string2, String string3) throws MAuthSigningException {
        if (null == string3) {
            string3 = "";
        }
        long l = this.epochTimeProvider.inSeconds();
        return this.generateRequestHeadersV1(string, string2, string3.getBytes(StandardCharsets.UTF_8), l);
    }

    @Override
    public Map<String, String> generateRequestHeaders(String string, String string2, byte[] byArray, String string3) throws MAuthSigningException {
        Map<String, String> map;
        if (null == byArray) {
            byArray = "".getBytes(StandardCharsets.UTF_8);
        }
        if (null == string3) {
            string3 = "";
        }
        long l = this.epochTimeProvider.inSeconds();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.signVersions.contains(MAuthVersion.MWS) && !(map = this.generateRequestHeadersV1(string, string2, byArray, l)).isEmpty()) {
            hashMap.putAll(map);
        }
        if (this.signVersions.contains(MAuthVersion.MWSV2) && !(map = this.generateRequestHeadersV2(string, string2, string3, byArray, l)).isEmpty()) {
            hashMap.putAll(map);
        }
        return hashMap;
    }

    @Override
    public Map<String, String> generateRequestHeaders(String string, String string2, InputStream inputStream, String string3) throws MAuthSigningException {
        if (null == inputStream) {
            return this.generateRequestHeaders(string, string2, "".getBytes(StandardCharsets.UTF_8), string3);
        }
        if (null == string3) {
            string3 = "";
        }
        long l = this.epochTimeProvider.inSeconds();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.signVersions.contains(MAuthVersion.MWSV2)) {
            Map<String, String> map = this.generateRequestHeadersV2(string, string2, string3, inputStream, l);
            if (!map.isEmpty()) {
                hashMap.putAll(map);
            }
        } else {
            Map<String, String> map = this.generateRequestHeadersV1(string, string2, inputStream, l);
            if (!map.isEmpty()) {
                hashMap.putAll(map);
            }
        }
        return hashMap;
    }

    private Map<String, String> generateRequestHeadersV1(String string, String string2, byte[] byArray, long l) throws MAuthSigningException {
        String string3;
        try {
            byte[] byArray2 = MAuthSignatureHelper.generateUnencryptedSignature((UUID)this.appUUID, (String)string, (String)string2, (byte[])byArray, (String)String.valueOf(l));
            string3 = MAuthSignatureHelper.encryptSignature((PrivateKey)this.privateKey, (byte[])byArray2);
        }
        catch (IOException | CryptoException throwable) {
            logger.error("Error generating request headers", throwable);
            throw new MAuthSigningException(throwable);
        }
        return this.generateRequestHeadersV1(string3, l);
    }

    private Map<String, String> generateRequestHeadersV1(String string, String string2, InputStream inputStream, long l) throws MAuthSigningException {
        String string3;
        try {
            SequenceInputStream sequenceInputStream = MAuthSignatureHelper.createSequenceInputStreamV1((UUID)this.appUUID, (String)string, (String)string2, (InputStream)inputStream, (String)String.valueOf(l));
            string3 = MAuthSignatureHelper.encryptSignature((PrivateKey)this.privateKey, (InputStream)sequenceInputStream);
        }
        catch (IOException | CryptoException throwable) {
            logger.error("Error generating request headers", throwable);
            throw new MAuthSigningException(throwable);
        }
        return this.generateRequestHeadersV1(string3, l);
    }

    private Map<String, String> generateRequestHeadersV1(String string, long l) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("x-mws-authentication", MAuthHeadersHelper.createAuthenticationHeaderValue((UUID)this.appUUID, (String)string));
        hashMap.put("x-mws-time", MAuthHeadersHelper.createTimeHeaderValue((long)l));
        return hashMap;
    }

    private Map<String, String> generateRequestHeadersV2(String string, String string2, String string3, byte[] byArray, long l) throws MAuthSigningException {
        String string4 = MAuthSignatureHelper.generateStringToSignV2((UUID)this.appUUID, (String)string, (String)string2, (String)string3, (byte[])byArray, (String)String.valueOf(l));
        return this.generateRequestHeadersV2(string4, l);
    }

    private Map<String, String> generateRequestHeadersV2(String string, String string2, String string3, InputStream inputStream, long l) throws MAuthSigningException {
        String string4 = MAuthSignatureHelper.generateStringToSignV2((UUID)this.appUUID, (String)string, (String)string2, (String)string3, (InputStream)inputStream, (String)String.valueOf(l));
        return this.generateRequestHeadersV2(string4, l);
    }

    private Map<String, String> generateRequestHeadersV2(String string, long l) throws MAuthSigningException {
        String string2;
        try {
            string2 = MAuthSignatureHelper.encryptSignatureRSA((PrivateKey)this.privateKey, (String)string);
        }
        catch (Exception exception) {
            logger.error("Error generating request headers for V2", (Throwable)exception);
            throw new MAuthSigningException((Throwable)exception);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("mcc-authentication", MAuthHeadersHelper.createAuthenticationHeaderValue((UUID)this.appUUID, (String)string2, (String)MAuthVersion.MWSV2.getValue()));
        hashMap.put("mcc-time", MAuthHeadersHelper.createTimeHeaderValue((long)l));
        return hashMap;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

