/*
 * Decompiled with CFR 0.152.
 */
package com.mdsol.mauth;

import com.mdsol.mauth.DefaultSigner;
import com.mdsol.mauth.MAuthSttpSigner;
import com.mdsol.mauth.MAuthVersion;
import com.mdsol.mauth.Signer;
import com.mdsol.mauth.SignerUtils;
import com.mdsol.mauth.util.EpochTimeProvider;
import java.io.Serializable;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.util.UUID;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import sttp.client3.BasicRequestBody;
import sttp.client3.ByteArrayBody;
import sttp.client3.ByteBufferBody;
import sttp.client3.FileBody;
import sttp.client3.InputStreamBody;
import sttp.client3.MultipartBody;
import sttp.client3.NoBody$;
import sttp.client3.RequestBody;
import sttp.client3.RequestT;
import sttp.client3.StreamBody;
import sttp.client3.StringBody;
import sttp.model.Header$;
import sttp.model.Method;
import sttp.model.Uri;

@ScalaSignature(bytes="\u0006\u0005\u00114A!\u0002\u0004\u0001\u001b!A\u0001\u0004\u0001B\u0001B\u0003%\u0011\u0004C\u0003\u001d\u0001\u0011\u0005Q\u0004C\u0003\u001d\u0001\u0011\u0005\u0001\u0005C\u0003C\u0001\u0011\u00051IA\nN\u0003V$\bn\u0015;uaNKwM\\3s\u00136\u0004HN\u0003\u0002\b\u0011\u0005)Q.Y;uQ*\u0011\u0011BC\u0001\u0006[\u0012\u001cx\u000e\u001c\u0006\u0002\u0017\u0005\u00191m\\7\u0004\u0001M\u0019\u0001A\u0004\u000b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\t)b#D\u0001\u0007\u0013\t9bAA\bN\u0003V$\bn\u0015;uaNKwM\\3s\u0003\u0019\u0019\u0018n\u001a8feB\u0011QCG\u0005\u00037\u0019\u0011aaU5h]\u0016\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u0002\u001f?A\u0011Q\u0003\u0001\u0005\u00061\t\u0001\r!\u0007\u000b\u0006=\u0005Z3G\u000f\u0005\u0006E\r\u0001\raI\u0001\bCB\u0004X+^5e!\t!\u0013&D\u0001&\u0015\t1s%\u0001\u0003vi&d'\"\u0001\u0015\u0002\t)\fg/Y\u0005\u0003U\u0015\u0012A!V+J\t\")Af\u0001a\u0001[\u0005Q\u0001O]5wCR,7*Z=\u0011\u00059\nT\"A\u0018\u000b\u0005A:\u0013\u0001C:fGV\u0014\u0018\u000e^=\n\u0005Iz#A\u0003)sSZ\fG/Z&fs\")Ag\u0001a\u0001k\u0005\tR\r]8dQRKW.\u001a)s_ZLG-\u001a:\u0011\u0005YBT\"A\u001c\u000b\u0005\u00192\u0011BA\u001d8\u0005E)\u0005o\\2i)&lW\r\u0015:pm&$WM\u001d\u0005\u0006w\r\u0001\r\u0001P\u0001\rg&<gNV3sg&|gn\u001d\t\u0004Iuz\u0014B\u0001 &\u0005\u0011a\u0015n\u001d;\u0011\u0005U\u0001\u0015BA!\u0007\u00051i\u0015)\u001e;i-\u0016\u00148/[8o\u0003=\u0019\u0018n\u001a8TiR\u0004(+Z9vKN$XC\u0001#Z)\t)%\r\u0005\u0003G)^{fBA$R\u001d\tAeJ\u0004\u0002J\u00196\t!J\u0003\u0002L\u0019\u00051AH]8pizJ\u0011!T\u0001\u0005gR$\b/\u0003\u0002P!\u000691\r\\5f]R\u001c$\"A'\n\u0005I\u001b\u0016a\u00029bG.\fw-\u001a\u0006\u0003\u001fBK!!\u0016,\u0003\u000fI+\u0017/^3ti*\u0011!k\u0015\t\u00031fc\u0001\u0001B\u0003[\t\t\u00071LA\u0001U#\tav\f\u0005\u0002\u0010;&\u0011a\f\u0005\u0002\b\u001d>$\b.\u001b8h!\ty\u0001-\u0003\u0002b!\t\u0019\u0011I\\=\t\u000b\r$\u0001\u0019A#\u0002\u000fI,\u0017/^3ti\u0002")
public class MAuthSttpSignerImpl
implements MAuthSttpSigner {
    private final Signer signer;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public <T> RequestT<Object, T, Object> signSttpRequest(RequestT<Object, T, Object> request) {
        byte[] byArray;
        block8: {
            RequestBody requestBody;
            block10: {
                BasicRequestBody basicRequestBody;
                block11: {
                    block9: {
                        requestBody = request.body();
                        if (!NoBody$.MODULE$.equals(requestBody)) break block9;
                        byArray = (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte());
                        break block8;
                    }
                    if (!(requestBody instanceof BasicRequestBody)) break block10;
                    BasicRequestBody basicRequestBody2 = (BasicRequestBody)requestBody;
                    basicRequestBody = basicRequestBody2;
                    if (!(basicRequestBody instanceof StringBody)) break block11;
                    StringBody stringBody = (StringBody)basicRequestBody;
                    byArray = stringBody.s().getBytes(StandardCharsets.UTF_8);
                    break block8;
                }
                if (basicRequestBody instanceof ByteArrayBody) {
                    ByteArrayBody byteArrayBody = (ByteArrayBody)basicRequestBody;
                    byte[] bytes = byteArrayBody.b();
                    byArray = bytes;
                    break block8;
                } else if (basicRequestBody instanceof ByteBufferBody) {
                    ByteBufferBody byteBufferBody = (ByteBufferBody)basicRequestBody;
                    ByteBuffer byteBuffer = byteBufferBody.b();
                    byArray = byteBuffer.array();
                    break block8;
                } else {
                    if (basicRequestBody instanceof InputStreamBody) {
                        throw new IllegalArgumentException("Request with InputStream body not supported for mauth signing");
                    }
                    if (basicRequestBody instanceof FileBody) {
                        throw new IllegalArgumentException("MAuth signing not yet implemented for request with multipart body");
                    }
                    throw new MatchError((Object)basicRequestBody);
                }
            }
            if (requestBody instanceof StreamBody) {
                throw new IllegalArgumentException("Request with stream body not supported for mauth signing");
            }
            if (requestBody instanceof MultipartBody) {
                throw new IllegalArgumentException("MAuth signing not yet implemented for request with multipart body");
            }
            throw new MatchError((Object)requestBody);
        }
        byte[] bodyBytes = byArray;
        URI requestUri = ((Uri)request.uri()).toJavaUri();
        List mauthHeaders = ((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala(SignerUtils.signWithUri((Signer)this.signer, (String)((Method)request.method()).method(), (URI)requestUri, (byte[])bodyBytes)).asScala().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return Header$.MODULE$.apply(k, v);
            }
            throw new MatchError((Object)tuple2);
        })).toList();
        return request.headers((Seq)mauthHeaders);
    }

    public MAuthSttpSignerImpl(Signer signer) {
        this.signer = signer;
    }

    public MAuthSttpSignerImpl(UUID appUuid, PrivateKey privateKey, EpochTimeProvider epochTimeProvider, java.util.List<MAuthVersion> signVersions) {
        this((Signer)new DefaultSigner(appUuid, privateKey, epochTimeProvider, signVersions));
    }
}

