/*
 * Decompiled with CFR 0.152.
 */
package com.mdsol.mauth.util;

import com.mdsol.mauth.exceptions.MAuthSigningException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MAuthSignatureHelper {
    private static final Logger logger = LoggerFactory.getLogger(MAuthSignatureHelper.class);

    public static String generateUnencryptedSignature(UUID uUID, String string, String string2, String string3, String string4) {
        logger.debug("Generating Unencrypted Signature");
        return string + "\n" + string2 + "\n" + string3 + "\n" + uUID.toString() + "\n" + string4;
    }

    public static String encryptSignature(PrivateKey privateKey, String string) throws IOException, CryptoException {
        String string2 = MAuthSignatureHelper.getHexEncodedDigestedString(string);
        PKCS1Encoding pKCS1Encoding = new PKCS1Encoding((AsymmetricBlockCipher)new RSAEngine());
        pKCS1Encoding.init(true, (CipherParameters)PrivateKeyFactory.createKey((byte[])privateKey.getEncoded()));
        byte[] byArray = pKCS1Encoding.processBlock(string2.getBytes(), 0, string2.getBytes().length);
        return new String(Base64.encodeBase64((byte[])byArray), "UTF-8");
    }

    public static byte[] decryptSignature(PublicKey publicKey, String string) {
        try {
            byte[] byArray = Base64.decodeBase64((String)string);
            PKCS1Encoding pKCS1Encoding = new PKCS1Encoding((AsymmetricBlockCipher)new RSAEngine());
            pKCS1Encoding.init(false, (CipherParameters)PublicKeyFactory.createKey((byte[])publicKey.getEncoded()));
            byte[] byArray2 = pKCS1Encoding.processBlock(byArray, 0, byArray.length);
            return byArray2;
        }
        catch (IOException | InvalidCipherTextException throwable) {
            logger.error("Couldn't decrypt the signature using given public key.", throwable);
            throw new MAuthSigningException("Couldn't decrypt the signature using given public key.", throwable);
        }
    }

    public static String getHexEncodedDigestedString(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-512", "BC");
            byte[] byArray = messageDigest.digest(string.getBytes(StandardCharsets.UTF_8));
            return Hex.encodeHexString((byte[])byArray);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException generalSecurityException) {
            logger.error("Invalid alghoritm or security provider.", (Throwable)generalSecurityException);
            throw new MAuthSigningException("Invalid alghoritm or security provider.", generalSecurityException);
        }
    }
}

