/*
 * Decompiled with CFR 0.152.
 */
package com.mdsol.mauth;

import com.mdsol.mauth.util.MAuthHeadersHelper;
import java.util.Arrays;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public class MAuthRequest {
    public static final String X_MWS_TIME_HEADER_NAME = "x-mws-time";
    public static final String X_MWS_AUTHENTICATION_HEADER_NAME = "x-mws-authentication";
    private static final String VALIDATION_EXCEPTION_MESSAGE_TEMPLATE = "%s cannot be null or empty.";
    private final UUID appUUID;
    private final String requestSignature;
    private final byte[] messagePayload;
    private final String httpMethod;
    private final long requestTime;
    private final String resourcePath;

    public MAuthRequest(String string, byte[] byArray, String string2, String string3, String string4) {
        this.validateNotBlank(string, "Authentication header value");
        UUID uUID = MAuthHeadersHelper.getAppUUIDFromAuthenticationHeader(string);
        String string5 = MAuthHeadersHelper.getSignatureFromAuthenticationHeader(string);
        this.validateNotBlank(string3, "Time header value");
        long l = MAuthHeadersHelper.getRequestTimeFromTimeHeader(string3);
        this.validateNotBlank(string2, "Http method");
        this.validateNotBlank(string4, "Resource path");
        this.validateRequestTime(l);
        if (byArray == null) {
            byArray = new byte[]{};
        }
        this.appUUID = uUID;
        this.requestSignature = string5;
        this.messagePayload = byArray;
        this.httpMethod = string2;
        this.requestTime = l;
        this.resourcePath = string4;
    }

    public UUID getAppUUID() {
        return this.appUUID;
    }

    public String getRequestSignature() {
        return this.requestSignature;
    }

    public byte[] getMessagePayload() {
        return Arrays.copyOf(this.messagePayload, this.messagePayload.length);
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public long getRequestTime() {
        return this.requestTime;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    private void validateNotBlank(String string, String string2) {
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new IllegalArgumentException(String.format(VALIDATION_EXCEPTION_MESSAGE_TEMPLATE, string2));
        }
    }

    private void validateRequestTime(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("Request time cannot be negative or 0.");
        }
    }

    public static final class Builder {
        private String authenticationHeaderValue;
        private byte[] messagePayload;
        private String httpMethod;
        private String timeHeaderValue;
        private String resourcePath;

        public static Builder get() {
            return new Builder();
        }

        public Builder withAuthenticationHeaderValue(String string) {
            this.authenticationHeaderValue = string;
            return this;
        }

        public Builder withTimeHeaderValue(String string) {
            this.timeHeaderValue = string;
            return this;
        }

        public Builder withMessagePayload(byte[] byArray) {
            this.messagePayload = byArray;
            return this;
        }

        public Builder withHttpMethod(String string) {
            this.httpMethod = string;
            return this;
        }

        public Builder withResourcePath(String string) {
            this.resourcePath = string;
            return this;
        }

        public MAuthRequest build() {
            return new MAuthRequest(this.authenticationHeaderValue, this.messagePayload, this.httpMethod, this.timeHeaderValue, this.resourcePath);
        }
    }
}

