/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.naming;

import com.mchange.v2.cfg.PropertiesConfig;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.naming.NameGuard;
import com.mchange.v2.util.IterableUtils;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;

public final class ReferenceableUtils {
    static final MLogger logger = MLog.getLogger(ReferenceableUtils.class);
    static final String REFADDR_VERSION = "version";
    static final String REFADDR_CLASSNAME = "classname";
    static final String REFADDR_FACTORY = "factory";
    static final String REFADDR_FACTORY_CLASS_LOCATION = "factoryClassLocation";
    static final String REFADDR_SIZE = "size";
    static final int CURRENT_REF_VERSION = 1;
    public static final Set ALL_FACTORY_CLASS_NAMES = Collections.unmodifiableSet(new HashSet());
    private static final String DEFAULT_NAME_GUARD_CLASS_NAME = "com.mchange.v2.naming.ApparentlyLocalNameGuard";
    private static final Map nameGuardClassNameToConstructor = new HashMap();

    public static String literalNullToNull(String string) {
        if (string == null || "null".equals(string)) {
            return null;
        }
        return string;
    }

    public static Object referenceToObject(Reference reference, Name name, Context context, Hashtable hashtable) throws NamingException {
        Set set = ReferenceableUtils.findMandatoryObjectFactoryWhitelist(null);
        return ReferenceableUtils.referenceToObject(reference, name, context, hashtable, set, null);
    }

    public static Object referenceToObject(Reference reference, Name name, Context context, Hashtable hashtable, PropertiesConfig propertiesConfig) throws NamingException {
        Set set = ReferenceableUtils.findMandatoryObjectFactoryWhitelist(propertiesConfig);
        return ReferenceableUtils.referenceToObject(reference, name, context, hashtable, set, propertiesConfig);
    }

    public static Object referenceToObject(Reference reference, Name name, Context context, Hashtable hashtable, Set set) throws NamingException {
        return ReferenceableUtils.referenceToObject(reference, name, context, hashtable, set, null);
    }

    public static Object referenceToObject(Reference reference, Name name, Context context, Hashtable hashtable, Set set, PropertiesConfig propertiesConfig) throws NamingException {
        try {
            Serializable serializable;
            ClassLoader classLoader;
            if (name != null) {
                ReferenceableUtils.assertAcceptableName(name, propertiesConfig);
            }
            String string = reference.getFactoryClassName();
            String string2 = reference.getFactoryClassLocation();
            if (string == null) {
                throw new NamingException("A null factoryClassName was encountered. ReferenceableUtils.referenceToObject(...) does not support null factory class names. If the null is intentional, consider using javax.naming.spi.NamingManager.getObjectInstance(...) which employs certain conventions to dereference with an unspecified factoryClassName. Reference: " + reference);
            }
            if (set != ALL_FACTORY_CLASS_NAMES && !set.contains(string)) {
                throw new NamingException("factoryClassName '" + string + "' is not in allowedFactoryClassNames [" + IterableUtils.joinAsString(",", set) + "]");
            }
            ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
            if (classLoader2 == null) {
                classLoader2 = ReferenceableUtils.class.getClassLoader();
            }
            if (string2 == null) {
                classLoader = classLoader2;
            } else if (ReferenceableUtils.supportReferenceRemoteFactoryClassLocation(propertiesConfig)) {
                serializable = new URL(string2);
                classLoader = new URLClassLoader(new URL[]{serializable}, classLoader2);
            } else {
                if (logger.isLoggable(MLevel.WARNING)) {
                    logger.log(MLevel.WARNING, "A javax.naming.Reference we have been tasked to dereference specifies a potentially remote factory class location. This is dangerous. A malicious reference could load and execute arbitrary code. The factoryClassLocation property of the reference will be ignored, and the reference will atempt to dereference using the calling Thread's context ClassLoader or else the ClassLoader that loaded com.mchange.v2.naming.ReferenceableUtils. Reference: " + reference);
                }
                classLoader = classLoader2;
            }
            serializable = Class.forName(string, true, classLoader);
            ObjectFactory objectFactory = (ObjectFactory)((Class)serializable).newInstance();
            return objectFactory.getObjectInstance(reference, name, context, hashtable);
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Could not resolve Reference to Object!", exception);
            }
            if (exception instanceof NamingException) {
                throw (NamingException)exception;
            }
            NamingException namingException = new NamingException("Could not resolve Reference to Object!");
            namingException.setRootCause(exception);
            throw namingException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final NameGuard nameGuardForClassName(String string) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Map map = nameGuardClassNameToConstructor;
        synchronized (map) {
            Constructor<?> constructor = (Constructor<?>)nameGuardClassNameToConstructor.get(string);
            if (constructor == null) {
                Class<?> clazz = Class.forName(string);
                constructor = clazz.getDeclaredConstructor(new Class[0]);
                nameGuardClassNameToConstructor.put(string, constructor);
            }
            return (NameGuard)constructor.newInstance(new Object[0]);
        }
    }

    public static void assertAcceptableName(Object object, PropertiesConfig propertiesConfig) throws NamingException {
        String string = propertiesConfig == null ? System.getProperty("com.mchange.v2.naming.nameGuardClassName") : propertiesConfig.getProperty("com.mchange.v2.naming.nameGuardClassName");
        try {
            boolean bl;
            NameGuard nameGuard = string == null ? ReferenceableUtils.nameGuardForClassName(DEFAULT_NAME_GUARD_CLASS_NAME) : ReferenceableUtils.nameGuardForClassName(string);
            if (object instanceof String) {
                bl = nameGuard.nameIsAcceptable((String)object);
            } else if (object instanceof Name) {
                bl = nameGuard.nameIsAcceptable((Name)object);
            } else {
                throw new NamingException("Putative JNDI name of unexpected type. We expect String or javax.naming.Name. We conservatively, redundantly, disallow any attempt to lookup of jndi names of unknown types. There is no API to do so. Putative JNDI name: " + object);
            }
            if (!bl) {
                String string2 = string == null ? "default NameGuard 'com.mchange.v2.naming.ApparentlyLocalNameGuard'" : "NameGuard '" + string + "', currently configured via '" + "com.mchange.v2.naming.nameGuardClassName" + "'";
                throw new NamingException("Under " + string2 + ", names are only acceptable when " + nameGuard.onlyAcceptableWhen() + ". '" + object + "' does not qualify.");
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            if (string == null) {
                throw new InternalError("Huh? We failed to reflectively lookup and construct default NameGuard 'com.mchange.v2.naming.ApparentlyLocalNameGuard'?!?", reflectiveOperationException);
            }
            throw new NamingException("We failed to reflectively lookup and construct configured NameGuard '" + string + ". Cause: " + reflectiveOperationException);
        }
    }

    public static boolean supportReferenceRemoteFactoryClassLocation(PropertiesConfig propertiesConfig) {
        return ReferenceableUtils.falseBiasedLookupSyspropsPropertiesConfig("com.mchange.v2.naming.supportReferenceRemoteFactoryClassLocation", propertiesConfig, "Loading of remote factory classes when resolving javax.naming.Reference instances");
    }

    public static boolean acceptDeserializedInitialContextEnvironment(PropertiesConfig propertiesConfig) {
        return ReferenceableUtils.falseBiasedLookupSyspropsPropertiesConfig("com.mchange.v2.naming.acceptDeserializedInitialContextEnvironment", propertiesConfig, "Acceptance of deserialized InitialContext environment");
    }

    private static boolean falseBiasedLookupSyspropsPropertiesConfig(String string, PropertiesConfig propertiesConfig, String string2) {
        boolean bl;
        String string3;
        Boolean bl2;
        String string4 = System.getProperty(string);
        Boolean bl3 = bl2 = string4 == null ? null : Boolean.valueOf(string4);
        Boolean bl4 = propertiesConfig != null ? ((string3 = propertiesConfig.getProperty(string)) == null ? null : Boolean.valueOf(string3)) : null;
        if (Boolean.FALSE.equals(bl2)) {
            if (Boolean.TRUE.equals(bl4) && logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "Security-sensitive property '" + string + "' has been set to 'false' in System properties. Disabling this functionality in System properties conservatively OVERRIDES any configuration of this property set elsewhere, regardless of any alternative prioritization of system properties you may have configured. Please resolve the inconsistency of configuration." + string2 + " will be disabled!");
            }
            bl = false;
        } else if (Boolean.TRUE.equals(bl2)) {
            if (Boolean.FALSE.equals(bl4)) {
                if (logger.isLoggable(MLevel.WARNING)) {
                    logger.log(MLevel.WARNING, "Security-sensitive property '" + string + "' has been set to 'true' in System properties, however it has been set to 'false' in other configuration supplied. Disabling this functionality in  supplied configuration overrides permission granted in System properties. Please resolve the inconsistency of configuration." + string2 + " will be disabled!");
                }
                bl = false;
            } else {
                bl = true;
            }
        } else {
            bl = Boolean.TRUE.equals(bl4);
        }
        return bl;
    }

    public static void appendToReference(Reference reference, Reference reference2) throws NamingException {
        int n = reference2.size();
        reference.add(new StringRefAddr(REFADDR_VERSION, String.valueOf(1)));
        reference.add(new StringRefAddr(REFADDR_CLASSNAME, reference2.getClassName()));
        reference.add(new StringRefAddr(REFADDR_FACTORY, reference2.getFactoryClassName()));
        reference.add(new StringRefAddr(REFADDR_FACTORY_CLASS_LOCATION, reference2.getFactoryClassLocation()));
        reference.add(new StringRefAddr(REFADDR_SIZE, String.valueOf(n)));
        for (int i = 0; i < n; ++i) {
            reference.add(reference2.get(i));
        }
    }

    public static ExtractRec extractNestedReference(Reference reference, int n) throws NamingException {
        try {
            int n2 = Integer.parseInt((String)reference.get(n++).getContent());
            if (n2 == 1) {
                String string = (String)reference.get(n++).getContent();
                String string2 = (String)reference.get(n++).getContent();
                String string3 = (String)reference.get(n++).getContent();
                Reference reference2 = new Reference(string, string2, string3);
                int n3 = Integer.parseInt((String)reference.get(n++).getContent());
                for (int i = 0; i < n3; ++i) {
                    reference2.add(reference.get(n++));
                }
                return new ExtractRec(reference2, n);
            }
            throw new NamingException("Bad version of nested reference!!!");
        }
        catch (NumberFormatException numberFormatException) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Version or size nested reference was not a number!!!", numberFormatException);
            }
            throw new NamingException("Version or size nested reference was not a number!!!");
        }
    }

    private static Set commaSeparatedStringListToModifiableSet(String string) {
        String[] stringArray = string.split("\\s*,\\s*");
        return new HashSet<String>(Arrays.asList(stringArray));
    }

    private static Set commaSeparatedStringListToSet(String string) {
        return Collections.unmodifiableSet(ReferenceableUtils.commaSeparatedStringListToModifiableSet(string));
    }

    private static Set findMandatoryObjectFactoryWhitelist(PropertiesConfig propertiesConfig) throws NamingException {
        Set set = ReferenceableUtils.narrowestStringListPropertiesConfigSystemProperties("com.mchange.v2.naming.objectFactoryWhitelist", propertiesConfig);
        if (set == null) {
            throw new NamingException("No ObjectFactory whitelist found. When calling referenceToObject(...) using overloads that lack an explicit allowedFactoryClassNames Set, a 'com.mchange.v2.naming.objectFactoryWhitelist' must be provided either as a System property or a provided com.mchange.v2.PropertiesConfig instance. If you really want to live dangerously and accept any ObjectFactory (why?!?), you must call an overload of referenceToObject(...) that accepts an explicit allowedFactoryClassNames Set, and then provide it as null.");
        }
        return set;
    }

    private static Set narrowestStringListPropertiesConfigSystemProperties(String string, PropertiesConfig propertiesConfig) {
        Set set;
        String string2;
        String string3 = System.getProperty(string);
        String string4 = string2 = propertiesConfig == null ? null : propertiesConfig.getProperty(string);
        if (string3 == null && string2 == null) {
            return null;
        }
        if (string3 != null && string2 == null) {
            return ReferenceableUtils.commaSeparatedStringListToSet(string3);
        }
        if (string3 == null && string2 != null) {
            return ReferenceableUtils.commaSeparatedStringListToSet(string2);
        }
        Set set2 = ReferenceableUtils.commaSeparatedStringListToModifiableSet(string3);
        if (set2.equals(set = ReferenceableUtils.commaSeparatedStringListToModifiableSet(string2))) {
            return Collections.unmodifiableSet(set2);
        }
        set2.retainAll(set);
        Set set3 = Collections.unmodifiableSet(set2);
        if (logger.isLoggable(MLevel.WARNING)) {
            logger.log(MLevel.WARNING, "Inconsistent values of '" + string + "' were found in System properties and the provided configuration. We are conservatively using the *intersection* of those values. Value in System properties: '" + string3 + "'; Value in PropertiesConfig: '" + string2 + "'; Value of intersection: '" + IterableUtils.joinAsString(",", set3));
        }
        return set3;
    }

    private ReferenceableUtils() {
    }

    public static class ExtractRec {
        public Reference ref;
        public int index;

        private ExtractRec(Reference reference, int n) {
            this.ref = reference;
            this.index = n;
        }
    }
}

