package com.mchange.v1.cachedstore;

import com.mchange.lang.PotentiallySecondary;
import com.mchange.v1.lang.Synchronizer;

public final class CachedStoreUtils
{
    final static boolean DEBUG = true;

    public static CachedStore synchronizedCachedStore(CachedStore orig)
    { return (CachedStore) Synchronizer.createSynchronizedWrapper( orig );  }

    public static TweakableCachedStore synchronizedTweakableCachedStore(TweakableCachedStore orig)
    { return (TweakableCachedStore) Synchronizer.createSynchronizedWrapper( orig );  }

    public static WritableCachedStore synchronizedWritableCachedStore(WritableCachedStore orig)
    { return (WritableCachedStore) Synchronizer.createSynchronizedWrapper( orig );  }

    public static CachedStore untweakableCachedStore(final TweakableCachedStore orig)
    {
	return new CachedStore()
	    {
		public Object find(Object key) throws CachedStoreException
		{ return orig.find( key ); }

		public void reset() throws CachedStoreException
		{ orig.reset(); }
	    };
    }

    static CachedStoreException toCachedStoreException( Throwable t )
    {
	if (DEBUG) t.printStackTrace();

	if (t instanceof CachedStoreException)
	    return (CachedStoreException) t;
	else if (t instanceof PotentiallySecondary)
	    {
		Throwable t2 = ((PotentiallySecondary) t).getNestedThrowable();
		if (t2 instanceof CachedStoreException)
		    return (CachedStoreException) t2;
	    }
	return new CachedStoreException( t );
	    
    }

    static CacheFlushException toCacheFlushException( Throwable t )
    {
	if (DEBUG) t.printStackTrace();

	if (t instanceof CacheFlushException)
	    return (CacheFlushException) t;
	else 
	    return new CacheFlushException( t );
	    
    }

    private CachedStoreUtils()
    {}
}
