/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0;

import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ThreadFactory;

public final class TaskRunnerThreadFactory
implements ThreadFactory {
    private static final MLogger logger = MLog.getLogger(TaskRunnerThreadFactory.class);
    private static final ClassLoader LIBRARY_CLASSLOADER_INSTANCE = TaskRunnerThreadFactory.class.getClassLoader();
    private static final ContextClassLoaderSetter NO_CLASSLOADER = new ContextClassLoaderSetter(){

        @Override
        public void set(Thread thread) {
            thread.setContextClassLoader(null);
        }
    };
    private static final ContextClassLoaderSetter LIBRARY_CLASSLOADER = new ContextClassLoaderSetter(){

        @Override
        public void set(Thread thread) {
            thread.setContextClassLoader(LIBRARY_CLASSLOADER_INSTANCE);
        }
    };
    private static final ContextClassLoaderSetter CALLER_CLASSLOADER = new ContextClassLoaderSetter(){

        @Override
        public void set(Thread thread) {
        }
    };
    ContextClassLoaderSetter contextClassLoaderSetter;
    boolean privilege_spawned_threads;
    String threadLabel;
    ThreadGroup threadGroup;
    int count = 0;

    public TaskRunnerThreadFactory(String string, boolean bl, String string2, ThreadGroup threadGroup) {
        if ("none".equalsIgnoreCase(string)) {
            this.contextClassLoaderSetter = NO_CLASSLOADER;
        } else if ("library".equalsIgnoreCase(string)) {
            this.contextClassLoaderSetter = LIBRARY_CLASSLOADER;
        } else {
            if (logger.isLoggable(MLevel.WARNING) && !"caller".equalsIgnoreCase(string)) {
                logger.log(MLevel.WARNING, "Unknown contextClassLoaderSource: " + string + " -- should be 'caller', 'library', or 'none'. Using default value 'caller'.");
            }
            this.contextClassLoaderSetter = CALLER_CLASSLOADER;
        }
        this.privilege_spawned_threads = bl;
        this.threadLabel = string2;
        this.threadGroup = threadGroup;
    }

    private synchronized int nextCount() {
        return ++this.count;
    }

    private Thread createUnprivileged(Runnable runnable) {
        Thread thread = new Thread(this.threadGroup, runnable, this.threadLabel + "-" + this.nextCount());
        this.contextClassLoaderSetter.set(thread);
        return thread;
    }

    @Override
    public Thread newThread(final Runnable runnable) {
        if (this.privilege_spawned_threads) {
            PrivilegedAction privilegedAction = new PrivilegedAction(){

                public Object run() {
                    return TaskRunnerThreadFactory.this.createUnprivileged(runnable);
                }
            };
            return (Thread)AccessController.doPrivileged(privilegedAction);
        }
        return this.createUnprivileged(runnable);
    }

    private static interface ContextClassLoaderSetter {
        public void set(Thread var1);
    }
}

