/*
 * Decompiled with CFR 0.152.
 */
package com.maxkeppeler.bottomsheets.time_clock;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.text.style.UnderlineSpan;
import android.view.View;
import com.maxkeppeler.bottomsheets.core.utils.ThemeExtKt;
import com.maxkeppeler.bottomsheets.core.utils.TimeExtKt;
import com.maxkeppeler.bottomsheets.core.views.BottomSheetContent;
import com.maxkeppeler.bottomsheets.core.views.BottomSheetNumericalInput;
import com.maxkeppeler.bottomsheets.core.views.BottomSheetValue;
import com.maxkeppeler.bottomsheets.time_clock.R;
import com.maxkeppeler.bottomsheets.time_clock.databinding.BottomSheetsTimeClockBinding;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0019H\u0002J\u0018\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u001cJ\b\u0010\u001e\u001a\u00020\u0016H\u0002J\b\u0010\u001f\u001a\u00020\u0016H\u0002J\u0010\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\nH\u0002J\b\u0010\"\u001a\u00020\u0016H\u0002J\b\u0010#\u001a\u00020\u0016H\u0002J\u0012\u0010$\u001a\u00020\u00162\b\b\u0002\u0010%\u001a\u00020\u0007H\u0002J\b\u0010&\u001a\u00020\u0016H\u0002J\u0010\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u001dH\u0007J\b\u0010)\u001a\u00020\u0016H\u0002J\f\u0010*\u001a\u00020\u0016*\u00020+H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00060\u000ej\u0002`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00060\u000ej\u0002`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/maxkeppeler/bottomsheets/time_clock/ClockTimeSelector;", "", "ctx", "Landroid/content/Context;", "bindingSelector", "Lcom/maxkeppeler/bottomsheets/time_clock/databinding/BottomSheetsTimeClockBinding;", "is24HoursView", "", "(Landroid/content/Context;Lcom/maxkeppeler/bottomsheets/time_clock/databinding/BottomSheetsTimeClockBinding;Z)V", "colorTextInactive", "", "currentIndex", "highlightColor", "hoursBuffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "isAm", "isPositionOnHours", "minsBuffer", "primaryColor", "textActiveColor", "focusOnHours", "", "focusOnMinutes", "getHoursTime", "", "getMinutesTime", "getTime", "Lkotlin/Triple;", "", "increaseIndex", "limitKeyboardOnIndexInput", "onDigit", "value", "processIndexChange", "reduceIndex", "setAmActive", "active", "setPmActive", "setTime", "timeInMillis", "setUnderlineToIndex", "changeHighlightColor", "Landroid/view/View;", "time-clock"})
public final class ClockTimeSelector {
    private final int colorTextInactive;
    private final int primaryColor;
    private final int textActiveColor;
    private final int highlightColor;
    private final StringBuilder hoursBuffer;
    private final StringBuilder minsBuffer;
    private boolean isPositionOnHours;
    private int currentIndex;
    private boolean isAm;
    private final BottomSheetsTimeClockBinding bindingSelector;
    private final boolean is24HoursView;

    private final void changeHighlightColor(View $this$changeHighlightColor) {
        Drawable drawable = $this$changeHighlightColor.getBackground();
        if (drawable == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.graphics.drawable.RippleDrawable");
        }
        RippleDrawable rippleDrawable = (RippleDrawable)drawable;
        boolean bl = false;
        boolean bl2 = false;
        RippleDrawable $this$apply = rippleDrawable;
        boolean bl3 = false;
        $this$apply.setColor(ColorStateList.valueOf((int)this.highlightColor));
    }

    private final void onDigit(int value) {
        if (this.isPositionOnHours) {
            if (this.is24HoursView) {
                if (this.currentIndex == 0 && value >= 3 && value <= 9) {
                    StringBuilder stringBuilder = this.hoursBuffer;
                    int n = this.currentIndex;
                    char c = '0';
                    boolean bl = false;
                    stringBuilder.setCharAt(n, c);
                    this.increaseIndex();
                    stringBuilder = this.hoursBuffer;
                    n = this.currentIndex;
                    c = String.valueOf(value).charAt(0);
                    bl = false;
                    stringBuilder.setCharAt(n, c);
                } else {
                    boolean bl;
                    char c;
                    int n;
                    StringBuilder stringBuilder;
                    if (this.currentIndex == 0 && value != 0 && Character.getNumericValue(this.hoursBuffer.charAt(1)) > 3) {
                        stringBuilder = this.hoursBuffer;
                        n = 1;
                        c = '0';
                        bl = false;
                        stringBuilder.setCharAt(n, c);
                    }
                    stringBuilder = this.hoursBuffer;
                    n = this.currentIndex;
                    c = String.valueOf(value).charAt(0);
                    bl = false;
                    stringBuilder.setCharAt(n, c);
                }
            } else if (this.currentIndex == 0 && value >= 2 && value <= 9) {
                StringBuilder stringBuilder = this.hoursBuffer;
                int n = this.currentIndex;
                char c = '0';
                boolean bl = false;
                stringBuilder.setCharAt(n, c);
                this.increaseIndex();
                stringBuilder = this.hoursBuffer;
                n = this.currentIndex;
                c = String.valueOf(value).charAt(0);
                bl = false;
                stringBuilder.setCharAt(n, c);
            } else {
                boolean bl;
                char c;
                int n;
                StringBuilder stringBuilder;
                if (this.currentIndex == 0) {
                    if (value != 0 && Character.getNumericValue(this.hoursBuffer.charAt(1)) > 2) {
                        stringBuilder = this.hoursBuffer;
                        n = 1;
                        c = '0';
                        bl = false;
                        stringBuilder.setCharAt(n, c);
                    } else if (value == 0 && Character.getNumericValue(this.hoursBuffer.charAt(1)) == 0) {
                        stringBuilder = this.hoursBuffer;
                        n = 1;
                        c = '1';
                        bl = false;
                        stringBuilder.setCharAt(n, c);
                    }
                }
                stringBuilder = this.hoursBuffer;
                n = this.currentIndex;
                c = String.valueOf(value).charAt(0);
                bl = false;
                stringBuilder.setCharAt(n, c);
            }
            BottomSheetValue bottomSheetValue = this.bindingSelector.hoursInput;
            Intrinsics.checkNotNullExpressionValue((Object)bottomSheetValue, (String)"bindingSelector.hoursInput");
            bottomSheetValue.setText((CharSequence)this.getHoursTime());
        } else {
            StringBuilder stringBuilder = this.minsBuffer;
            int n = this.currentIndex;
            char c = String.valueOf(value).charAt(0);
            boolean bl = false;
            stringBuilder.setCharAt(n, c);
            BottomSheetContent bottomSheetContent = this.bindingSelector.minutesInput;
            Intrinsics.checkNotNullExpressionValue((Object)bottomSheetContent, (String)"bindingSelector.minutesInput");
            bottomSheetContent.setText((CharSequence)this.getMinutesTime());
        }
        this.increaseIndex();
    }

    private final void focusOnHours() {
        this.currentIndex = 0;
        this.isPositionOnHours = true;
        this.processIndexChange();
    }

    private final void focusOnMinutes() {
        this.currentIndex = 0;
        this.isPositionOnHours = false;
        this.processIndexChange();
    }

    private final void reduceIndex() {
        if (this.currentIndex == 1) {
            int n = this.currentIndex;
            this.currentIndex = n + -1;
        } else if (this.currentIndex < 1) {
            this.isPositionOnHours = !this.isPositionOnHours;
            this.currentIndex = 1;
        }
        this.processIndexChange();
    }

    private final void increaseIndex() {
        if (this.currentIndex == 0) {
            int n = this.currentIndex;
            this.currentIndex = n + 1;
        } else if (this.currentIndex >= 1) {
            this.isPositionOnHours = !this.isPositionOnHours;
            this.currentIndex = 0;
        }
        this.processIndexChange();
    }

    private final void processIndexChange() {
        this.setUnderlineToIndex();
        this.limitKeyboardOnIndexInput();
    }

    private final void limitKeyboardOnIndexInput() {
        BottomSheetNumericalInput bottomSheetNumericalInput = this.bindingSelector.numericalInput;
        boolean bl = false;
        boolean bl2 = false;
        BottomSheetNumericalInput $this$with = bottomSheetNumericalInput;
        boolean bl3 = false;
        if (this.isPositionOnHours && this.currentIndex == 0) {
            BottomSheetNumericalInput.enableDigits$default((BottomSheetNumericalInput)$this$with, null, (int)1, null);
        } else if (this.isPositionOnHours && this.currentIndex == 1) {
            BottomSheetNumericalInput.enableDigits$default((BottomSheetNumericalInput)$this$with, null, (int)1, null);
            if (this.is24HoursView) {
                if (this.hoursBuffer.charAt(0) == '2') {
                    int n = 4;
                    $this$with.disableDigits(new IntRange(n, 9));
                }
            } else if (this.hoursBuffer.charAt(0) == '1' || this.hoursBuffer.charAt(0) == '2') {
                int n = 3;
                $this$with.disableDigits(new IntRange(n, 9));
            } else if (this.hoursBuffer.charAt(0) == '0') {
                int n = 0;
                $this$with.disableDigits(new IntRange(n, 0));
            }
        } else if (!this.isPositionOnHours && this.currentIndex == 0) {
            if (this.hoursBuffer.charAt(0) == '2' && this.hoursBuffer.charAt(1) == '4') {
                BottomSheetNumericalInput.disableDigits$default((BottomSheetNumericalInput)$this$with, null, (int)1, null);
            } else {
                BottomSheetNumericalInput.enableDigits$default((BottomSheetNumericalInput)$this$with, null, (int)1, null);
                int n = 6;
                $this$with.disableDigits(new IntRange(n, 9));
            }
        } else if (!this.isPositionOnHours && this.currentIndex == 1) {
            BottomSheetNumericalInput.enableDigits$default((BottomSheetNumericalInput)$this$with, null, (int)1, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setUnderlineToIndex() {
        BottomSheetsTimeClockBinding bottomSheetsTimeClockBinding = this.bindingSelector;
        boolean bl = false;
        boolean bl2 = false;
        BottomSheetsTimeClockBinding $this$with = bottomSheetsTimeClockBinding;
        boolean bl3 = false;
        BottomSheetValue bottomSheetValue = $this$with.hoursInput;
        Intrinsics.checkNotNullExpressionValue((Object)bottomSheetValue, (String)"hoursInput");
        BottomSheetValue bottomSheetValue2 = this.bindingSelector.hoursInput;
        Intrinsics.checkNotNullExpressionValue((Object)bottomSheetValue2, (String)"bindingSelector.hoursInput");
        bottomSheetValue.setText((CharSequence)((Object)bottomSheetValue2.getText()).toString());
        BottomSheetContent bottomSheetContent = $this$with.minutesInput;
        Intrinsics.checkNotNullExpressionValue((Object)bottomSheetContent, (String)"minutesInput");
        BottomSheetContent bottomSheetContent2 = this.bindingSelector.minutesInput;
        Intrinsics.checkNotNullExpressionValue((Object)bottomSheetContent2, (String)"bindingSelector.minutesInput");
        bottomSheetContent.setText((CharSequence)((Object)bottomSheetContent2.getText()).toString());
        ForegroundColorSpan spanColor = new ForegroundColorSpan(this.textActiveColor);
        if (this.isPositionOnHours) {
            void $this$apply;
            BottomSheetValue bottomSheetValue3 = $this$with.hoursInput;
            Intrinsics.checkNotNullExpressionValue((Object)bottomSheetValue3, (String)"hoursInput");
            BottomSheetValue bottomSheetValue4 = this.bindingSelector.hoursInput;
            Intrinsics.checkNotNullExpressionValue((Object)bottomSheetValue4, (String)"bindingSelector.hoursInput");
            SpannableString spannableString = new SpannableString(bottomSheetValue4.getText());
            boolean bl4 = false;
            boolean bl5 = false;
            SpannableString spannableString2 = spannableString;
            BottomSheetValue bottomSheetValue5 = bottomSheetValue3;
            boolean bl6 = false;
            $this$apply.setSpan((Object)spanColor, this.currentIndex, this.currentIndex + 1, 33);
            UnderlineSpan underlineSpan = new UnderlineSpan();
            boolean bl7 = false;
            boolean bl8 = false;
            UnderlineSpan underlineSpan2 = underlineSpan;
            void var17_23 = $this$apply;
            boolean bl9 = false;
            Unit unit = Unit.INSTANCE;
            var17_23.setSpan((Object)underlineSpan, this.currentIndex, this.currentIndex + 1, 33);
            Unit unit2 = Unit.INSTANCE;
            bottomSheetValue5.setText((CharSequence)spannableString);
        } else {
            BottomSheetContent bottomSheetContent3 = $this$with.minutesInput;
            Intrinsics.checkNotNullExpressionValue((Object)bottomSheetContent3, (String)"minutesInput");
            BottomSheetContent bottomSheetContent4 = this.bindingSelector.minutesInput;
            Intrinsics.checkNotNullExpressionValue((Object)bottomSheetContent4, (String)"bindingSelector.minutesInput");
            SpannableString spannableString = new SpannableString(bottomSheetContent4.getText());
            boolean bl10 = false;
            boolean bl11 = false;
            SpannableString $this$apply = spannableString;
            BottomSheetContent bottomSheetContent5 = bottomSheetContent3;
            boolean bl12 = false;
            $this$apply.setSpan((Object)spanColor, this.currentIndex, this.currentIndex + 1, 33);
            $this$apply.setSpan((Object)new UnderlineSpan(), this.currentIndex, this.currentIndex + 1, 33);
            Unit unit = Unit.INSTANCE;
            bottomSheetContent5.setText((CharSequence)spannableString);
        }
    }

    @NotNull
    public final Triple<Long, Integer, Integer> getTime() {
        String string = this.getHoursTime();
        boolean bl = false;
        int hh = Integer.parseInt(string);
        String string2 = this.getMinutesTime();
        boolean bl2 = false;
        int mm = Integer.parseInt(string2);
        if (!this.is24HoursView) {
            if (this.isAm && hh >= 12 && mm > 0) {
                hh -= 12;
            } else if (!this.isAm && hh < 12 && mm >= 0) {
                hh += 12;
            }
        }
        long hhMillis = TimeUnit.HOURS.toMillis(hh);
        long mmMillis = TimeUnit.MINUTES.toMillis(mm);
        long millis = hhMillis + mmMillis;
        return new Triple((Object)millis, (Object)hh, (Object)mm);
    }

    @SuppressLint(value={"SimpleDateFormat"})
    public final void setTime(long timeInMillis) {
        String formatHours = this.is24HoursView ? "HH" : "hh";
        String formatMinutes = "mm";
        TimeZone timeZoneUTC = TimeZone.getTimeZone("etc/UTC");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(formatHours);
        boolean bl = false;
        boolean bl2 = false;
        SimpleDateFormat $this$apply = simpleDateFormat;
        boolean bl3 = false;
        $this$apply.setTimeZone(timeZoneUTC);
        String hours = simpleDateFormat.format(timeInMillis);
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat(formatMinutes);
        bl2 = false;
        boolean bl4 = false;
        SimpleDateFormat $this$apply2 = simpleDateFormat2;
        boolean bl5 = false;
        $this$apply2.setTimeZone(timeZoneUTC);
        String minutes = simpleDateFormat2.format(timeInMillis);
        if (TimeExtKt.isAmTime((long)timeInMillis)) {
            ClockTimeSelector.setAmActive$default(this, false, 1, null);
        } else {
            this.setPmActive();
        }
        String string = hours;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"hours");
        this.hoursBuffer.replace(0, 2, StringsKt.padStart((String)string, (int)2, (char)'0'));
        String string2 = minutes;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"minutes");
        this.minsBuffer.replace(0, 2, StringsKt.padStart((String)string2, (int)2, (char)'0'));
        BottomSheetValue bottomSheetValue = this.bindingSelector.hoursInput;
        Intrinsics.checkNotNullExpressionValue((Object)bottomSheetValue, (String)"bindingSelector.hoursInput");
        bottomSheetValue.setText((CharSequence)this.getHoursTime());
        BottomSheetContent bottomSheetContent = this.bindingSelector.minutesInput;
        Intrinsics.checkNotNullExpressionValue((Object)bottomSheetContent, (String)"bindingSelector.minutesInput");
        bottomSheetContent.setText((CharSequence)this.getMinutesTime());
        this.focusOnHours();
    }

    private final String getHoursTime() {
        String string = this.hoursBuffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"hoursBuffer.toString()");
        return StringsKt.padStart((String)string, (int)2, (char)'0');
    }

    private final String getMinutesTime() {
        String string = this.minsBuffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"minsBuffer.toString()");
        return StringsKt.padStart((String)string, (int)2, (char)'0');
    }

    private final void setAmActive(boolean active) {
        this.bindingSelector.amLabel.setTextColor(active ? this.textActiveColor : this.colorTextInactive);
        this.bindingSelector.pmLabel.setTextColor(active ? this.colorTextInactive : this.textActiveColor);
        this.isAm = active;
    }

    static /* synthetic */ void setAmActive$default(ClockTimeSelector clockTimeSelector, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        clockTimeSelector.setAmActive(bl);
    }

    private final void setPmActive() {
        this.setAmActive(false);
    }

    public ClockTimeSelector(@NotNull Context ctx, @NotNull BottomSheetsTimeClockBinding bindingSelector, boolean is24HoursView) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)bindingSelector, (String)"bindingSelector");
        this.bindingSelector = bindingSelector;
        this.is24HoursView = is24HoursView;
        this.colorTextInactive = ThemeExtKt.getTextColor((Context)ctx);
        this.primaryColor = ThemeExtKt.getPrimaryColor((Context)ctx);
        Integer n = ThemeExtKt.takeUnlessNotResolved((int)ThemeExtKt.colorOfAttrs((Context)ctx, (int[])new int[]{R.attr.bottomSheetValueTextActiveColor}));
        this.textActiveColor = n != null ? n : this.primaryColor;
        this.highlightColor = ThemeExtKt.getHighlightColor((Context)ctx);
        this.hoursBuffer = new StringBuilder("00");
        this.minsBuffer = new StringBuilder("00");
        this.isPositionOnHours = true;
        this.isAm = true;
        BottomSheetsTimeClockBinding bottomSheetsTimeClockBinding = this.bindingSelector;
        boolean bl = false;
        boolean bl2 = false;
        BottomSheetsTimeClockBinding $this$with = bottomSheetsTimeClockBinding;
        boolean bl3 = false;
        $this$with.hoursInput.setTextColor(this.colorTextInactive);
        BottomSheetValue bottomSheetValue = $this$with.hoursInput;
        Intrinsics.checkNotNullExpressionValue((Object)bottomSheetValue, (String)"hoursInput");
        bottomSheetValue.setText((CharSequence)this.getHoursTime());
        $this$with.minutesInput.setTextColor(this.colorTextInactive);
        BottomSheetContent bottomSheetContent = $this$with.minutesInput;
        Intrinsics.checkNotNullExpressionValue((Object)bottomSheetContent, (String)"minutesInput");
        bottomSheetContent.setText((CharSequence)this.getMinutesTime());
        $this$with.numericalInput.rightImageListener((Function0)new Function0<Unit>(this){
            final /* synthetic */ ClockTimeSelector this$0;
            {
                this.this$0 = clockTimeSelector;
                super(0);
            }

            public final void invoke() {
                ClockTimeSelector.access$increaseIndex(this.this$0);
            }
        });
        $this$with.numericalInput.setRightImageDrawable(R.drawable.bs_ic_arrow_right);
        $this$with.numericalInput.leftImageListener((Function0)new Function0<Unit>(this){
            final /* synthetic */ ClockTimeSelector this$0;
            {
                this.this$0 = clockTimeSelector;
                super(0);
            }

            public final void invoke() {
                ClockTimeSelector.access$reduceIndex(this.this$0);
            }
        });
        $this$with.numericalInput.setLeftImageDrawable(R.drawable.bs_ic_arrow_left);
        $this$with.numericalInput.digitListener((Function1)new Function1<Integer, Unit>(this){
            final /* synthetic */ ClockTimeSelector this$0;
            {
                this.this$0 = clockTimeSelector;
                super(1);
            }

            public final void invoke(int it) {
                ClockTimeSelector.access$onDigit(this.this$0, it);
            }
        });
        $this$with.hoursInput.setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ ClockTimeSelector this$0;
            {
                this.this$0 = clockTimeSelector;
            }

            public final void onClick(View it) {
                ClockTimeSelector.access$focusOnHours(this.this$0);
            }
        });
        $this$with.minutesInput.setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ ClockTimeSelector this$0;
            {
                this.this$0 = clockTimeSelector;
            }

            public final void onClick(View it) {
                ClockTimeSelector.access$focusOnMinutes(this.this$0);
            }
        });
        BottomSheetContent bottomSheetContent2 = $this$with.amLabel;
        Intrinsics.checkNotNullExpressionValue((Object)bottomSheetContent2, (String)"amLabel");
        bottomSheetContent2.setVisibility(this.is24HoursView ? 8 : 0);
        BottomSheetContent bottomSheetContent3 = $this$with.pmLabel;
        Intrinsics.checkNotNullExpressionValue((Object)bottomSheetContent3, (String)"pmLabel");
        bottomSheetContent3.setVisibility(this.is24HoursView ? 8 : 0);
        BottomSheetContent bottomSheetContent4 = $this$with.amLabel;
        Intrinsics.checkNotNullExpressionValue((Object)bottomSheetContent4, (String)"amLabel");
        this.changeHighlightColor((View)bottomSheetContent4);
        $this$with.amLabel.setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ ClockTimeSelector this$0;
            {
                this.this$0 = clockTimeSelector;
            }

            public final void onClick(View it) {
                ClockTimeSelector.setAmActive$default(this.this$0, false, 1, null);
            }
        });
        BottomSheetContent bottomSheetContent5 = $this$with.pmLabel;
        Intrinsics.checkNotNullExpressionValue((Object)bottomSheetContent5, (String)"pmLabel");
        this.changeHighlightColor((View)bottomSheetContent5);
        $this$with.pmLabel.setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ ClockTimeSelector this$0;
            {
                this.this$0 = clockTimeSelector;
            }

            public final void onClick(View it) {
                ClockTimeSelector.access$setPmActive(this.this$0);
            }
        });
        ClockTimeSelector.setAmActive$default(this, false, 1, null);
        this.processIndexChange();
    }

    public /* synthetic */ ClockTimeSelector(Context context, BottomSheetsTimeClockBinding bottomSheetsTimeClockBinding, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(context, bottomSheetsTimeClockBinding, bl);
    }

    public static final /* synthetic */ void access$increaseIndex(ClockTimeSelector $this) {
        $this.increaseIndex();
    }

    public static final /* synthetic */ void access$reduceIndex(ClockTimeSelector $this) {
        $this.reduceIndex();
    }

    public static final /* synthetic */ void access$onDigit(ClockTimeSelector $this, int value) {
        $this.onDigit(value);
    }

    public static final /* synthetic */ void access$focusOnHours(ClockTimeSelector $this) {
        $this.focusOnHours();
    }

    public static final /* synthetic */ void access$focusOnMinutes(ClockTimeSelector $this) {
        $this.focusOnMinutes();
    }

    public static final /* synthetic */ void access$setPmActive(ClockTimeSelector $this) {
        $this.setPmActive();
    }
}

