/*
 * Decompiled with CFR 0.152.
 */
package com.marshalchen.ultimaterecyclerview.ui;

import android.content.Context;
import android.support.v4.widget.SwipeRefreshLayout;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.ViewConfiguration;

public class VerticalSwipeRefreshLayout
extends SwipeRefreshLayout {
    private int mTouchSlop;
    private float mPrevX;

    public VerticalSwipeRefreshLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.mPrevX = MotionEvent.obtain((MotionEvent)event).getX();
                break;
            }
            case 2: {
                float eventX = event.getX();
                float xDiff = Math.abs(eventX - this.mPrevX);
                if (!(xDiff > (float)this.mTouchSlop)) break;
                return false;
            }
        }
        return super.onInterceptTouchEvent(event);
    }
}

