/*
 * Decompiled with CFR 0.152.
 */
package com.marshalchen.ultimaterecyclerview.stickyheadersrecyclerview.rendering;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.marshalchen.ultimaterecyclerview.stickyheadersrecyclerview.calculation.DimensionCalculator;
import com.marshalchen.ultimaterecyclerview.stickyheadersrecyclerview.util.OrientationProvider;

public class HeaderRenderer {
    private final DimensionCalculator mDimensionCalculator;
    private final OrientationProvider mOrientationProvider;

    public HeaderRenderer(OrientationProvider orientationProvider) {
        this(orientationProvider, new DimensionCalculator());
    }

    private HeaderRenderer(OrientationProvider orientationProvider, DimensionCalculator dimensionCalculator) {
        this.mOrientationProvider = orientationProvider;
        this.mDimensionCalculator = dimensionCalculator;
    }

    public void drawHeader(RecyclerView recyclerView, Canvas canvas, View header, Rect offset) {
        canvas.save();
        if (recyclerView.getLayoutManager().getClipToPadding()) {
            Rect clipRect = this.getClipRectForHeader(recyclerView, header);
            canvas.clipRect(clipRect);
        }
        canvas.translate((float)offset.left, (float)offset.top);
        header.draw(canvas);
        canvas.restore();
    }

    private Rect getClipRectForHeader(RecyclerView recyclerView, View header) {
        Rect headerMargins = this.mDimensionCalculator.getMargins(header);
        if (this.mOrientationProvider.getOrientation(recyclerView) == 1) {
            return new Rect(recyclerView.getPaddingLeft(), recyclerView.getPaddingTop(), recyclerView.getWidth() - recyclerView.getPaddingRight() - headerMargins.right, recyclerView.getHeight() - recyclerView.getPaddingBottom());
        }
        return new Rect(recyclerView.getPaddingLeft(), recyclerView.getPaddingTop(), recyclerView.getWidth() - recyclerView.getPaddingRight(), recyclerView.getHeight() - recyclerView.getPaddingBottom() - headerMargins.bottom);
    }
}

