/*
 * Decompiled with CFR 0.152.
 */
package com.marshalchen.ultimaterecyclerview.stickyheadersrecyclerview;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.support.v7.widget.RecyclerView;
import android.util.SparseArray;
import android.view.View;
import com.marshalchen.ultimaterecyclerview.stickyheadersrecyclerview.HeaderPositionCalculator;
import com.marshalchen.ultimaterecyclerview.stickyheadersrecyclerview.StickyRecyclerHeadersAdapter;
import com.marshalchen.ultimaterecyclerview.stickyheadersrecyclerview.caching.HeaderProvider;
import com.marshalchen.ultimaterecyclerview.stickyheadersrecyclerview.caching.HeaderViewCache;
import com.marshalchen.ultimaterecyclerview.stickyheadersrecyclerview.calculation.DimensionCalculator;
import com.marshalchen.ultimaterecyclerview.stickyheadersrecyclerview.rendering.HeaderRenderer;
import com.marshalchen.ultimaterecyclerview.stickyheadersrecyclerview.util.LinearLayoutOrientationProvider;
import com.marshalchen.ultimaterecyclerview.stickyheadersrecyclerview.util.OrientationProvider;

public class StickyRecyclerHeadersDecoration
extends RecyclerView.ItemDecoration {
    private final StickyRecyclerHeadersAdapter mAdapter;
    private final SparseArray<Rect> mHeaderRects = new SparseArray();
    private final HeaderProvider mHeaderProvider;
    private final OrientationProvider mOrientationProvider;
    private final HeaderPositionCalculator mHeaderPositionCalculator;
    private final HeaderRenderer mRenderer;
    private final DimensionCalculator mDimensionCalculator;

    public StickyRecyclerHeadersDecoration(StickyRecyclerHeadersAdapter adapter) {
        this(adapter, new LinearLayoutOrientationProvider(), new DimensionCalculator());
    }

    private StickyRecyclerHeadersDecoration(StickyRecyclerHeadersAdapter adapter, OrientationProvider orientationProvider, DimensionCalculator dimensionCalculator) {
        this(adapter, orientationProvider, dimensionCalculator, new HeaderRenderer(orientationProvider), new HeaderViewCache(adapter, orientationProvider));
    }

    private StickyRecyclerHeadersDecoration(StickyRecyclerHeadersAdapter adapter, OrientationProvider orientationProvider, DimensionCalculator dimensionCalculator, HeaderRenderer headerRenderer, HeaderProvider headerProvider) {
        this(adapter, headerRenderer, orientationProvider, dimensionCalculator, headerProvider, new HeaderPositionCalculator(adapter, headerProvider, orientationProvider, dimensionCalculator));
    }

    private StickyRecyclerHeadersDecoration(StickyRecyclerHeadersAdapter adapter, HeaderRenderer headerRenderer, OrientationProvider orientationProvider, DimensionCalculator dimensionCalculator, HeaderProvider headerProvider, HeaderPositionCalculator headerPositionCalculator) {
        this.mAdapter = adapter;
        this.mHeaderProvider = headerProvider;
        this.mOrientationProvider = orientationProvider;
        this.mRenderer = headerRenderer;
        this.mDimensionCalculator = dimensionCalculator;
        this.mHeaderPositionCalculator = headerPositionCalculator;
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent2, RecyclerView.State state) {
        super.getItemOffsets(outRect, view, parent2, state);
        int itemPosition = parent2.getChildAdapterPosition(view);
        if (itemPosition == -1) {
            return;
        }
        if (this.mHeaderPositionCalculator.hasNewHeader(itemPosition)) {
            View header = this.getHeaderView(parent2, itemPosition);
            this.setItemOffsetsForHeader(outRect, header, this.mOrientationProvider.getOrientation(parent2));
        }
    }

    private void setItemOffsetsForHeader(Rect itemOffsets, View header, int orientation) {
        Rect headerMargins = this.mDimensionCalculator.getMargins(header);
        if (orientation == 1) {
            itemOffsets.top = header.getHeight() + headerMargins.top + headerMargins.bottom;
        } else {
            itemOffsets.left = header.getWidth() + headerMargins.left + headerMargins.right;
        }
    }

    public void onDrawOver(Canvas canvas, RecyclerView parent2, RecyclerView.State state) {
        super.onDrawOver(canvas, parent2, state);
        this.mHeaderRects.clear();
        if (parent2.getChildCount() <= 0 || this.mAdapter.getItemCount() <= 0) {
            return;
        }
        for (int i = 0; i < parent2.getChildCount(); ++i) {
            View itemView = parent2.getChildAt(i);
            int position = parent2.getChildAdapterPosition(itemView);
            if (position == -1 || !this.hasStickyHeader(i, position) && !this.mHeaderPositionCalculator.hasNewHeader(position)) continue;
            View header = this.mHeaderProvider.getHeader(parent2, position);
            Rect headerOffset = this.mHeaderPositionCalculator.getHeaderBounds(parent2, header, itemView, this.hasStickyHeader(i, position));
            this.mRenderer.drawHeader(parent2, canvas, header, headerOffset);
            this.mHeaderRects.put(position, (Object)headerOffset);
        }
    }

    private boolean hasStickyHeader(int listChildPosition, int indexInList) {
        return listChildPosition <= 0 && this.mAdapter.getHeaderId(indexInList) >= 0L;
    }

    public int findHeaderPositionUnder(int x, int y) {
        for (int i = 0; i < this.mHeaderRects.size(); ++i) {
            Rect rect = (Rect)this.mHeaderRects.get(this.mHeaderRects.keyAt(i));
            if (!rect.contains(x, y)) continue;
            return this.mHeaderRects.keyAt(i);
        }
        return -1;
    }

    public View getHeaderView(RecyclerView parent2, int position) {
        return this.mHeaderProvider.getHeader(parent2, position);
    }

    public void invalidateHeaders() {
        this.mHeaderProvider.invalidate();
    }
}

