/*
 * Decompiled with CFR 0.152.
 */
package com.marshalchen.ultimaterecyclerview.quickAdapter.extBaseAdapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.util.Linkify;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.Checkable;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RatingBar;
import android.widget.TextView;
import com.bumptech.glide.Glide;

public class BaseAdapterHelper {
    private final SparseArray<View> views;
    private final Context context;
    private int position;
    private View convertView;
    public int layoutId;
    Object associatedObject;

    protected BaseAdapterHelper(Context context, ViewGroup parent2, int layoutId, int position) {
        this.context = context;
        this.position = position;
        this.layoutId = layoutId;
        this.views = new SparseArray();
        this.convertView = LayoutInflater.from((Context)context).inflate(layoutId, parent2, false);
        this.convertView.setTag((Object)this);
    }

    public static BaseAdapterHelper get(Context context, View convertView, ViewGroup parent2, int layoutId) {
        return BaseAdapterHelper.get(context, convertView, parent2, layoutId, -1);
    }

    static BaseAdapterHelper get(Context context, View convertView, ViewGroup parent2, int layoutId, int position) {
        if (convertView == null) {
            return new BaseAdapterHelper(context, parent2, layoutId, position);
        }
        BaseAdapterHelper existingHelper = (BaseAdapterHelper)convertView.getTag();
        if (existingHelper.layoutId != layoutId) {
            return new BaseAdapterHelper(context, parent2, layoutId, position);
        }
        existingHelper.position = position;
        return existingHelper;
    }

    public <T extends View> T getView(int viewId) {
        return this.retrieveView(viewId);
    }

    protected <T extends View> T retrieveView(int viewId) {
        View view = (View)this.views.get(viewId);
        if (view == null) {
            view = this.convertView.findViewById(viewId);
            this.views.put(viewId, (Object)view);
        }
        return (T)view;
    }

    public BaseAdapterHelper setText(int viewId, String value) {
        TextView view = (TextView)this.retrieveView(viewId);
        view.setText((CharSequence)value);
        return this;
    }

    public BaseAdapterHelper setImageResource(int viewId, int imageResId) {
        ImageView view = (ImageView)this.retrieveView(viewId);
        view.setImageResource(imageResId);
        return this;
    }

    public BaseAdapterHelper setBackgroundColor(int viewId, int color2) {
        Object view = this.retrieveView(viewId);
        view.setBackgroundColor(color2);
        return this;
    }

    public BaseAdapterHelper setBackgroundRes(int viewId, int backgroundRes) {
        Object view = this.retrieveView(viewId);
        view.setBackgroundResource(backgroundRes);
        return this;
    }

    public BaseAdapterHelper setTextColor(int viewId, int textColor) {
        TextView view = (TextView)this.retrieveView(viewId);
        view.setTextColor(textColor);
        return this;
    }

    public BaseAdapterHelper setTextColorRes(int viewId, int textColorRes) {
        TextView view = (TextView)this.retrieveView(viewId);
        view.setTextColor(this.context.getResources().getColor(textColorRes));
        return this;
    }

    public BaseAdapterHelper setImageDrawable(int viewId, Drawable drawable2) {
        ImageView view = (ImageView)this.retrieveView(viewId);
        view.setImageDrawable(drawable2);
        return this;
    }

    public BaseAdapterHelper setImageUrl(int viewId, String imageUrl) {
        ImageView view = (ImageView)this.retrieveView(viewId);
        Glide.with((Context)this.context).load(imageUrl).into(view);
        return this;
    }

    public BaseAdapterHelper setImageBitmap(int viewId, Bitmap bitmap) {
        ImageView view = (ImageView)this.retrieveView(viewId);
        view.setImageBitmap(bitmap);
        return this;
    }

    @SuppressLint(value={"NewApi"})
    public BaseAdapterHelper setAlpha(int viewId, float value) {
        if (Build.VERSION.SDK_INT >= 11) {
            this.retrieveView(viewId).setAlpha(value);
        } else {
            AlphaAnimation alpha = new AlphaAnimation(value, value);
            alpha.setDuration(0L);
            alpha.setFillAfter(true);
            this.retrieveView(viewId).startAnimation((Animation)alpha);
        }
        return this;
    }

    public BaseAdapterHelper setVisible(int viewId, boolean visible) {
        Object view = this.retrieveView(viewId);
        view.setVisibility(visible ? 0 : 8);
        return this;
    }

    public BaseAdapterHelper linkify(int viewId) {
        TextView view = (TextView)this.retrieveView(viewId);
        Linkify.addLinks((TextView)view, (int)15);
        return this;
    }

    public BaseAdapterHelper setTypeface(int viewId, Typeface typeface) {
        TextView view = (TextView)this.retrieveView(viewId);
        view.setTypeface(typeface);
        view.setPaintFlags(view.getPaintFlags() | 0x80);
        return this;
    }

    public BaseAdapterHelper setTypeface(Typeface typeface, int ... viewIds) {
        for (int viewId : viewIds) {
            TextView view = (TextView)this.retrieveView(viewId);
            view.setTypeface(typeface);
            view.setPaintFlags(view.getPaintFlags() | 0x80);
        }
        return this;
    }

    public BaseAdapterHelper setProgress(int viewId, int progress) {
        ProgressBar view = (ProgressBar)this.retrieveView(viewId);
        view.setProgress(progress);
        return this;
    }

    public BaseAdapterHelper setProgress(int viewId, int progress, int max) {
        ProgressBar view = (ProgressBar)this.retrieveView(viewId);
        view.setMax(max);
        view.setProgress(progress);
        return this;
    }

    public BaseAdapterHelper setMax(int viewId, int max) {
        ProgressBar view = (ProgressBar)this.retrieveView(viewId);
        view.setMax(max);
        return this;
    }

    public BaseAdapterHelper setRating(int viewId, float rating) {
        RatingBar view = (RatingBar)this.retrieveView(viewId);
        view.setRating(rating);
        return this;
    }

    public BaseAdapterHelper setRating(int viewId, float rating, int max) {
        RatingBar view = (RatingBar)this.retrieveView(viewId);
        view.setMax(max);
        view.setRating(rating);
        return this;
    }

    public BaseAdapterHelper setTag(int viewId, Object tag) {
        Object view = this.retrieveView(viewId);
        view.setTag(tag);
        return this;
    }

    public BaseAdapterHelper setTag(int viewId, int key, Object tag) {
        Object view = this.retrieveView(viewId);
        view.setTag(key, tag);
        return this;
    }

    public BaseAdapterHelper setChecked(int viewId, boolean checked) {
        Checkable view = (Checkable)this.retrieveView(viewId);
        view.setChecked(checked);
        return this;
    }

    public BaseAdapterHelper setAdapter(int viewId, Adapter adapter) {
        AdapterView view = (AdapterView)this.retrieveView(viewId);
        view.setAdapter(adapter);
        return this;
    }

    public BaseAdapterHelper setOnClickListener(int viewId, View.OnClickListener listener) {
        Object view = this.retrieveView(viewId);
        view.setOnClickListener(listener);
        return this;
    }

    public BaseAdapterHelper setOnTouchListener(int viewId, View.OnTouchListener listener) {
        Object view = this.retrieveView(viewId);
        view.setOnTouchListener(listener);
        return this;
    }

    public BaseAdapterHelper setOnLongClickListener(int viewId, View.OnLongClickListener listener) {
        Object view = this.retrieveView(viewId);
        view.setOnLongClickListener(listener);
        return this;
    }

    public View getView() {
        return this.convertView;
    }

    public int getPosition() {
        if (this.position == -1) {
            throw new IllegalStateException("Use BaseAdapterHelper constructor with position if you need to retrieve the position.");
        }
        return this.position;
    }

    public Object getAssociatedObject() {
        return this.associatedObject;
    }

    public void setAssociatedObject(Object associatedObject) {
        this.associatedObject = associatedObject;
    }
}

