/*
 * Decompiled with CFR 0.152.
 */
package com.marshalchen.ultimaterecyclerview.expanx;

import android.content.Context;
import android.support.annotation.LayoutRes;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.marshalchen.ultimaterecyclerview.UltimateViewAdapter;
import com.marshalchen.ultimaterecyclerview.expanx.ExpandableItemData;
import com.marshalchen.ultimaterecyclerview.expanx.Util.BaseViewHolder;
import com.marshalchen.ultimaterecyclerview.expanx.Util.ChildVH;
import com.marshalchen.ultimaterecyclerview.expanx.Util.ItemDataClickListener;
import com.marshalchen.ultimaterecyclerview.expanx.Util.OnScrollToListener;
import com.marshalchen.ultimaterecyclerview.expanx.Util.ParentVH;
import com.marshalchen.ultimaterecyclerview.expanx.Util.child;
import com.marshalchen.ultimaterecyclerview.expanx.Util.parent;
import java.util.ArrayList;
import java.util.List;

public abstract class LinearExpanxURVAdapter<T extends ExpandableItemData, G extends parent<T>, H extends child<T>>
extends UltimateViewAdapter {
    private Context mContext;
    private List<T> mDataSet;
    private List<OnScrollToListener> monScrollToListenerList = new ArrayList<OnScrollToListener>();
    private OnScrollToListener onScrollToListener;
    public static final String TAG = "expAdapter";
    protected int expandableBehavior = 0;
    public static final int EXPANDABLE_ITEMS = 1;
    public static final int EXPANDABLE_SYSTEM = 0;
    private boolean customObject;
    private ItemDataClickListener imageSetLoadItems = new ItemDataClickListener<T>(){

        @Override
        public void onExpandChildren(T itemData) {
            int position = LinearExpanxURVAdapter.this.getCurrentPosition(((ExpandableItemData)itemData).getUuid());
            List children = ((ExpandableItemData)itemData).getChildren();
            if (children == null) {
                return;
            }
            LinearExpanxURVAdapter.this.addAll(children, position + 1);
            LinearExpanxURVAdapter.this.triggerSingleEventScrollTo(position + 1);
            LinearExpanxURVAdapter.this.triggerBoardCastEventScrollTo(position + 1);
        }

        @Override
        public void onHideChildren(T itemData) {
            int position = LinearExpanxURVAdapter.this.getCurrentPosition(((ExpandableItemData)itemData).getUuid());
            List children = ((ExpandableItemData)itemData).getChildren();
            if (children == null) {
                return;
            }
            LinearExpanxURVAdapter.this.removeAll(position + 1, LinearExpanxURVAdapter.this.getChildrenCount(itemData) - 1);
            LinearExpanxURVAdapter.this.triggerSingleEventScrollTo(position);
            LinearExpanxURVAdapter.this.triggerBoardCastEventScrollTo(position);
        }
    };
    private ItemDataClickListener imageClickListener = new ItemDataClickListener<T>(){

        @Override
        public void onExpandChildren(T itemData) {
            int position = LinearExpanxURVAdapter.this.getCurrentPosition(((ExpandableItemData)itemData).getUuid());
            List children = LinearExpanxURVAdapter.this.getChildrenByPath(((ExpandableItemData)itemData).getPath(), ((ExpandableItemData)itemData).getTreeDepth(), position);
            if (children == null) {
                return;
            }
            LinearExpanxURVAdapter.this.addAll(children, position + 1);
            ((ExpandableItemData)itemData).setChildren(children);
            LinearExpanxURVAdapter.this.triggerSingleEventScrollTo(position + 1);
            LinearExpanxURVAdapter.this.triggerBoardCastEventScrollTo(position + 1);
        }

        @Override
        public void onHideChildren(T itemData) {
            int position = LinearExpanxURVAdapter.this.getCurrentPosition(((ExpandableItemData)itemData).getUuid());
            List children = ((ExpandableItemData)itemData).getChildren();
            if (children == null) {
                return;
            }
            LinearExpanxURVAdapter.this.removeAll(position + 1, LinearExpanxURVAdapter.this.getChildrenCount(itemData) - 1);
            LinearExpanxURVAdapter.this.triggerSingleEventScrollTo(position);
            LinearExpanxURVAdapter.this.triggerBoardCastEventScrollTo(position);
            ((ExpandableItemData)itemData).setChildren(null);
        }
    };

    protected Context getContext() {
        return this.mContext;
    }

    protected List<T> getSet() {
        return this.mDataSet;
    }

    public void addOnScrollToListener(OnScrollToListener onScrollToListener) {
        this.monScrollToListenerList.add(onScrollToListener);
    }

    @Deprecated
    public void setOnScrollToListener(OnScrollToListener onScrollToListener) {
        this.onScrollToListener = onScrollToListener;
    }

    public LinearExpanxURVAdapter(Context context, int clickhandler, boolean customholder) {
        this(context, clickhandler);
        this.customObject = customholder;
    }

    public LinearExpanxURVAdapter(Context context, int clickhandler) {
        this(context);
        this.expandableBehavior = clickhandler;
    }

    public LinearExpanxURVAdapter(Context context) {
        this.mContext = context;
        this.mDataSet = new ArrayList<T>();
        this.customObject = false;
    }

    protected abstract G iniCustomParentHolder(View var1);

    protected abstract H iniCustomChildHolder(View var1);

    private View initiateview(ViewGroup parent2, @LayoutRes int layout2) {
        return LayoutInflater.from((Context)parent2.getContext()).inflate(layout2, parent2, false);
    }

    protected abstract int getLayoutResParent();

    protected abstract int getLayoutResChild();

    public BaseViewHolder onCreateViewHolder(ViewGroup parent2, int viewType) {
        switch (viewType) {
            case 1026: {
                return this.iniCustomParentHolder(this.initiateview(parent2, this.getLayoutResParent()));
            }
            case 1135: {
                return this.iniCustomChildHolder(this.initiateview(parent2, this.getLayoutResChild()));
            }
        }
        return null;
    }

    private ItemDataClickListener getBehavior() {
        switch (this.expandableBehavior) {
            case 1: {
                return this.imageSetLoadItems;
            }
        }
        return this.imageClickListener;
    }

    public RecyclerView.ViewHolder getViewHolder(View view) {
        return null;
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        switch (this.getItemViewType(position)) {
            case 1026: {
                ParentVH imageViewHolder = (ParentVH)holder;
                imageViewHolder.bindView((ExpandableItemData)this.mDataSet.get(position), position, this.getBehavior());
                break;
            }
            case 1135: {
                ChildVH textViewHolder = (ChildVH)holder;
                textViewHolder.bindView((ExpandableItemData)this.mDataSet.get(position), position);
                break;
            }
        }
    }

    public BaseViewHolder onCreateViewHolder(ViewGroup viewGroup) {
        return new BaseViewHolder((View)viewGroup);
    }

    private void triggerBoardCastEventScrollTo(int n) {
        for (int i = 0; i < this.monScrollToListenerList.size(); ++i) {
            OnScrollToListener m = this.monScrollToListenerList.get(i);
            m.scrollTo(n);
        }
    }

    private void triggerSingleEventScrollTo(int n) {
        if (this.onScrollToListener != null) {
            this.onScrollToListener.scrollTo(n);
        }
    }

    protected abstract List<T> getChildrenByPath(String var1, int var2, int var3);

    @Override
    public RecyclerView.ViewHolder onCreateHeaderViewHolder(ViewGroup viewGroup) {
        return null;
    }

    @Override
    public void onBindHeaderViewHolder(RecyclerView.ViewHolder viewHolder, int i) {
    }

    @Override
    public int getItemCount() {
        return this.mDataSet.size();
    }

    @Override
    public int getAdapterItemCount() {
        return this.getItemCount();
    }

    @Override
    public long generateHeaderId(int i) {
        return 0L;
    }

    private int getChildrenCount(T item) {
        ArrayList<Object> list = new ArrayList<Object>();
        this.printChild(item, list);
        return list.size();
    }

    private void printChild(Object item, List<Object> list) {
        ExpandableItemData it;
        list.add(item);
        if (item instanceof ExpandableItemData && (it = (ExpandableItemData)item).getChildren() != null) {
            for (int i = 0; i < it.getChildren().size(); ++i) {
                this.printChild(it.getChildren().get(i), list);
            }
        }
    }

    protected void removeAll(int position, int itemCount) {
        for (int i = 0; i < itemCount; ++i) {
            this.mDataSet.remove(position);
        }
        this.notifyItemRangeRemoved(position, itemCount);
    }

    protected int getCurrentPosition(String uuid) {
        for (int i = 0; i < this.mDataSet.size(); ++i) {
            if (!uuid.equalsIgnoreCase(((ExpandableItemData)this.mDataSet.get(i)).getUuid())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getItemViewType(int position) {
        return ((ExpandableItemData)this.mDataSet.get(position)).getType();
    }

    public void add(T text, int position) {
        this.mDataSet.add(position, text);
        this.notifyItemInserted(position);
    }

    public void addAll(List<T> list, int position) {
        this.mDataSet.addAll(position, list);
        this.notifyItemRangeInserted(position, list.size());
    }

    public void delete(int pos) {
        if (pos >= 0 && pos < this.mDataSet.size()) {
            if (((ExpandableItemData)this.mDataSet.get(pos)).getType() == 1026 && ((ExpandableItemData)this.mDataSet.get(pos)).isExpand()) {
                for (int i = 0; i < ((ExpandableItemData)this.mDataSet.get(pos)).getChildren().size() + 1; ++i) {
                    this.mDataSet.remove(pos);
                }
                this.notifyItemRangeRemoved(pos, ((ExpandableItemData)this.mDataSet.get(pos)).getChildren().size() + 1);
            } else {
                this.mDataSet.remove(pos);
                this.notifyItemRemoved(pos);
            }
        }
    }

    public class ExpandableViewTypes
    extends UltimateViewAdapter.VIEW_TYPES {
        public static final int ITEM_TYPE_PARENT = 1026;
        public static final int ITEM_TYPE_CHILD = 1135;

        protected ExpandableViewTypes() {
        }
    }
}

