/*
 * Decompiled with CFR 0.152.
 */
package com.marshalchen.ultimaterecyclerview.dragsortadapter;

import android.annotation.TargetApi;
import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.PointF;
import android.support.v7.widget.RecyclerView;
import android.view.MotionEvent;
import android.view.View;
import com.marshalchen.ultimaterecyclerview.dragsortadapter.DragInfo;
import com.marshalchen.ultimaterecyclerview.dragsortadapter.DragManager;
import com.marshalchen.ultimaterecyclerview.dragsortadapter.DragSortShadowBuilder;

public abstract class DragSortAdapter<VH extends ViewHolder>
extends RecyclerView.Adapter<VH> {
    private static final String TAG = DragSortAdapter.class.getSimpleName();
    private final int SCROLL_AMOUNT;
    private final DragManager dragManager;
    private int scrollState;
    private final PointF lastTouchPoint;

    @TargetApi(value=11)
    public DragSortAdapter(RecyclerView recyclerView) {
        this.SCROLL_AMOUNT = (int)(2.0f * Resources.getSystem().getDisplayMetrics().density);
        this.scrollState = 0;
        this.lastTouchPoint = new PointF();
        this.setHasStableIds(true);
        this.dragManager = new DragManager(recyclerView, this);
        recyclerView.setOnDragListener((View.OnDragListener)this.dragManager);
        recyclerView.addOnItemTouchListener(new RecyclerView.OnItemTouchListener(){

            public boolean onInterceptTouchEvent(RecyclerView rv, MotionEvent e) {
                DragSortAdapter.this.lastTouchPoint.set(e.getX(), e.getY());
                return false;
            }

            public void onTouchEvent(RecyclerView rv, MotionEvent e) {
            }

            public void onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {
            }
        });
        recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(final RecyclerView recyclerView, int dx, int dy) {
                recyclerView.post(new Runnable(){

                    @Override
                    public void run() {
                        DragSortAdapter.this.handleScroll(recyclerView);
                    }
                });
            }

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                DragSortAdapter.this.scrollState = newState;
                switch (newState) {
                    case 0: {
                        DragSortAdapter.this.handleScroll(recyclerView);
                        break;
                    }
                }
            }
        });
    }

    public abstract int getPositionForId(long var1);

    public abstract boolean move(int var1, int var2);

    public void onDrop() {
    }

    public long getDraggingId() {
        return this.dragManager.getDraggingId();
    }

    public PointF getLastTouchPoint() {
        return new PointF(this.lastTouchPoint.x, this.lastTouchPoint.y);
    }

    private void handleScroll(RecyclerView recyclerView) {
        if (this.scrollState != 0) {
            return;
        }
        DragInfo lastDragInfo = this.dragManager.getLastDragInfo();
        if (lastDragInfo != null) {
            this.handleDragScroll(recyclerView, lastDragInfo);
        }
    }

    @TargetApi(value=14)
    void handleDragScroll(RecyclerView rv, DragInfo dragInfo) {
        if (rv.getLayoutManager().canScrollHorizontally()) {
            if (rv.canScrollHorizontally(-1) && dragInfo.shouldScrollLeft()) {
                rv.scrollBy(-this.SCROLL_AMOUNT, 0);
                this.dragManager.clearNextMove();
            } else if (rv.canScrollHorizontally(1) && dragInfo.shouldScrollRight(rv.getWidth())) {
                rv.scrollBy(this.SCROLL_AMOUNT, 0);
                this.dragManager.clearNextMove();
            }
        } else if (rv.getLayoutManager().canScrollVertically()) {
            if (rv.canScrollVertically(-1) && dragInfo.shouldScrollUp()) {
                rv.scrollBy(0, -this.SCROLL_AMOUNT);
                this.dragManager.clearNextMove();
            } else if (rv.canScrollVertically(1) && dragInfo.shouldScrollDown(rv.getHeight())) {
                rv.scrollBy(0, this.SCROLL_AMOUNT);
                this.dragManager.clearNextMove();
            }
        }
    }

    public static abstract class ViewHolder
    extends RecyclerView.ViewHolder {
        final DragSortAdapter<?> adapter;

        public ViewHolder(DragSortAdapter<?> dragSortAdapter, View itemView) {
            super(itemView);
            this.adapter = dragSortAdapter;
        }

        @TargetApi(value=11)
        public final void startDrag() {
            PointF touchPoint = this.adapter.getLastTouchPoint();
            int x = (int)(touchPoint.x - this.itemView.getX());
            int y = (int)(touchPoint.y - this.itemView.getY());
            this.startDrag(this.getShadowBuilder(this.itemView, new Point(x, y)));
        }

        public View.DragShadowBuilder getShadowBuilder(View itemView, Point touchPoint) {
            return new DragSortShadowBuilder(itemView, touchPoint);
        }

        @TargetApi(value=11)
        public final void startDrag(View.DragShadowBuilder dragShadowBuilder) {
            Point shadowSize = new Point();
            Point shadowTouchPoint = new Point();
            dragShadowBuilder.onProvideShadowMetrics(shadowSize, shadowTouchPoint);
            this.itemView.startDrag(null, dragShadowBuilder, (Object)new DragInfo(this.getItemId(), shadowSize, shadowTouchPoint, this.adapter.getLastTouchPoint()), 0);
            this.adapter.notifyItemChanged(this.getAdapterPosition());
        }
    }
}

