/*
 * Decompiled with CFR 0.152.
 */
package com.marshalchen.ultimaterecyclerview;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Rect;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SwipeableRecyclerViewTouchListener
implements RecyclerView.OnItemTouchListener {
    private int mSlop;
    private int mMinFlingVelocity;
    private int mMaxFlingVelocity;
    private long mAnimationTime;
    private RecyclerView mRecyclerView;
    private SwipeListener mSwipeListener;
    private int mViewWidth = 1;
    private List<PendingDismissData> mPendingDismisses = new ArrayList<PendingDismissData>();
    private int mDismissAnimationRefCount = 0;
    private float mAlpha;
    private float mDownX;
    private float mDownY;
    private boolean mSwiping;
    private int mSwipingSlop;
    private VelocityTracker mVelocityTracker;
    private int mDownPosition;
    private int mAnimatingPosition = -1;
    private View mDownView;
    private boolean mPaused;
    private float mFinalDelta;

    public SwipeableRecyclerViewTouchListener(RecyclerView recyclerView, SwipeListener listener) {
        ViewConfiguration vc = ViewConfiguration.get((Context)recyclerView.getContext());
        this.mSlop = vc.getScaledTouchSlop();
        this.mMinFlingVelocity = vc.getScaledMinimumFlingVelocity() * 16;
        this.mMaxFlingVelocity = vc.getScaledMaximumFlingVelocity();
        this.mAnimationTime = recyclerView.getContext().getResources().getInteger(0x10E0000);
        this.mRecyclerView = recyclerView;
        this.mSwipeListener = listener;
        this.mRecyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                SwipeableRecyclerViewTouchListener.this.setEnabled(newState != 1);
            }

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            }
        });
    }

    public void setEnabled(boolean enabled) {
        this.mPaused = !enabled;
    }

    public boolean onInterceptTouchEvent(RecyclerView rv, MotionEvent motionEvent) {
        return this.handleTouchEvent(motionEvent);
    }

    public void onTouchEvent(RecyclerView rv, MotionEvent motionEvent) {
        this.handleTouchEvent(motionEvent);
    }

    public void onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {
    }

    private boolean handleTouchEvent(MotionEvent motionEvent) {
        if (this.mViewWidth < 2) {
            this.mViewWidth = this.mRecyclerView.getWidth();
        }
        switch (motionEvent.getActionMasked()) {
            case 0: {
                if (this.mPaused) break;
                Rect rect = new Rect();
                int childCount = this.mRecyclerView.getChildCount();
                int[] listViewCoords = new int[2];
                this.mRecyclerView.getLocationOnScreen(listViewCoords);
                int x = (int)motionEvent.getRawX() - listViewCoords[0];
                int y = (int)motionEvent.getRawY() - listViewCoords[1];
                for (int i = 0; i < childCount; ++i) {
                    View child2 = this.mRecyclerView.getChildAt(i);
                    child2.getHitRect(rect);
                    if (!rect.contains(x, y)) continue;
                    this.mDownView = child2;
                    break;
                }
                if (this.mDownView == null || this.mAnimatingPosition == this.mRecyclerView.getChildPosition(this.mDownView)) break;
                this.mAlpha = this.mDownView.getAlpha();
                this.mDownX = motionEvent.getRawX();
                this.mDownY = motionEvent.getRawY();
                this.mDownPosition = this.mRecyclerView.getChildPosition(this.mDownView);
                if (this.mSwipeListener.canSwipe(this.mDownPosition)) {
                    this.mVelocityTracker = VelocityTracker.obtain();
                    this.mVelocityTracker.addMovement(motionEvent);
                    break;
                }
                this.mDownView = null;
                break;
            }
            case 3: {
                if (this.mVelocityTracker == null) break;
                if (this.mDownView != null && this.mSwiping) {
                    this.mDownView.animate().translationX(0.0f).alpha(this.mAlpha).setDuration(this.mAnimationTime).setListener(null);
                }
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
                this.mDownX = 0.0f;
                this.mDownY = 0.0f;
                this.mDownView = null;
                this.mDownPosition = -1;
                this.mSwiping = false;
                break;
            }
            case 1: {
                if (this.mVelocityTracker == null) break;
                this.mFinalDelta = motionEvent.getRawX() - this.mDownX;
                this.mVelocityTracker.addMovement(motionEvent);
                this.mVelocityTracker.computeCurrentVelocity(1000);
                float velocityX = this.mVelocityTracker.getXVelocity();
                float absVelocityX = Math.abs(velocityX);
                float absVelocityY = Math.abs(this.mVelocityTracker.getYVelocity());
                boolean dismiss = false;
                boolean dismissRight = false;
                if (Math.abs(this.mFinalDelta) > (float)(this.mViewWidth / 2) && this.mSwiping) {
                    dismiss = true;
                    dismissRight = this.mFinalDelta > 0.0f;
                } else if ((float)this.mMinFlingVelocity <= absVelocityX && absVelocityX <= (float)this.mMaxFlingVelocity && absVelocityY < absVelocityX && this.mSwiping) {
                    dismiss = velocityX < 0.0f == this.mFinalDelta < 0.0f;
                    boolean bl = dismissRight = this.mVelocityTracker.getXVelocity() > 0.0f;
                }
                if (dismiss && this.mDownPosition != this.mAnimatingPosition && this.mDownPosition != -1) {
                    final View downView = this.mDownView;
                    final int downPosition = this.mDownPosition;
                    ++this.mDismissAnimationRefCount;
                    this.mAnimatingPosition = this.mDownPosition;
                    this.mDownView.animate().translationX(dismissRight ? (float)this.mViewWidth : (float)(-this.mViewWidth)).alpha(0.0f).setDuration(this.mAnimationTime).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public void onAnimationEnd(Animator animation) {
                            SwipeableRecyclerViewTouchListener.this.performDismiss(downView, downPosition);
                        }
                    });
                } else {
                    this.mDownView.animate().translationX(0.0f).alpha(this.mAlpha).setDuration(this.mAnimationTime).setListener(null);
                }
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
                this.mDownX = 0.0f;
                this.mDownY = 0.0f;
                this.mDownView = null;
                this.mDownPosition = -1;
                this.mSwiping = false;
                break;
            }
            case 2: {
                if (this.mVelocityTracker == null || this.mPaused) break;
                this.mVelocityTracker.addMovement(motionEvent);
                float deltaX = motionEvent.getRawX() - this.mDownX;
                float deltaY = motionEvent.getRawY() - this.mDownY;
                if (!this.mSwiping && Math.abs(deltaX) > (float)this.mSlop && Math.abs(deltaY) < Math.abs(deltaX) / 2.0f) {
                    this.mSwiping = true;
                    int n = this.mSwipingSlop = deltaX > 0.0f ? this.mSlop : -this.mSlop;
                }
                if (!this.mSwiping) break;
                this.mDownView.setTranslationX(deltaX - (float)this.mSwipingSlop);
                this.mDownView.setAlpha(Math.max(0.0f, Math.min(this.mAlpha, this.mAlpha * (1.0f - Math.abs(deltaX) / (float)this.mViewWidth))));
                return true;
            }
        }
        return false;
    }

    private void performDismiss(final View dismissView, int dismissPosition) {
        final ViewGroup.LayoutParams lp = dismissView.getLayoutParams();
        final int originalLayoutParamsHeight = lp.height;
        int originalHeight = dismissView.getHeight();
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{originalHeight, 1}).setDuration(this.mAnimationTime);
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                --SwipeableRecyclerViewTouchListener.this.mDismissAnimationRefCount;
                if (SwipeableRecyclerViewTouchListener.this.mDismissAnimationRefCount == 0) {
                    Collections.sort(SwipeableRecyclerViewTouchListener.this.mPendingDismisses);
                    int[] dismissPositions = new int[SwipeableRecyclerViewTouchListener.this.mPendingDismisses.size()];
                    for (int i = SwipeableRecyclerViewTouchListener.this.mPendingDismisses.size() - 1; i >= 0; --i) {
                        dismissPositions[i] = ((PendingDismissData)((SwipeableRecyclerViewTouchListener)SwipeableRecyclerViewTouchListener.this).mPendingDismisses.get((int)i)).position;
                    }
                    if (SwipeableRecyclerViewTouchListener.this.mFinalDelta > 0.0f) {
                        SwipeableRecyclerViewTouchListener.this.mSwipeListener.onDismissedBySwipeRight(SwipeableRecyclerViewTouchListener.this.mRecyclerView, dismissPositions);
                    } else {
                        SwipeableRecyclerViewTouchListener.this.mSwipeListener.onDismissedBySwipeLeft(SwipeableRecyclerViewTouchListener.this.mRecyclerView, dismissPositions);
                    }
                    SwipeableRecyclerViewTouchListener.this.mDownPosition = -1;
                    for (PendingDismissData pendingDismiss : SwipeableRecyclerViewTouchListener.this.mPendingDismisses) {
                        pendingDismiss.view.setAlpha(SwipeableRecyclerViewTouchListener.this.mAlpha);
                        pendingDismiss.view.setTranslationX(0.0f);
                        ViewGroup.LayoutParams lp = pendingDismiss.view.getLayoutParams();
                        lp.height = originalLayoutParamsHeight;
                        pendingDismiss.view.setLayoutParams(lp);
                    }
                    long time = SystemClock.uptimeMillis();
                    MotionEvent cancelEvent = MotionEvent.obtain((long)time, (long)time, (int)3, (float)0.0f, (float)0.0f, (int)0);
                    SwipeableRecyclerViewTouchListener.this.mRecyclerView.dispatchTouchEvent(cancelEvent);
                    SwipeableRecyclerViewTouchListener.this.mPendingDismisses.clear();
                    SwipeableRecyclerViewTouchListener.this.mAnimatingPosition = -1;
                }
            }
        });
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                lp.height = (Integer)valueAnimator.getAnimatedValue();
                dismissView.setLayoutParams(lp);
            }
        });
        this.mPendingDismisses.add(new PendingDismissData(dismissPosition, dismissView));
        animator.start();
    }

    class PendingDismissData
    implements Comparable<PendingDismissData> {
        public int position;
        public View view;

        public PendingDismissData(int position, View view) {
            this.position = position;
            this.view = view;
        }

        @Override
        public int compareTo(@NonNull PendingDismissData other) {
            return other.position - this.position;
        }
    }

    public static interface SwipeListener {
        public boolean canSwipe(int var1);

        public void onDismissedBySwipeLeft(RecyclerView var1, int[] var2);

        public void onDismissedBySwipeRight(RecyclerView var1, int[] var2);
    }
}

