/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.rest.util.configurer;

import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.client.ext.ssl.SslUtil;
import com.marklogic.rest.util.HttpClientBuilderConfigurer;
import com.marklogic.rest.util.RestConfig;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.HttpClientBuilder;

public class SslConfigurer
extends LoggingObject
implements HttpClientBuilderConfigurer {
    @Override
    public HttpClientBuilder configureHttpClientBuilder(RestConfig config, HttpClientBuilder httpClientBuilder) {
        SSLContext sslContext = null;
        if (config.getSslContext() != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Using custom SSLContext for connecting to: " + config.getBaseUrl());
            }
            sslContext = config.getSslContext();
        } else if (config.isUseDefaultKeystore()) {
            sslContext = this.buildSslContextViaTrustManagerFactory(config);
        } else if (config.isConfigureSimpleSsl()) {
            sslContext = this.buildSimpleSslContext(config);
        }
        if (sslContext != null) {
            httpClientBuilder.setSslcontext(sslContext);
            if (config.getHostnameVerifier() != null) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Using custom X509HostnameVerifier for connecting to: " + config.getBaseUrl());
                }
                httpClientBuilder.setHostnameVerifier(config.getHostnameVerifier());
            } else {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Using 'allow all' X509HostnameVerifier for connecting to: " + config.getBaseUrl());
                }
                httpClientBuilder.setHostnameVerifier((X509HostnameVerifier)new AllowAllHostnameVerifier());
            }
        }
        return httpClientBuilder;
    }

    protected SSLContext buildSslContextViaTrustManagerFactory(RestConfig config) {
        String protocol = this.determineProtocol(config);
        String algorithm = config.getTrustManagementAlgorithm();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Using default keystore with SSL protocol " + protocol + " for connecting to: " + config.getBaseUrl());
        }
        return SslUtil.configureUsingTrustManagerFactory((String)protocol, (String)algorithm).getSslContext();
    }

    protected SSLContext buildSimpleSslContext(RestConfig config) {
        String protocol = this.determineProtocol(config);
        SSLContextBuilder builder = new SSLContextBuilder().useProtocol(protocol);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Configuring simple SSL approach with protocol " + protocol + " for connecting to: " + config.getBaseUrl());
        }
        try {
            return builder.loadTrustMaterial(null, (chain, authType) -> true).build();
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to configure simple SSLContext for connecting to: " + config.getBaseUrl() + ", cause: " + ex.getMessage(), ex);
        }
    }

    protected String determineProtocol(RestConfig config) {
        String protocol = config.getSslProtocol();
        if (StringUtils.isEmpty((CharSequence)protocol)) {
            protocol = "TLSv1.2";
        }
        return protocol;
    }
}

