/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.resource.security;

import com.marklogic.mgmt.AbstractManager;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.rest.util.ResourcesFragment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class CertificateAuthorityManager
extends AbstractManager {
    private ManageClient manageClient;

    public CertificateAuthorityManager(ManageClient client) {
        this.manageClient = client;
    }

    @Override
    protected boolean useSecurityUser() {
        return true;
    }

    public ResponseEntity<String> create(String payload) {
        RestTemplate t = this.manageClient.getRestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.TEXT_PLAIN);
        HttpEntity entity = new HttpEntity((Object)payload, (MultiValueMap)headers);
        ResponseEntity response = t.exchange(this.manageClient.buildUri("/manage/v2/certificate-authorities"), HttpMethod.POST, entity, String.class);
        return response;
    }

    public ResourcesFragment getAsXml() {
        return new ResourcesFragment(this.manageClient.getXml("/manage/v2/certificate-authorities", new String[0]));
    }

    public void delete(String resourceIdOrName) {
        this.manageClient.delete("/manage/v2/certificate-authorities/" + resourceIdOrName);
    }
}

