/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.resource.groups;

import com.marklogic.mgmt.DeleteReceipt;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.resource.AbstractResourceManager;
import com.marklogic.rest.util.Fragment;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class GroupManager
extends AbstractResourceManager {
    public GroupManager(ManageClient manageClient) {
        super(manageClient);
    }

    @Override
    protected boolean useSecurityUser() {
        return true;
    }

    @Override
    public DeleteReceipt delete(String payload, String ... resourceUrlParams) {
        String resourceId = this.getResourceId(payload);
        if (resourceId != null && resourceId.toUpperCase().equals("DEFAULT")) {
            return new DeleteReceipt(resourceId, null, false);
        }
        return super.delete(payload, new String[0]);
    }

    public List<String> getHostNames(String groupName) {
        String path = super.getResourcePath(groupName, new String[0]);
        Fragment xml = this.getManageClient().getXml(path, new String[0]);
        ArrayList<String> hostNames = new ArrayList<String>();
        Namespace ns = Namespace.getNamespace((String)"http://marklogic.com/manage/groups");
        for (Element el : xml.getElements("/g:group-default/g:relations/g:relation-group[g:typeref = 'hosts']/g:relation")) {
            String hostName = el.getChildText("nameref", ns);
            hostNames.add(hostName);
        }
        return hostNames;
    }

    public Map<String, String> getHostIdsAndNames(String groupName) {
        String path = super.getResourcePath(groupName, new String[0]);
        Fragment xml = this.getManageClient().getXml(path, new String[0]);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Namespace ns = Namespace.getNamespace((String)"http://marklogic.com/manage/groups");
        for (Element el : xml.getElements("/g:group-default/g:relations/g:relation-group[g:typeref = 'hosts']/g:relation")) {
            String hostId = el.getChildText("idref", ns);
            String hostName = el.getChildText("nameref", ns);
            map.put(hostId, hostName);
        }
        return map;
    }
}

