/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.resource.appservers;

import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.resource.AbstractResourceManager;
import com.marklogic.rest.util.Fragment;
import com.marklogic.rest.util.ResourcesFragment;

public class ServerManager
extends AbstractResourceManager {
    public static final String DEFAULT_GROUP = "Default";
    private String groupName;

    public ServerManager(ManageClient manageClient) {
        this(manageClient, DEFAULT_GROUP);
    }

    public ServerManager(ManageClient manageClient, String groupName) {
        super(manageClient);
        this.groupName = groupName != null ? groupName : DEFAULT_GROUP;
    }

    @Override
    public boolean useSecurityUser(String payload) {
        boolean b;
        boolean bl = b = payload != null && payload.contains("external-security");
        if (b && this.logger.isInfoEnabled()) {
            this.logger.info("Server payload contains external-security, so using the security user");
        }
        return b;
    }

    @Override
    public boolean exists(String resourceNameOrId, String ... resourceUrlParams) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Checking for existence of resource: " + resourceNameOrId);
        }
        Object path = this.getResourcesPath();
        if (this.groupName != null) {
            path = (String)path + "?group-id=" + this.groupName;
        }
        Fragment f = this.useSecurityUser() ? this.getManageClient().getXmlAsSecurityUser((String)path, new String[0]) : this.getManageClient().getXml((String)path, new String[0]);
        return new ResourcesFragment(f).resourceExists(resourceNameOrId);
    }

    @Override
    protected String getCreateResourcePath(String payload) {
        Object path = super.getCreateResourcePath(payload);
        if (this.groupName != null) {
            path = (String)path + "?group-id=" + this.groupName;
        }
        return path;
    }

    @Override
    public String getResourcePath(String resourceNameOrId, String ... resourceUrlParams) {
        return this.format("%s/%s?group-id=%s", new Object[]{this.getResourcesPath(), resourceNameOrId, this.groupName});
    }

    @Override
    public String getPropertiesPath(String resourceNameOrId, String ... resourceUrlParams) {
        return this.format("%s/%s/properties?group-id=%s", new Object[]{this.getResourcesPath(), resourceNameOrId, this.groupName});
    }

    public void setModulesDatabaseToDocuments(String serverName) {
        String payload = this.format("{\"server-name\":\"%s\", \"group-name\": \"%s\", \"modules-database\":\"Documents\"}", new Object[]{serverName, this.groupName});
        this.save(payload);
    }
}

