/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.api.security;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.marklogic.mgmt.api.API;
import com.marklogic.mgmt.api.Resource;
import com.marklogic.mgmt.api.security.Permission;
import com.marklogic.mgmt.api.security.RolePrivilege;
import com.marklogic.mgmt.resource.ResourceManager;
import com.marklogic.mgmt.resource.security.RoleManager;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="role-properties")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Role
extends Resource {
    @XmlElement(name="role-name")
    private String roleName;
    private String description;
    private String compartment;
    @XmlElementWrapper(name="external-names")
    @XmlElement(name="external-name")
    private List<String> externalName;
    @XmlElementWrapper(name="roles")
    private List<String> role;
    @XmlElementWrapper(name="permissions")
    private List<Permission> permission;
    @XmlElementWrapper(name="privileges")
    private List<RolePrivilege> privilege;
    @XmlElementWrapper(name="collections")
    private List<String> collection;

    public Role() {
    }

    public Role(String roleName) {
        this(null, roleName);
    }

    public Role(API api, String roleName) {
        super(api);
        this.roleName = roleName;
    }

    public boolean hasPermissionsOrRoles() {
        return this.role != null && !this.role.isEmpty() || this.permission != null && !this.permission.isEmpty();
    }

    @JsonIgnore
    public List<String> getDependentRoleNames() {
        ArrayList<String> names = new ArrayList<String>();
        if (this.role != null) {
            names.addAll(this.role);
        }
        if (this.permission != null) {
            this.permission.forEach(p -> {
                if (!names.contains(p.getRoleName())) {
                    names.add(p.getRoleName());
                }
            });
        }
        return names;
    }

    public void clearPermissionsAndRoles() {
        if (this.role != null) {
            this.role.clear();
            this.role = null;
        }
        if (this.permission != null) {
            this.permission.clear();
            this.permission = null;
        }
    }

    public boolean hasPermissionWithOwnRoleName() {
        return this.hasPermissionWithRoleName(this.roleName);
    }

    public boolean hasPermissionWithRoleName(String someRoleName) {
        if (this.permission != null && someRoleName != null) {
            for (Permission perm : this.permission) {
                if (!someRoleName.equals(perm.getRoleName())) continue;
                return true;
            }
        }
        return false;
    }

    public void addExternalName(String name) {
        if (this.externalName == null) {
            this.externalName = new ArrayList<String>();
        }
        this.externalName.add(name);
    }

    public void addRole(String r) {
        if (this.role == null) {
            this.role = new ArrayList<String>();
        }
        this.role.add(r);
    }

    public void addPermission(Permission p) {
        if (this.permission == null) {
            this.permission = new ArrayList<Permission>();
        }
        this.permission.add(p);
    }

    public void addPrivilege(RolePrivilege priv) {
        if (this.privilege == null) {
            this.privilege = new ArrayList<RolePrivilege>();
        }
        this.privilege.add(priv);
    }

    public void addCollection(String c) {
        if (this.collection == null) {
            this.collection = new ArrayList<String>();
        }
        this.collection.add(c);
    }

    @Override
    protected ResourceManager getResourceManager() {
        return new RoleManager(this.getClient());
    }

    @Override
    protected String getResourceId() {
        return this.roleName;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCompartment() {
        return this.compartment;
    }

    public void setCompartment(String compartment) {
        this.compartment = compartment;
    }

    public List<String> getExternalName() {
        return this.externalName;
    }

    public void setExternalName(List<String> externalName) {
        this.externalName = externalName;
    }

    public List<String> getRole() {
        return this.role;
    }

    public void setRole(List<String> role) {
        this.role = role;
    }

    public List<Permission> getPermission() {
        return this.permission;
    }

    public void setPermission(List<Permission> permission) {
        this.permission = permission;
    }

    public List<RolePrivilege> getPrivilege() {
        return this.privilege;
    }

    public void setPrivilege(List<RolePrivilege> privilege) {
        this.privilege = privilege;
    }

    public List<String> getCollection() {
        return this.collection;
    }

    public void setCollection(List<String> collection) {
        this.collection = collection;
    }
}

