/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.api.security;

import com.marklogic.mgmt.api.API;
import com.marklogic.mgmt.api.Resource;
import com.marklogic.mgmt.resource.ResourceManager;
import com.marklogic.mgmt.resource.security.PrivilegeManager;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="privilege-properties")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Privilege
extends Resource {
    @XmlElement(name="privilege-name")
    private String privilegeName;
    private String action;
    private String kind;
    @XmlElementWrapper(name="roles")
    private List<String> role;

    public Privilege() {
    }

    public Privilege(API api, String privilegeName) {
        super(api);
        this.privilegeName = privilegeName;
    }

    public void addRole(String r) {
        if (this.role == null) {
            this.role = new ArrayList<String>();
        }
        this.role.add(r);
    }

    @Override
    protected ResourceManager getResourceManager() {
        return new PrivilegeManager(this.getClient());
    }

    @Override
    protected String getResourceId() {
        return this.privilegeName;
    }

    public String getPrivilegeName() {
        return this.privilegeName;
    }

    public void setPrivilegeName(String privilegeName) {
        this.privilegeName = privilegeName;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public List<String> getRole() {
        return this.role;
    }

    public void setRole(List<String> role) {
        this.role = role;
    }
}

