/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.api.restapi;

import com.marklogic.mgmt.api.API;
import com.marklogic.mgmt.api.ApiObject;
import com.marklogic.mgmt.resource.restapis.RestApiManager;
import org.springframework.http.ResponseEntity;

public class RestApi
extends ApiObject {
    private String name;
    private String group;
    private String database;
    private String modulesDatabase;
    private Integer port;
    private Boolean xdbcEnabled;
    private Integer forestsPerHost;
    private String errorFormat;
    private API api;

    public RestApi(API api, String name) {
        this.api = api;
        this.name = name;
    }

    @Override
    public String getJson() {
        return String.format("{\"rest-api\":%s}", super.getJson());
    }

    public String save() {
        ResponseEntity<String> re = new RestApiManager(this.api.getManageClient(), this.group).createRestApi(this.name, this.getJson());
        if (re == null) {
            return String.format("REST API with name %s already exists", this.name);
        }
        return String.format("Created REST API with name %s", this.name);
    }

    public void delete() {
        this.delete(true, true);
    }

    public String delete(boolean deleteContent, boolean deleteModules) {
        String path = "/v1/rest-apis/" + this.name + "?";
        if (deleteContent) {
            path = path + "include=content";
        }
        if (deleteModules) {
            path = path + "&include=modules";
        }
        this.api.getManageClient().delete(path);
        return "Deleted REST API at path: " + path;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getModulesDatabase() {
        return this.modulesDatabase;
    }

    public void setModulesDatabase(String modulesDatabase) {
        this.modulesDatabase = modulesDatabase;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Boolean getXdbcEnabled() {
        return this.xdbcEnabled;
    }

    public void setXdbcEnabled(Boolean xdbcEnabled) {
        this.xdbcEnabled = xdbcEnabled;
    }

    public Integer getForestsPerHost() {
        return this.forestsPerHost;
    }

    public void setForestsPerHost(Integer forestsPerHost) {
        this.forestsPerHost = forestsPerHost;
    }

    public String getErrorFormat() {
        return this.errorFormat;
    }

    public void setErrorFormat(String errorFormat) {
        this.errorFormat = errorFormat;
    }
}

