/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.api.mimetypes;

import com.marklogic.mgmt.api.Resource;
import com.marklogic.mgmt.resource.ResourceManager;
import com.marklogic.mgmt.resource.mimetypes.MimetypeManager;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.builder.EqualsBuilder;

@XmlRootElement(name="mimetype-properties")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Mimetype
extends Resource {
    private String name;
    @XmlElementWrapper(name="extensions")
    @XmlElement(name="extension")
    private Set<String> extension;
    private String format;

    public Mimetype() {
    }

    public Mimetype(String name, String format, String ... extensions) {
        this();
        this.name = name;
        this.format = format;
        this.extension = new HashSet<String>();
        this.extension.addAll(Arrays.asList(extensions));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Mimetype)) {
            return false;
        }
        Mimetype other = (Mimetype)obj;
        return new EqualsBuilder().append((Object)this.name, (Object)other.name).append(this.extension, other.extension).append((Object)this.format, (Object)other.format).isEquals();
    }

    @Override
    protected ResourceManager getResourceManager() {
        return new MimetypeManager(this.getClient());
    }

    @Override
    protected String getResourceId() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<String> getExtension() {
        return this.extension;
    }

    public void setExtension(Set<String> extension) {
        this.extension = extension;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }
}

