/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.api.configuration;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.api.ApiObject;
import com.marklogic.mgmt.api.configuration.Configuration;
import com.marklogic.mgmt.cma.ConfigurationManager;
import com.marklogic.mgmt.util.ObjectMapperFactory;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configurations
extends ApiObject {
    private String name;
    private String desc;
    private String user;
    private String group;
    private String host;
    private String platform;
    private String ts;
    private String version;
    @JsonProperty(value="config")
    private List<Configuration> configs = new ArrayList<Configuration>();

    public Configurations() {
        this.setObjectMapper(ObjectMapperFactory.getObjectMapper());
    }

    public Configurations(Configuration ... configs) {
        this();
        for (Configuration c : configs) {
            this.addConfig(c);
        }
    }

    public Configurations(List<Configuration> configs) {
        this();
        this.configs = configs;
    }

    public void addConfig(Configuration config) {
        if (this.configs == null) {
            this.configs = new ArrayList<Configuration>();
        }
        this.configs.add(config);
    }

    public boolean hasResources() {
        if (this.configs == null || this.configs.isEmpty()) {
            return false;
        }
        for (Configuration c : this.configs) {
            if (!c.hasResources()) continue;
            return true;
        }
        return false;
    }

    public void submit(ManageClient manageClient) {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        if (!this.hasResources()) {
            logger.info("No resources are present in this set of CMA configurations, so nothing will be submitted");
            return;
        }
        String json = this.getJson();
        if (logger.isInfoEnabled()) {
            if (json.contains("password")) {
                logger.info("Submitting configuration (not logging because it contains the word 'password')");
            } else {
                logger.info("Submitting configuration: " + json);
            }
        }
        new ConfigurationManager(manageClient).submit(json);
        if (logger.isInfoEnabled()) {
            logger.info("Successfully submitted configuration");
        }
    }

    public List<Configuration> getConfigs() {
        return this.configs;
    }

    public void setConfigs(List<Configuration> configs) {
        this.configs = configs;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getTs() {
        return this.ts;
    }

    public void setTs(String ts) {
        this.ts = ts;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

