/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt;

import com.fasterxml.jackson.databind.JsonNode;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.mgmt.ManageConfig;
import com.marklogic.mgmt.PayloadParser;
import com.marklogic.mgmt.util.ObjectMapperFactory;
import com.marklogic.rest.util.Fragment;
import com.marklogic.rest.util.RestConfig;
import com.marklogic.rest.util.RestTemplateUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import org.jdom2.Namespace;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class ManageClient
extends LoggingObject {
    private ManageConfig manageConfig;
    private RestTemplate restTemplate;
    private RestTemplate securityUserRestTemplate;
    private PayloadParser payloadParser;

    public ManageClient() {
        this(new ManageConfig());
    }

    public ManageClient(ManageConfig config) {
        this.setManageConfig(config);
    }

    public void setManageConfig(ManageConfig config) {
        this.manageConfig = config;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Initializing ManageClient with manage config of: " + config);
        }
        this.restTemplate = RestTemplateUtil.newRestTemplate(config);
        String securityUsername = config.getSecurityUsername();
        if (securityUsername != null && securityUsername.trim().length() > 0 && !securityUsername.equals(config.getUsername())) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(this.format("Initializing separate connection to Manage API with user '%s' that should have the 'manage-admin' and 'security' roles", new Object[]{securityUsername}));
            }
            RestConfig rc = new RestConfig(config.getHost(), config.getPort(), securityUsername, config.getSecurityPassword());
            rc.setScheme(config.getScheme());
            rc.setConfigureSimpleSsl(config.isConfigureSimpleSsl());
            rc.setHostnameVerifier(config.getHostnameVerifier());
            if (config.getSecuritySslContext() != null) {
                rc.setSslContext(config.getSecuritySslContext());
            } else {
                rc.setSslContext(config.getSslContext());
            }
            this.securityUserRestTemplate = RestTemplateUtil.newRestTemplate(rc);
        } else {
            this.securityUserRestTemplate = this.restTemplate;
        }
    }

    public ManageClient(RestTemplate restTemplate) {
        this(restTemplate, restTemplate);
    }

    public ManageClient(RestTemplate restTemplate, RestTemplate adminRestTemplate) {
        this.restTemplate = restTemplate;
        this.securityUserRestTemplate = adminRestTemplate;
    }

    public ResponseEntity<String> putJson(String path, String json) {
        this.logRequest(path, "JSON", "PUT");
        return this.restTemplate.exchange(this.buildUri(path), HttpMethod.PUT, this.buildJsonEntity(json), String.class);
    }

    public ResponseEntity<String> putJsonAsSecurityUser(String path, String json) {
        this.logSecurityUserRequest(path, "JSON", "PUT");
        return this.securityUserRestTemplate.exchange(this.buildUri(path), HttpMethod.PUT, this.buildJsonEntity(json), String.class);
    }

    public ResponseEntity<String> putXml(String path, String xml) {
        this.logRequest(path, "XML", "PUT");
        return this.restTemplate.exchange(this.buildUri(path), HttpMethod.PUT, this.buildXmlEntity(xml), String.class);
    }

    public ResponseEntity<String> putXmlAsSecurityUser(String path, String xml) {
        this.logSecurityUserRequest(path, "XML", "PUT");
        return this.securityUserRestTemplate.exchange(this.buildUri(path), HttpMethod.PUT, this.buildXmlEntity(xml), String.class);
    }

    public ResponseEntity<String> postJson(String path, String json) {
        this.logRequest(path, "JSON", "POST");
        return this.restTemplate.exchange(this.buildUri(path), HttpMethod.POST, this.buildJsonEntity(json), String.class);
    }

    public ResponseEntity<String> postJsonAsSecurityUser(String path, String json) {
        this.logSecurityUserRequest(path, "JSON", "POST");
        return this.securityUserRestTemplate.exchange(this.buildUri(path), HttpMethod.POST, this.buildJsonEntity(json), String.class);
    }

    public ResponseEntity<String> postXml(String path, String xml) {
        this.logRequest(path, "XML", "POST");
        return this.restTemplate.exchange(this.buildUri(path), HttpMethod.POST, this.buildXmlEntity(xml), String.class);
    }

    public ResponseEntity<String> postXmlAsSecurityUser(String path, String xml) {
        this.logSecurityUserRequest(path, "XML", "POST");
        return this.securityUserRestTemplate.exchange(this.buildUri(path), HttpMethod.POST, this.buildXmlEntity(xml), String.class);
    }

    public ResponseEntity<String> postForm(String path, String ... params) {
        this.logRequest(path, "form", "POST");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        for (int i = 0; i < params.length; i += 2) {
            map.add((Object)params[i], (Object)params[i + 1]);
        }
        HttpEntity entity = new HttpEntity((Object)map, (MultiValueMap)headers);
        return this.restTemplate.exchange(this.buildUri(path), HttpMethod.POST, entity, String.class);
    }

    public String getXmlString(String path) {
        this.logRequest(path, "XML", "GET");
        return (String)this.getRestTemplate().getForObject(this.buildUri(path), String.class);
    }

    public Fragment getXml(String path, String ... namespacePrefixesAndUris) {
        String xml = this.getXmlString(path);
        ArrayList<Namespace> list = new ArrayList<Namespace>();
        for (int i = 0; i < namespacePrefixesAndUris.length; i += 2) {
            list.add(Namespace.getNamespace((String)namespacePrefixesAndUris[i], (String)namespacePrefixesAndUris[i + 1]));
        }
        return new Fragment(xml, list.toArray(new Namespace[0]));
    }

    public String getXmlStringAsSecurityUser(String path) {
        this.logSecurityUserRequest(path, "XML", "GET");
        return (String)this.securityUserRestTemplate.getForObject(this.buildUri(path), String.class);
    }

    public Fragment getXmlAsSecurityUser(String path, String ... namespacePrefixesAndUris) {
        String xml = this.getXmlStringAsSecurityUser(path);
        ArrayList<Namespace> list = new ArrayList<Namespace>();
        for (int i = 0; i < namespacePrefixesAndUris.length; i += 2) {
            list.add(Namespace.getNamespace((String)namespacePrefixesAndUris[i], (String)namespacePrefixesAndUris[i + 1]));
        }
        return new Fragment(xml, list.toArray(new Namespace[0]));
    }

    public String getJson(String path) {
        return (String)this.getJson(path, String.class).getBody();
    }

    public JsonNode getJsonNode(String path) {
        return (JsonNode)this.getJson(path, JsonNode.class).getBody();
    }

    protected <T> ResponseEntity<T> getJson(String path, Class<T> responseType) {
        this.logRequest(path, "JSON", "GET");
        HttpHeaders headers = new HttpHeaders();
        headers.set("Accept", "application/json");
        return this.getRestTemplate().exchange(this.buildUri(path), HttpMethod.GET, new HttpEntity((MultiValueMap)headers), responseType);
    }

    public String getJson(URI uri) {
        this.logRequest(uri.toString(), "JSON", "GET");
        HttpHeaders headers = new HttpHeaders();
        headers.set("Accept", "application/json");
        return (String)this.getRestTemplate().exchange(uri, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), String.class).getBody();
    }

    public String getJsonAsSecurityUser(String path) {
        this.logSecurityUserRequest(path, "JSON", "GET");
        HttpHeaders headers = new HttpHeaders();
        headers.set("Accept", "application/json");
        return (String)this.securityUserRestTemplate.exchange(this.buildUri(path), HttpMethod.GET, new HttpEntity((MultiValueMap)headers), String.class).getBody();
    }

    public void delete(String path) {
        this.logRequest(path, "", "DELETE");
        this.restTemplate.delete(this.buildUri(path));
    }

    public void deleteAsSecurityUser(String path) {
        this.logSecurityUserRequest(path, "", "DELETE");
        this.securityUserRestTemplate.delete(this.buildUri(path));
    }

    public HttpEntity<String> buildJsonEntity(String json) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        if (this.manageConfig != null && this.manageConfig.isCleanJsonPayloads()) {
            json = this.cleanJsonPayload(json);
        }
        return new HttpEntity((Object)json, (MultiValueMap)headers);
    }

    protected String cleanJsonPayload(String payload) {
        if (this.payloadParser == null) {
            this.payloadParser = new PayloadParser();
        }
        JsonNode node = this.payloadParser.parseJson(payload);
        StringWriter sw = new StringWriter();
        try {
            ObjectMapperFactory.getObjectMapper().writer().writeValue((Writer)sw, (Object)node);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to write JSON payload as JsonNode back out to a string, cause: " + ex.getMessage());
        }
        return sw.toString();
    }

    public HttpEntity<String> buildXmlEntity(String xml) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_XML);
        return new HttpEntity((Object)xml, (MultiValueMap)headers);
    }

    protected void logRequest(String path, String contentType, String method) {
        if (this.logger.isInfoEnabled()) {
            String username = this.manageConfig != null ? this.manageConfig.getUsername() : "(unknown)";
            this.logger.info(String.format("Sending %s %s request as user '%s' to path: %s", contentType, method, username, path));
        }
    }

    protected void logSecurityUserRequest(String path, String contentType, String method) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(String.format("Sending %s %s request as user '%s' (who should have the 'manage-admin' and 'security' roles) to path: %s", contentType, method, this.determineUsernameForSecurityUserRequest(), path));
        }
    }

    protected String determineUsernameForSecurityUserRequest() {
        String username = "(unknown)";
        if (this.manageConfig != null && StringUtils.isEmpty((Object)(username = this.manageConfig.getSecurityUsername()))) {
            username = this.manageConfig.getUsername();
        }
        return username;
    }

    public URI buildUri(String path) {
        return this.manageConfig.buildUri(path);
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public ManageConfig getManageConfig() {
        return this.manageConfig;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public RestTemplate getSecurityUserRestTemplate() {
        return this.securityUserRestTemplate;
    }

    public void setSecurityUserRestTemplate(RestTemplate restTemplate) {
        this.securityUserRestTemplate = restTemplate;
    }
}

