/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt;

import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.PayloadParser;
import org.springframework.http.ResponseEntity;
import org.springframework.util.ClassUtils;

public class AbstractManager
extends LoggingObject {
    protected PayloadParser payloadParser = new PayloadParser();

    protected boolean useSecurityUser() {
        return false;
    }

    protected boolean useSecurityUser(String payload) {
        return this.useSecurityUser();
    }

    protected String getResourceName() {
        String name = ClassUtils.getShortName(((Object)((Object)this)).getClass());
        name = name.replace("Manager", "");
        return name.toLowerCase();
    }

    protected String getIdFieldName() {
        return this.getResourceName() + "-name";
    }

    protected String getResourceId(String payload) {
        return this.payloadParser.getPayloadFieldValue(payload, this.getIdFieldName());
    }

    protected ResponseEntity<String> putPayload(ManageClient client, String path, String payload) {
        boolean requiresSecurityUser = this.useSecurityUser(payload);
        try {
            if (this.payloadParser.isJsonPayload(payload)) {
                return requiresSecurityUser ? client.putJsonAsSecurityUser(path, payload) : client.putJson(path, payload);
            }
            return requiresSecurityUser ? client.putXmlAsSecurityUser(path, payload) : client.putXml(path, payload);
        }
        catch (RuntimeException ex) {
            this.logger.error(this.format("Error occurred while sending PUT request to %s; logging request body to assist with debugging: %s", new Object[]{path, payload}));
            throw ex;
        }
    }

    protected ResponseEntity<String> postPayload(ManageClient client, String path, String payload) {
        boolean requiresSecurityUser = this.useSecurityUser(payload);
        try {
            if (this.payloadParser.isJsonPayload(payload)) {
                return requiresSecurityUser ? client.postJsonAsSecurityUser(path, payload) : client.postJson(path, payload);
            }
            return requiresSecurityUser ? client.postXmlAsSecurityUser(path, payload) : client.postXml(path, payload);
        }
        catch (RuntimeException ex) {
            this.logger.error(this.format("Error occurred while sending POST request to %s; logging request body to assist with debugging: %s", new Object[]{path, payload}));
            throw ex;
        }
    }
}

