/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.impl;

import com.marklogic.appdeployer.command.Command;
import com.marklogic.appdeployer.impl.AbstractAppDeployer;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.admin.AdminManager;
import java.util.ArrayList;
import java.util.List;

public class SimpleAppDeployer
extends AbstractAppDeployer {
    private List<Command> commands;

    public SimpleAppDeployer(Command ... commandArray) {
        this.buildModifiableCommandList(commandArray);
    }

    public SimpleAppDeployer(ManageClient manageClient, AdminManager adminManager, Command ... commandArray) {
        super(manageClient, adminManager);
        this.buildModifiableCommandList(commandArray);
    }

    protected void buildModifiableCommandList(Command ... commandArray) {
        if (commandArray != null) {
            this.commands = new ArrayList<Command>(commandArray.length);
            for (Command c : commandArray) {
                this.commands.add(c);
            }
        } else {
            this.commands = new ArrayList<Command>();
        }
    }

    public Command getCommandOfType(Class<?> clazz) {
        for (Command c : this.commands) {
            if (!c.getClass().equals(clazz)) continue;
            return c;
        }
        return null;
    }

    public Command getCommand(String shortClassName) {
        for (Command c : this.commands) {
            if (!c.getClass().getSimpleName().equals(shortClassName)) continue;
            return c;
        }
        return null;
    }

    public Command removeCommand(String shortClassName) {
        for (Command c : this.commands) {
            if (!c.getClass().getSimpleName().equals(shortClassName)) continue;
            this.commands.remove(c);
            return c;
        }
        return null;
    }

    @Override
    public List<Command> getCommands() {
        return this.commands;
    }

    public void setCommands(List<Command> commands) {
        this.commands = commands;
    }
}

